/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.realtime.service;

import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IExecuteReplicaCalculator;
import com.huawei.ism.drm.protection.replica.sdk.service.IRealTimeReplicaBuilder;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExecuteReplicaManager {
    private static final ExecuteReplicaManager INSTANCE = new ExecuteReplicaManager();
    private static Map<PolicyTemplateType.POLICY_TEMPLATE_E, IRealTimeReplicaBuilder> realTimeContainer = new HashMap<PolicyTemplateType.POLICY_TEMPLATE_E, IRealTimeReplicaBuilder>();
    private static Map<PolicyTemplateType.POLICY_TEMPLATE_E, IExecuteReplicaCalculator> calculatorContainer = new HashMap<PolicyTemplateType.POLICY_TEMPLATE_E, IExecuteReplicaCalculator>();
    private static Log logger = LogFactory.getInstance(ExecuteReplicaManager.class);

    private ExecuteReplicaManager() {
    }

    public static ExecuteReplicaManager getInstance() {
        return INSTANCE;
    }

    public void onBindRealTimeBuilder(IRealTimeReplicaBuilder builder, Map<?, ?> properties) {
        realTimeContainer.put(builder.getType(), builder);
    }

    public void unBindRealTimeBuilder(IRealTimeReplicaBuilder builder, Map<?, ?> properties) {
        if (realTimeContainer.containsKey(builder.getType())) {
            realTimeContainer.remove(builder.getType());
        }
    }

    public void onBindReplicaCalculator(IExecuteReplicaCalculator calculator, Map<?, ?> properties) {
        for (PolicyTemplateType.POLICY_TEMPLATE_E template : calculator.getSupportPolicyTemplate()) {
            calculatorContainer.put(template, calculator);
        }
    }

    public void unBindReplicaCalculator(IExecuteReplicaCalculator calculator) {
        for (PolicyTemplateType.POLICY_TEMPLATE_E template : calculator.getSupportPolicyTemplate()) {
            if (!calculatorContainer.containsKey(template)) continue;
            realTimeContainer.remove(calculator);
        }
    }

    public ProtectGroupReplica buildRealTimeReplica(ProtectGroup pg, int protectLocation) {
        PolicyTemplateType.POLICY_TEMPLATE_E type = this.getPolicyTemplate(pg.getTemplate().getType());
        if (realTimeContainer.containsKey(type)) {
            ProtectGroupReplica replica = realTimeContainer.get(type).buildReplica(pg, protectLocation);
            if (replica.getType() == 4 || replica.getType() == 103) {
                replica.setName("HYPERCDP-" + pg.getName() + "-" + Calendar.getInstance().getTimeInMillis());
            }
            if (replica.getType() == 102 || Boolean.parseBoolean((String)replica.getProps().get("isNeedSecureSnapshot"))) {
                replica.setName("SECURE-SNAPSHOT-" + pg.getName() + "-" + Calendar.getInstance().getTimeInMillis());
            }
            return replica;
        }
        logger.error((Object)("cannot find type in container, type" + (null == type ? "null" : Integer.valueOf(type.getValue()))));
        return null;
    }

    public void callBackReplica(int policyType, ProtectGroupReplica replica) {
        IRealTimeReplicaBuilder iRealTimeReplicaBuilder = realTimeContainer.get(this.getPolicyTemplate(policyType));
        if (null == iRealTimeReplicaBuilder) {
            logger.error((Object)("iRealTimeReplicaBuilder is null.policyType:" + policyType));
            throw new LegoCheckedException(1073947394L);
        }
        iRealTimeReplicaBuilder.callBackReplica(replica);
    }

    public ProtectGroupReplica calculateExecuteReplica(ProtectGroup pg, int protectLocation) {
        PolicyTemplateType.POLICY_TEMPLATE_E type = this.getPolicyTemplate(pg.getTemplate().getType());
        if (calculatorContainer.containsKey(type)) {
            return calculatorContainer.get(type).calculateExecutedReplica(pg, protectLocation);
        }
        logger.error((Object)("cannot find type in container, type" + (null == type ? "null" : Integer.valueOf(type.getValue()))));
        return null;
    }

    public ProtectGroupReplica getExecuteReplica(ProtectGroup pg, int protectLocation) {
        if (this.getRealTimeReplicaPolicyType().contains(pg.getTemplate().getType())) {
            return this.buildRealTimeReplica(pg, protectLocation);
        }
        return this.calculateExecuteReplica(pg, protectLocation);
    }

    private PolicyTemplateType.POLICY_TEMPLATE_E getPolicyTemplate(int typeNum) {
        for (PolicyTemplateType.POLICY_TEMPLATE_E template : PolicyTemplateType.POLICY_TEMPLATE_E.values()) {
            if (template.getValue() != typeNum) continue;
            return template;
        }
        return null;
    }

    public Set<Integer> getRealTimeReplicaPolicyType() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (PolicyTemplateType.POLICY_TEMPLATE_E policy : realTimeContainer.keySet()) {
            result.add(policy.getValue());
        }
        return result;
    }

    public IRealTimeReplicaBuilder getRealTimeReplicaBuilder(ProtectGroup protectGroup) {
        PolicyTemplateType.POLICY_TEMPLATE_E type = this.getPolicyTemplate(protectGroup.getTemplate().getType());
        return realTimeContainer.get(type);
    }
}

