/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.retention.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class ReplicaRetentionJob
implements StatefulJob {
    private static Log logger = LogFactory.getInstance(ReplicaRetentionJob.class);
    private static final Long WAITTIME = 0x6DDD00L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        String pgId = this.getPgId(context);
        if (!this.lockPg(pgId)) {
            logger.error((Object)"Skip this replica retention job because lock acquisition failed, pg id: %s", new Object[]{pgId});
            return;
        }
        try {
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pgId);
            if (!this.isStatusAvailable(pg)) {
                logger.error((Object)"Skip this replica retention job because unavailable status, pg name: %s", new Object[]{pg.getName()});
                return;
            }
            logger.info((Object)"Start to execute periodic replica retention task, pg name: %s.", new Object[]{pg.getName()});
            ((IReplicaRetentionStrategyManager)ServiceLocator.getInstance().getService(IReplicaRetentionStrategyManager.class)).executeStrategy(pg);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(pgId);
        }
    }

    private String getPgId(JobExecutionContext jobexecutioncontext) {
        String id = jobexecutioncontext.getMergedJobDataMap().getString("pg_id_key");
        if (VerifyUtil.isEmpty((String)id)) {
            logger.error((Object)"pg id isEmpty");
            throw new LegoCheckedException(2117645L);
        }
        return id;
    }

    private boolean lockPg(String pgId) {
        return ProtectionJobUtil.getInstance().getLockPg(pgId, WAITTIME, "ReplicaRetentionJob");
    }

    private boolean isStatusAvailable(ProtectGroup pg) {
        return pg.getStatus() == DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL.getStatus();
    }
}

