/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.retention.util;

import com.huawei.ism.array.sdk.model.HyperVaultCopy;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.framework.service.replica.factory.ReplicaFactoryManager;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaInfoBean;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperVaultReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPGroupManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotGroupManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.HyperCDPConsistencyGroup;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.storage.sdk.model.SnapshotConsistentGroup;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CheckReplicaTools {
    private static final Log logger = LogFactory.getInstance(CheckReplicaTools.class);
    private static final List<Long> SNAPSHOT_ERR_CODES = Arrays.asList(1077937880L, 50337543L, 1077948996L);
    private static final List<Integer> SUPPORT_TEMPLATE_TYPE = Arrays.asList(2, 19, 14, 17, 28, 30, 31, 32);

    public static void disableProtectGroupReplicas(String protectGroupId) {
        logger.debug((Object)("begin to disableProtectGroupReplicas:" + protectGroupId));
        if (null == protectGroupId || protectGroupId.isEmpty()) {
            throw new LegoCheckedException(1073947393L, "protectGroupId is empty.");
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        List replicas = replicaService.queryProtectGroupReplicaByGroup(protectGroupId, null, true, null);
        if (VerifyUtil.isEmpty((Collection)replicas)) {
            return;
        }
        for (ProtectGroupReplica replica : replicas) {
            if (DrmEnumDefine.REPLICA_STATUS.ERROR_STATUS.getValue() == replica.getStatus()) {
                logger.debug((Object)("replica(" + replica.getId() + ")'s status is" + replica.getStatus() + ", and not need check."));
                continue;
            }
            try {
                IReplicaFactory factory;
                if (replica.isStorageReplicationReplica() || (factory = ReplicaFactoryManager.getInstance().getReplicaFactory(replica.getType())).validReplica(replica, true)) continue;
                logger.info((Object)("replica(" + replica.getId() + ") is not correct."));
                boolean status = CheckReplicaTools.disableProtectGroupReplica(replica.getId());
                logger.debug((Object)("disable incorrect local replica. success: " + status));
            }
            catch (Exception e) {
                logger.error((Object)("process protect group replica failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }

    private static boolean disableProtectGroupReplica(String replicaId) {
        logger.debug((Object)("begin to disableProtectGroupReplica:" + replicaId));
        String sql = "update ti_protectgroupreplica set replicastatus = ? where id = ?";
        try {
            int records = CommonDAOLocator.getBaseDao().update(sql, new Object[]{DrmEnumDefine.REPLICA_STATUS.ERROR_STATUS.getValue(), replicaId});
            if (records == 0) {
                logger.warn((Object)("no protect group replica to disable. replica id: " + replicaId));
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("disable protect group replica failed. replica id: " + replicaId + ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
    }

    public static boolean updateProtectGroupReplicaStatus(String replicaId, int status) {
        logger.debug((Object)("begin to updateProtectGroupReplicaStatus:" + replicaId + " status:" + status));
        String sql = "update ti_protectgroupreplica set replicastatus = ? where id = ?";
        try {
            int records = CommonDAOLocator.getBaseDao().update(sql, new Object[]{status, replicaId});
            if (records == 0) {
                logger.warn((Object)("no protect group replica to update. replica id: " + replicaId));
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("update protect group replica failed. replica id: " + replicaId + " status:" + status + ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
    }

    public static boolean checkSnapshotCorrect(String replicaId) {
        if (replicaId == null || replicaId.isEmpty()) {
            throw new LegoCheckedException(1073947393L, "replicaId is empty.");
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        if (replica == null) {
            logger.error((Object)"replica is not found: %s", new Object[]{replicaId});
            throw new LegoCheckedException(201L);
        }
        IReplicaFactory factory = ReplicaFactoryManager.getInstance().getReplicaFactory(replica.getType());
        return factory.validReplica(replica, false);
    }

    public static boolean checkSnapshotCorrect(ProtectGroupReplica replica, boolean isDisableSnap) {
        int ptType = replica.getPg().getTemplate().getType();
        logger.debug((Object)"begin check replica(%s), and Template is %s ", new Object[]{replica.getId(), ptType});
        if (!SUPPORT_TEMPLATE_TYPE.contains(ptType)) {
            return true;
        }
        Map<String, CheckReplicaInfoBean> checkedDev = CheckReplicaTools.generateCheckInfoMap(replica);
        for (Map.Entry<String, CheckReplicaInfoBean> entry : checkedDev.entrySet()) {
            CheckReplicaInfoBean checkInfo = entry.getValue();
            String logParam = entry.getKey() + "#" + checkInfo.getSnapId();
            try {
                if (!VerifyUtil.isEmpty((String)checkInfo.getConsistentGroupId())) {
                    return CheckReplicaTools.checkConsistentGroup(checkInfo);
                }
                if (CheckReplicaTools.checkSnapshotCorrect(checkInfo, ptType)) continue;
                return false;
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"check Snapshot error: %s", (Throwable)e, new Object[]{logParam});
                if (!isDisableSnap) {
                    return false;
                }
                if (!SNAPSHOT_ERR_CODES.contains(e.getErrorCode())) continue;
                return false;
            }
            catch (Exception e) {
                logger.error((Object)"check Snapshot error: %s", (Throwable)e, new Object[]{logParam});
                if (isDisableSnap) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkSnapshotCorrect(CheckReplicaInfoBean checkInfo, int templateType) {
        String sn = checkInfo.getProviderSn();
        String id = checkInfo.getSnapId();
        String srcId = checkInfo.getDevId();
        int type = checkInfo.getType();
        if (CheckReplicaTools.isEmptySnapshotId(id)) {
            logger.warn((Object)("array snapshot id is null or empty. id: " + sn + "#" + srcId));
            return false;
        }
        List<Snapshot> items = null;
        List<Lun> luns = null;
        if (CheckReplicaTools.isSanSnapshotReplica(templateType)) {
            logger.debug((Object)("snapshot is a array snapshot: " + sn + "#" + id));
            if (9 == type && !VerifyUtil.isEmpty(luns = CheckReplicaTools.getCloneVolume(sn, id))) {
                return true;
            }
            items = CheckReplicaTools.getSanSnapshot(sn, id);
        } else if (templateType == 14) {
            logger.debug((Object)("snapshot is a nas snapshot: " + sn + "#" + id));
            items = CheckReplicaTools.getNasSnapshot(sn, srcId, id);
        } else {
            if (templateType == 17 || templateType == 28) {
                logger.debug((Object)("snapshot is a hypervault: " + sn + "#" + id));
                return CheckReplicaTools.checkHyperVaultSnapshot(checkInfo);
            }
            logger.debug((Object)("snapshot is not need to check: " + sn + "#" + id));
            return true;
        }
        if (VerifyUtil.isEmpty(items)) {
            logger.warn((Object)("snapshot is already not exists. sn: " + sn + ", snapshot id: " + id));
            return false;
        }
        if (!checkInfo.getSnapName().contains(items.get(0).getName())) {
            logger.warn((Object)("snapshot name was bean changed. sn: " + sn + ", snapshot id: " + id + ", saved name: " + checkInfo.getSnapName() + ", query name: " + items.get(0).getName()));
            return false;
        }
        return true;
    }

    private static Map<String, CheckReplicaInfoBean> generateCheckInfoMap(ProtectGroupReplica replica) {
        HashMap<String, CheckReplicaInfoBean> checkedDev = new HashMap<String, CheckReplicaInfoBean>();
        for (ProtectObjectReplica por : replica.getReplicas()) {
            for (RelicaStorageInfo rsi : por.getStorageInfos()) {
                if (!(rsi instanceof LocalStorageReplica)) {
                    logger.debug((Object)"%s is not local storage replica", new Object[]{rsi.getId()});
                    continue;
                }
                LocalStorageReplica lsr = (LocalStorageReplica)LocalStorageReplica.class.cast(rsi);
                String devStr = VerifyUtil.isEmpty((String)lsr.getConsistentGroupId()) ? lsr.getSrcStorageProviderSN() + "#" + lsr.getSrcStorageId() : lsr.getStorageProviderSN() + "#" + lsr.getConsistentGroupId();
                if (checkedDev.containsKey(devStr)) {
                    ((CheckReplicaInfoBean)checkedDev.get(devStr)).getSnapName().add(lsr.getSnapshotName());
                    continue;
                }
                CheckReplicaInfoBean checkInfo = new CheckReplicaInfoBean();
                checkInfo.setProviderSn(lsr.getStorageProviderSN());
                checkInfo.setDevId(lsr.getSrcStorageId());
                checkInfo.setSnapId(lsr.getStorageId());
                checkInfo.getSnapName().add(lsr.getSnapshotName());
                checkInfo.setType(replica.getType());
                if (lsr instanceof HyperVaultReplica) {
                    checkInfo.setPairId(((HyperVaultReplica)HyperVaultReplica.class.cast(lsr)).getPairId());
                }
                checkInfo.setConsistentGroupId(lsr.getConsistentGroupId());
                checkedDev.put(devStr, checkInfo);
            }
        }
        return checkedDev;
    }

    private static List<Snapshot> getSanSnapshot(String sn, String id) {
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevId(sn);
        if (null == proxy) {
            logger.warn((Object)("not found snapshot manager proxy. sn: " + sn + ", id: " + id));
            throw new LegoCheckedException(1073947395L);
        }
        Snapshot snapshot = new Snapshot();
        snapshot.setSnapshotId(id);
        return proxy.getSnapshot(sn, snapshot);
    }

    private static List<Lun> getCloneVolume(String sn, String volumeName) {
        StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
        IStorageLunManager manager = proxy.getStorageLunMgrByDevId(sn);
        if (null == manager) {
            logger.warn((Object)("not found snapshot manager proxy. sn: " + sn + ", id: " + volumeName));
            throw new LegoCheckedException(1073947395L);
        }
        ArrayList<String> volumeNames = new ArrayList<String>();
        volumeNames.add(volumeName);
        return manager.queryLunsByNames(sn, volumeNames);
    }

    private static List<Snapshot> getNasSnapshot(String sn, String srcFsId, String id) {
        ArrayList<Snapshot> result = new ArrayList<Snapshot>();
        StorageFileSystemSnapshotManagerProxy storageManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance();
        IStorageFileSystemSnapshotManager proxy = storageManagerProxy.getStorageFileSystemSnapshotManager(sn);
        if (null == proxy) {
            logger.warn((Object)("not found snapshot manager proxy. sn: " + sn + ", id: " + id));
            throw new LegoCheckedException(1073947395L);
        }
        List temp = proxy.querySnapshot(sn, srcFsId);
        logger.debug((Object)("there are " + temp.size() + " snaps under " + sn + "#" + srcFsId));
        for (Snapshot snap : temp) {
            if (!id.equals(snap.getId())) continue;
            result.add(snap);
            break;
        }
        return result;
    }

    private static boolean checkHyperVaultSnapshot(CheckReplicaInfoBean checkInfo) {
        String vaultId = checkInfo.getPairId();
        String deviceSn = checkInfo.getProviderSn();
        String copyId = checkInfo.getSnapId();
        IStorageHyperVaultManager mgr = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(deviceSn);
        if (mgr == null) {
            logger.error((Object)("IStorageHyperVaultManager is null.deviceSn:" + deviceSn));
            throw new LegoCheckedException(1073947395L);
        }
        List copies = mgr.queryCopysByHyperVault(deviceSn, vaultId);
        for (HyperVaultCopy copy : copies) {
            if (!copyId.equals(copy.getId())) continue;
            for (String rdSnapName : checkInfo.getSnapName()) {
                if (!rdSnapName.startsWith("RD") && !rdSnapName.equals(copy.getName())) continue;
                return true;
            }
        }
        logger.warn((Object)("not match HyperVaultCopy:" + copyId + "##" + checkInfo.getSnapName()));
        return false;
    }

    private static boolean checkConsistentGroup(CheckReplicaInfoBean checkInfo) {
        String deviceSn = checkInfo.getProviderSn();
        String consistentGroupId = checkInfo.getConsistentGroupId();
        if (VerifyUtil.isEmpty((String)deviceSn) || VerifyUtil.isEmpty((String)consistentGroupId)) {
            logger.warn((Object)"deviceSn or consistentGroupId is null.");
            return false;
        }
        HyperCDPConsistencyGroup consistentGroup = null;
        if (checkInfo.getType() == 4 || checkInfo.getType() == 102) {
            consistentGroup = CheckReplicaTools.getHyperCDPConsistentGroup(deviceSn, consistentGroupId);
        } else if (3 == checkInfo.getType()) {
            consistentGroup = CheckReplicaTools.getSnapshotConsistentGroup(deviceSn, consistentGroupId);
        }
        if (null == consistentGroup) {
            logger.error((Object)("SnapshotConsistentGroup not exists." + checkInfo.getConsistentGroupId()));
            return false;
        }
        return true;
    }

    private static SnapshotConsistentGroup getSnapshotConsistentGroup(String sn, String id) {
        StorageSnapshotGroupManagerProxy proxy = StorageSnapshotGroupManagerProxy.getInstance();
        IStorageSnapshotGroupManager mgr = proxy.getStorageSnapshotGroupMgrByDevId(sn);
        if (null == mgr) {
            logger.warn((Object)("not found snapshot manager proxy. sn: " + sn + ", id: " + id));
            throw new LegoCheckedException(1073947395L);
        }
        return mgr.query(sn, id);
    }

    private static HyperCDPConsistencyGroup getHyperCDPConsistentGroup(String sn, String id) {
        StorageHyperCDPGroupManagerProxy proxy = StorageHyperCDPGroupManagerProxy.getInstance();
        IStorageHyperCDPGroupManager mgr = proxy.getStorageHyperCDPGroupMgrByDevId(sn);
        if (null == mgr) {
            logger.warn((Object)("not found snapshot manager proxy. sn: " + sn + ", id: " + id));
            throw new LegoCheckedException(1073947395L);
        }
        return mgr.query(sn, id);
    }

    private static boolean isSanSnapshotReplica(int templateType) {
        return templateType == 2 || templateType == 19 || PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(templateType);
    }

    private static boolean isEmptySnapshotId(String snapshotId) {
        return null == snapshotId || snapshotId.isEmpty() || snapshotId.equals("NONE");
    }

    public static boolean checkSnapshotMapped(ProtectGroupReplica replica) {
        VerifyUtil.checkObject((Object)replica.getPg());
        VerifyUtil.checkObject((Object)replica.getPg().getTemplate());
        int type = replica.getPg().getTemplate().getType();
        if (replica.isHyperCDPReplica() || !CheckReplicaTools.isSanSnapshotReplica(type)) {
            return false;
        }
        Map<String, CheckReplicaInfoBean> checkReplicaInfoBeanMap = CheckReplicaTools.generateCheckInfoMap(replica);
        for (Map.Entry<String, CheckReplicaInfoBean> checkInfoEntry : checkReplicaInfoBeanMap.entrySet()) {
            String devSn = checkInfoEntry.getValue().getProviderSn();
            String snapshotId = checkInfoEntry.getValue().getSnapId();
            List<Snapshot> sanSnapshot = CheckReplicaTools.getSanSnapshot(devSn, snapshotId);
            for (Snapshot snapshot : sanSnapshot) {
                if (!snapshot.getIsMapped().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }
}

