/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.template.util;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class ProtectionRelationJsonConverter {
    private static final Log logger = LogFactory.getInstance(ProtectionRelationJsonConverter.class);
    private static final String SEPARATOR = ":";

    public static String toJsonStr(ProtectionRelation protectionRelation, boolean saveToDB) {
        return ProtectionRelationJsonConverter.getJsonObjectFromRelations(protectionRelation, saveToDB).toString();
    }

    public static String toJsonStr(List<ProtectionRelation> relationList, boolean saveToDB) {
        if (CollectionUtils.isEmpty(relationList)) {
            logger.error((Object)"relationList is null!", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectionRelation protectionRelation = ProtectionRelationJsonConverter.compressProtectionRelationList(relationList);
        return ProtectionRelationJsonConverter.getJsonObjectFromRelations(protectionRelation, saveToDB).toString();
    }

    private static ProtectionRelation compressProtectionRelationList(List<ProtectionRelation> relationList) {
        StringBuilder resourceSb = new StringBuilder();
        StringBuilder targetResourceSb = new StringBuilder();
        StringBuilder vaultIdSb = new StringBuilder();
        for (ProtectionRelation protectionRelation : relationList) {
            resourceSb.append(protectionRelation.getSrcResourceId()).append(SEPARATOR);
            targetResourceSb.append(((ProtectionRelation)CommonUtil.getFirstElement((Collection)protectionRelation.getTargetResources())).getSrcResourceId()).append(SEPARATOR);
            vaultIdSb.append(protectionRelation.getPairId()).append(SEPARATOR);
        }
        ProtectionRelation protectionRelation = ProtectionRelationJsonConverter.copyProtectionRelation((ProtectionRelation)CommonUtil.getFirstElement(relationList), null, null);
        ArrayList<ProtectionRelation> target = new ArrayList<ProtectionRelation>();
        target.add(ProtectionRelationJsonConverter.copyProtectionRelation((ProtectionRelation)CommonUtil.getFirstElement((Collection)((ProtectionRelation)CommonUtil.getFirstElement(relationList)).getTargetResources()), null, null));
        protectionRelation.setTargetResources(target);
        protectionRelation.setSrcResourceId(resourceSb.substring(0, resourceSb.length() - 1));
        ((ProtectionRelation)CommonUtil.getFirstElement((Collection)protectionRelation.getTargetResources())).setSrcResourceId(targetResourceSb.substring(0, targetResourceSb.length() - 1));
        protectionRelation.setPairId(vaultIdSb.substring(0, vaultIdSb.length() - 1));
        return protectionRelation;
    }

    private static List<ProtectionRelation> deCompressProtectionRelationList(ProtectionRelation protectionRelation) {
        String[] resourceIds = protectionRelation.getSrcResourceId().split(SEPARATOR);
        String[] targetResourceIds = ((ProtectionRelation)CommonUtil.getFirstElement((Collection)protectionRelation.getTargetResources())).getSrcResourceId().split(SEPARATOR);
        String[] vaultIds = protectionRelation.getPairId().split(SEPARATOR);
        ArrayList<ProtectionRelation> relationList = new ArrayList<ProtectionRelation>();
        for (int index = 0; index < resourceIds.length; ++index) {
            relationList.add(ProtectionRelationJsonConverter.copyAllProtectionRelation(protectionRelation, resourceIds[index], targetResourceIds[index], vaultIds[index]));
        }
        return relationList;
    }

    private static ProtectionRelation copyAllProtectionRelation(ProtectionRelation protectionRelation, String resourceId, String targetResourceId, String vaultId) {
        ProtectionRelation newProtectionRelation = ProtectionRelationJsonConverter.copyProtectionRelation(protectionRelation, resourceId, vaultId);
        ArrayList<ProtectionRelation> target = new ArrayList<ProtectionRelation>();
        target.add(ProtectionRelationJsonConverter.copyProtectionRelation((ProtectionRelation)CommonUtil.getFirstElement((Collection)protectionRelation.getTargetResources()), targetResourceId, vaultId));
        newProtectionRelation.setTargetResources(target);
        return newProtectionRelation;
    }

    private static ProtectionRelation copyProtectionRelation(ProtectionRelation protectionRelation, String resourceId, String vaultId) {
        ProtectionRelation newProtectionRelation = new ProtectionRelation();
        newProtectionRelation.setSrcResourceId(resourceId);
        newProtectionRelation.setSrcResourceProviderSn(protectionRelation.getSrcResourceProviderSn());
        newProtectionRelation.setSrcResourceProviderName(protectionRelation.getSrcResourceProviderName());
        newProtectionRelation.setPairId(protectionRelation.getPairId());
        newProtectionRelation.setSrcResourceName(protectionRelation.getSrcResourceName());
        newProtectionRelation.setSrcResourceType(protectionRelation.getSrcResourceType());
        newProtectionRelation.setSrcSiteId(protectionRelation.getSrcSiteId());
        newProtectionRelation.setSrcSiteName(protectionRelation.getSrcSiteName());
        newProtectionRelation.setPairId(vaultId);
        return newProtectionRelation;
    }

    public static ProtectionRelation toProtectionRelation(String jsonStr) {
        if (VerifyUtil.isEmpty((String)jsonStr)) {
            return null;
        }
        JSONObject protectionRelationObj = JSONObject.fromObject((Object)jsonStr);
        return ProtectionRelationJsonConverter.getProtectionRelationFromJsonObject(protectionRelationObj);
    }

    public static List<ProtectionRelation> toProtectionRelationList(String jsonStr) {
        if (VerifyUtil.isEmpty((String)jsonStr)) {
            return null;
        }
        JSONObject protectionRelationObj = JSONObject.fromObject((Object)jsonStr);
        return ProtectionRelationJsonConverter.deCompressProtectionRelationList(ProtectionRelationJsonConverter.getProtectionRelationFromJsonObject(protectionRelationObj));
    }

    public static String getSiteName(String siteId) {
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site srcSite = siteService.getSiteById(siteId);
        return srcSite != null ? srcSite.getName() : "";
    }

    public static String getResourceProviderName(String providerSn) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(providerSn);
        return drResource != null ? drResource.getName() : "";
    }

    public static String getResourceName(String providerSn, String resourceId, Integer resourceType) {
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        if (resourceType.intValue() == DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()) {
            StorageResource storageResource = storageResourceService.getStorageResource(providerSn, resourceId, NasFileSystem.class);
            return storageResource != null ? storageResource.getName() : "";
        }
        StorageResource storageResource = storageResourceService.getStorageResource(providerSn, resourceId, Lun.class);
        return storageResource != null ? storageResource.getName() : "";
    }

    private static String getValue(JSONObject jsonObj, String fieldName) {
        return jsonObj.get(fieldName) != null ? jsonObj.getString(fieldName) : "";
    }

    private static ProtectionRelation getProtectionRelationFromJsonObject(JSONObject protectionRelationObj) {
        ProtectionRelation protectionRelation = new ProtectionRelation();
        protectionRelation.setPairId(ProtectionRelationJsonConverter.getValue(protectionRelationObj, "pairId"));
        String srcResourceId = ProtectionRelationJsonConverter.getValue(protectionRelationObj, "srcResourceId");
        protectionRelation.setSrcResourceId(srcResourceId);
        String srcProviderSn = ProtectionRelationJsonConverter.getValue(protectionRelationObj, "srcResourceProviderSn");
        String srcResourceType = ProtectionRelationJsonConverter.getValue(protectionRelationObj, "srcResourceType");
        Integer resourceType = DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue();
        if (!VerifyUtil.isEmpty((String)srcResourceType)) {
            resourceType = Integer.valueOf(srcResourceType);
        }
        protectionRelation.setSrcResourceName(ProtectionRelationJsonConverter.getResourceName(srcProviderSn, srcResourceId, resourceType));
        protectionRelation.setSrcResourceProviderSn(srcProviderSn);
        protectionRelation.setSrcResourceProviderName(ProtectionRelationJsonConverter.getResourceProviderName(srcProviderSn));
        protectionRelation.setSrcResourceType(ProtectionRelationJsonConverter.getValue(protectionRelationObj, "srcResourceType"));
        String srcSiteId = ProtectionRelationJsonConverter.getValue(protectionRelationObj, "srcSiteId");
        protectionRelation.setSrcSiteId(srcSiteId);
        protectionRelation.setSrcSiteName(ProtectionRelationJsonConverter.getSiteName(srcSiteId));
        JSONArray jsonArray = protectionRelationObj.getJSONArray("targetResources");
        ArrayList<ProtectionRelation> targetResources = new ArrayList<ProtectionRelation>();
        if (jsonArray != null && jsonArray.size() != 0) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JSONObject prJsonObj = JSONObject.fromObject(iterator.next());
                ProtectionRelation subPr = new ProtectionRelation();
                subPr.setPairId(ProtectionRelationJsonConverter.getValue(prJsonObj, "pairId"));
                String targetResourceId = ProtectionRelationJsonConverter.getValue(prJsonObj, "srcResourceId");
                subPr.setSrcResourceId(targetResourceId);
                String targetProviderSn = ProtectionRelationJsonConverter.getValue(prJsonObj, "srcResourceProviderSn");
                String targetResourceType = ProtectionRelationJsonConverter.getValue(prJsonObj, "srcResourceType");
                resourceType = DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue();
                if (!VerifyUtil.isEmpty((String)targetResourceType)) {
                    resourceType = Integer.valueOf(targetResourceType);
                }
                subPr.setSrcResourceName(ProtectionRelationJsonConverter.getResourceName(targetProviderSn, targetResourceId, resourceType));
                subPr.setSrcResourceProviderName(ProtectionRelationJsonConverter.getResourceProviderName(targetProviderSn));
                subPr.setSrcResourceProviderSn(targetProviderSn);
                subPr.setSrcResourceType(ProtectionRelationJsonConverter.getValue(prJsonObj, "srcResourceType"));
                String targetSiteId = ProtectionRelationJsonConverter.getValue(prJsonObj, "srcSiteId");
                subPr.setSrcSiteId(targetSiteId);
                subPr.setSrcSiteName(ProtectionRelationJsonConverter.getSiteName(targetSiteId));
                targetResources.add(subPr);
            }
        }
        protectionRelation.setTargetResources(targetResources);
        return protectionRelation;
    }

    private static JSONObject getJsonObjectFromRelations(ProtectionRelation protectionRelation, boolean saveToDB) {
        if (protectionRelation == null) {
            logger.error((Object)"protectionRelation is null!", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        String srcSiteId = protectionRelation.getSrcSiteId();
        String srcSiteName = protectionRelation.getSrcSiteName();
        String srcResourceType = protectionRelation.getSrcResourceType();
        String srcResourceProviderSn = protectionRelation.getSrcResourceProviderSn();
        String srcResourceProviderName = protectionRelation.getSrcResourceProviderName();
        String srcResourceId = protectionRelation.getSrcResourceId();
        String srcResourceName = protectionRelation.getSrcResourceName();
        String pairId = protectionRelation.getPairId();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"srcSiteId", (Object)srcSiteId);
        jsonObject.put((Object)"srcResourceType", (Object)srcResourceType);
        jsonObject.put((Object)"srcResourceId", (Object)srcResourceId);
        jsonObject.put((Object)"srcResourceProviderSn", (Object)srcResourceProviderSn);
        jsonObject.put((Object)"pairId", (Object)pairId);
        if (!saveToDB) {
            jsonObject.put((Object)"srcSiteName", (Object)srcSiteName);
            jsonObject.put((Object)"srcResourceProviderName", (Object)srcResourceProviderName);
            jsonObject.put((Object)"srcResourceName", (Object)srcResourceName);
        }
        JSONArray jsonArray = new JSONArray();
        List targetResources = protectionRelation.getTargetResources();
        if (VerifyUtil.isEmpty((Collection)targetResources)) {
            jsonObject.put((Object)"targetResources", (Object)jsonArray);
            return jsonObject;
        }
        for (ProtectionRelation targetProtectionRelation : targetResources) {
            JSONObject subObj = new JSONObject();
            subObj.put((Object)"srcSiteId", (Object)targetProtectionRelation.getSrcSiteId());
            subObj.put((Object)"srcResourceType", (Object)targetProtectionRelation.getSrcResourceType());
            subObj.put((Object)"srcResourceId", (Object)targetProtectionRelation.getSrcResourceId());
            subObj.put((Object)"srcResourceProviderSn", (Object)targetProtectionRelation.getSrcResourceProviderSn());
            subObj.put((Object)"pairId", (Object)targetProtectionRelation.getPairId());
            if (!saveToDB) {
                subObj.put((Object)"srcSiteName", (Object)targetProtectionRelation.getSrcSiteName());
                subObj.put((Object)"srcResourceProviderName", (Object)targetProtectionRelation.getSrcResourceProviderName());
                subObj.put((Object)"srcResourceName", (Object)targetProtectionRelation.getSrcResourceName());
            }
            jsonArray.add((Object)subObj);
        }
        jsonObject.put((Object)"targetResources", (Object)jsonArray);
        return jsonObject;
    }
}

