/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.checker;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotScheduleManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PolicyTemplateProcessChecker
implements IRecoveryProcessChecker {
    private static Log logger = LogFactory.getInstance(PolicyTemplateProcessChecker.class);
    private static final List<Integer> AVAILABLE_EXECUTE_TYPE = new ArrayList<Integer>();

    public void check(RecoveryProcessorContext context, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        if (null == context || null == procType) {
            logger.error((Object)"Invalid parameters.");
            return;
        }
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.debug((Object)"Invalid parameters.");
            return;
        }
        Set protectGroups = recoveryPlan.getProtectGroups();
        for (ProtectGroup pg : protectGroups) {
            PolicyTemplate pt = pg.getTemplate();
            if (!AVAILABLE_EXECUTE_TYPE.contains(procType.getValue())) continue;
            ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();
            IReplicaBuilder builder = factory.getTemplateByType(pg.getTemplate().getType());
            Map devSns = builder.getProtectedDeviceSn(pg);
            for (Schedule schedule : pt.getSchedules()) {
                if (!SnapshotScheduleUtil.isExistsSecondSchedule(schedule)) continue;
                String devSn = (String)devSns.get(schedule.getProtectLocation());
                String snapshotScheduleId = SnapshotScheduleUtil.getScheduleIdFromProtectGroup(pg, devSn);
                if (null == snapshotScheduleId || null == devSn) {
                    logger.info((Object)"snapshotScheduleId or devSn is null.");
                    continue;
                }
                IStorageSnapshotScheduleManager scheduleManager = StorageSnapshotScheduleManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn, schedule.getProtectedType());
                try {
                    SnapshotScheduleUtil.disableSchedule(pg, scheduleManager, devSn, snapshotScheduleId, schedule);
                    pg.getProps().remove("PROP_KEY_SNAPSHOT_SCHEDULE");
                    ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(pg.getUuid(), pg.getProps());
                }
                catch (LegoCheckedException le) {
                    logger.error((Object)"cannot disable snapshot schedule");
                }
            }
        }
    }

    public String getName() {
        return this.getClass().getName();
    }

    static {
        AVAILABLE_EXECUTE_TYPE.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue());
        AVAILABLE_EXECUTE_TYPE.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue());
        AVAILABLE_EXECUTE_TYPE.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue());
    }
}

