/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.IReplicationRecoveryTaskConstructor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class BeginRecoveryProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 7165749943640064871L;
    private static Log logger = LogFactory.getInstance(BeginRecoveryProcessor.class);

    public BeginRecoveryProcessor() {
        this.setProcName(this.getName());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        Site remoteSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(RecoveryServiceUtil.getProductSiteId(recoveryPlan));
        context.setAttribute("productionSite", (Object)remoteSite);
        IRecoveryProcessHandler recoveryProcHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        Collection recoveryTasks = recoveryProcHandler.getRecoveryTasks(recoveryPlan);
        if (VerifyUtil.isEmpty((Collection)recoveryTasks) && !this.validateIsArrayHypermetro(recoveryPlan)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        if (!this.validateIsArrayHypermetro(recoveryPlan)) {
            IReplicationRecoveryTaskConstructor constructor = (IReplicationRecoveryTaskConstructor)recoveryProcHandler;
            constructor.checkRecoveryTasks(recoveryTasks, recoveryPlan, this);
            Collection<RecoveryTask> filterTasks = this.filterTasks(recoveryPlan, recoveryTasks);
            context.setAttribute("recoveryTasks", filterTasks);
            RecoveryProcessUtil.presetCheck(context, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType()));
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    @Override
    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateProcessName() {
        this.setProcName(this.calcProcessName());
    }

    private Collection<RecoveryTask> filterTasks(RecoveryPlan recoveryPlan, Collection<RecoveryTask> recoveryTasks) {
        ArrayList<Integer> executeTypes = new ArrayList<Integer>();
        executeTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue());
        executeTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue());
        ArrayList<RecoveryTask> filterTasks = new ArrayList();
        if (executeTypes.contains(this.getProcType())) {
            Iterator iterator = recoveryPlan.getProtectGroups().iterator();
            if (!iterator.hasNext()) {
                logger.error((Object)"protectGroups is empty!");
                return filterTasks;
            }
            int poType = ((ProtectGroup)iterator.next()).getPoType();
            for (RecoveryTask task : recoveryTasks) {
                if (14 != poType && task.getResourceAndTypeMap().values().contains(DrmEnumDefine.APP_TYPE.NAS_FILESYSTEM.getValue())) continue;
                filterTasks.add(task);
            }
        } else {
            filterTasks = recoveryTasks;
        }
        return filterTasks;
    }

    private boolean validateIsArrayHypermetro(RecoveryPlan recoveryPlan) {
        Set protectGroups = recoveryPlan.getProtectGroups();
        ProtectGroup pg = (ProtectGroup)protectGroups.iterator().next();
        return 15 == pg.getTemplate().getType();
    }

    private String calcProcessName() {
        String processName = null;
        processName = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() == this.getProcType() ? "ism.drm.clean.prepare.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() == this.getProcType() ? "ism.drm.testing.prepare.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION.getValue() == this.getProcType() ? "ism.drm.planedmotion.prepare.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() ? "ism.drm.reprotect.prepare.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SWAP.getValue() == this.getProcType() ? "ism.drm.swap.prepare.process.name" : "ism.drm.recovery.prepare.process.name"))));
        return processName;
    }

    public void updateDescription() {
        this.setDescription("ism.drm.recovery.prepare.process.des");
    }
}

