/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import java.util.Optional;

public class CheckResourceMappingProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -2134971771618743859L;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            return false;
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            boolean isStopped;
            try {
                isStopped = provider.checkProductionBusinessStopped(context);
            }
            catch (LegoCheckedException e) {
                this.consumeFailed(context);
                throw e;
            }
            if (!isStopped) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("ism.drm.product.lun.hasmapping", null);
                this.consumeFailed(context);
                return false;
            }
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    private void consumeFailed(RecoveryProcessorContext context) {
        Optional opt = context.getProtectPortTask();
        AirGapLinkPortUtil portUtil = AirGapLinkPortUtil.getInstance();
        opt.ifPresent(task -> portUtil.consumeFailedAirGapTask((EnablePortTask)task, DrmEnumDefine.ExecTypeEnum.MANUAL.getType()));
    }

    @Override
    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.recovery.framework.process.CheckResourceMappingProcessor.des");
    }

    public String getStepPosition() {
        return "CheckMapping";
    }
}

