/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.SyncLockManager;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

public class EndRecoveryProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1410992583871817347L;
    private static Log logger = LogFactory.getInstance(EndRecoveryProcessor.class);

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public boolean execute(RecoveryProcessorContext context) {
        int procResult = this.getPreviousProcessorStatus();
        this.setProcStatus(procResult);
        this.clearInvalidProps(context);
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == procResult;
    }

    private void clearInvalidProps(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (recoveryPlan == null) {
            logger.error((Object)"Can't get RecoveryPlan from context.");
            return;
        }
        if (this.getProcType() == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue()) {
            String recoveryPlanId = context.getRecoveryPlan().getPlanId();
            IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
            HashMap newGlobalSettings = new HashMap();
            planService.saveOrUpdateGlobalSettings(recoveryPlanId, newGlobalSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateRecoveryPlanProgress(String recoveryPlanId, int progressRatio) {
        ReentrantLock lock = SyncLockManager.getSyncLock(recoveryPlanId);
        if (null == lock) {
            logger.error((Object)("try to lock failed planid: " + recoveryPlanId));
            return;
        }
        lock.lock();
        try {
            if (0 < progressRatio && 100 >= progressRatio && (null == this.getChildProc() || this.getChildProc().isEmpty()) && !this.getHasChildProc().booleanValue()) {
                IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
                recoveryProcessService.updateRecoveryPlanProgress(recoveryPlanId, 100);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateProcessName() {
        this.setProcName(this.calcProcessName());
    }

    public int getPreviousProcessorStatus() {
        RecoveryProcessor preProcessor = this.getPreviousProcessor();
        if (Boolean.parseBoolean((String)preProcessor.getProps().get("EXECUTE_POLICY"))) {
            preProcessor = preProcessor.getPreviousProcessor();
        }
        while (!(null == preProcessor || preProcessor.getIsEnabled().booleanValue() && preProcessor.getIsResultProcessor().booleanValue())) {
            preProcessor = preProcessor.getPreviousProcessor();
        }
        int procResult = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue();
        if (null != preProcessor) {
            procResult = preProcessor.getProcStatus();
        }
        return procResult;
    }

    private String calcProcessName() {
        String processName = null;
        processName = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() == this.getProcType() ? "ism.drm.clean.end.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() == this.getProcType() ? "ism.drm.testing.end.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION.getValue() == this.getProcType() ? "ism.drm.planedmotion.end.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() ? "ism.drm.reprotect.end.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SWAP.getValue() == this.getProcType() ? "ism.drm.swap.end.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.UMOUNT_REPLICA.getValue() == this.getProcType() ? "ism.drm.umountReplica.end.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.MOUNT_REPLICA.getValue() == this.getProcType() ? "ism.drm.mountReplica.end.process.name" : "ism.drm.recovery.end.process.name"))))));
        return processName;
    }

    public void updateDescription() {
        this.setDescription("ism.drm.recovery.end.process.des");
    }

    public String getStepPosition() {
        return "End";
    }
}

