/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.UmountPreviousReplicaSubProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class UmountPreviousReplicaProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1475969986053666242L;
    private static final Log LOGGER = LogFactory.getInstance(UmountPreviousReplicaProcessor.class);

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (null == replica) {
            LOGGER.error((Object)"Replica is null!");
            throw new LegoCheckedException(1073947393L);
        }
        String jsonString = replica.getProperty("mountConfigs");
        MountConfiguration cfg = (MountConfiguration)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)jsonString), MountConfiguration.class);
        if (!cfg.isUnmountPreviousCopy()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        this.createSubProcessor(context, cfg);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        return this.serialExcuteChildProc(context);
    }

    @Override
    protected String generateResultKey() {
        return null;
    }

    private void createSubProcessor(RecoveryProcessorContext context, MountConfiguration cfg) {
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (null == replica) {
            return;
        }
        String hostKey = "PG_DISASTER_HOST";
        String hostOrGroupId = (String)context.getRecoveryPlan().getGlobalSettings().get(hostKey);
        if (null == hostOrGroupId) {
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        Set replicas = replica.getPg().getReplicaList();
        for (ProtectGroupReplica tmpReplica : replicas) {
            Integer mountStatus = tmpReplica.getMountStatus();
            String replicaId = tmpReplica.getId();
            String hostSn = this.getHostSnInMountPlan(replicaId);
            if (!Integer.valueOf(ReplicaMountStatus.MOUNTED.getStatus()).equals(mountStatus) && !Integer.valueOf(ReplicaMountStatus.MOUNT_FAILED.getStatus()).equals(mountStatus) || !hostOrGroupId.equals(tmpReplica.getMountedHost()) && !hostOrGroupId.equals(hostSn) || replica.getId().equals(replicaId)) continue;
            UmountPreviousReplicaSubProcessor processor = new UmountPreviousReplicaSubProcessor();
            processor.setPlanId((String)replica.getProps().get("planId"));
            processor.setProcType(this.getProcType());
            processor.setProcessId(this.getProcessId());
            processor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
            processor.setParentProc(this);
            processor.setSrcReplica(tmpReplica);
            processor.setDeleteReplica(cfg.isDeleteReplica());
            subProcessors.add(processor);
        }
        this.setChildProc(subProcessors);
        this.updateSubProcessors(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private String getHostSnInMountPlan(String replicaId) {
        String sql = "select PROPVALUE from ti_rp_globalsettings where PROPNAME=:hostKey and planid in (select planid from ti_rp_globalsettings where PROPNAME=:replicaKey and PROPVALUE=:replicaId)";
        Session session = null;
        String hostSn = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createNativeQuery(sql);
            query.setParameter("hostKey", (Object)"PG_DISASTER_HOST");
            query.setParameter("replicaKey", (Object)"REPLICA_ID");
            query.setParameter("replicaId", (Object)replicaId);
            List plans = query.list();
            if (!plans.isEmpty() && plans.size() == 1) {
                hostSn = (String)plans.get(0);
            }
        }
        catch (Exception ex) {
            try {
                throw ExceptionUtil.convertException((Throwable)ex, (String)"Query globalsetting got error!", (long)-1L, null, (Log)LOGGER);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return hostSn;
    }
}

