/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.airgap;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.job.airgapjob.AirGapLinkProcessor;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTask;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class EnableStorageReplicationPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6962473449797182739L;
    private static final Log logger = LogFactory.getInstance(EnableStorageReplicationPortProcessor.class);

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroup pg = (ProtectGroup)context.getAttribute("Recovery_ProtectGroup");
        if (VerifyUtil.isEmpty((Object)pg)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("ism.drm.recovery.protectgroup.not.exist", null);
            return false;
        }
        logger.info((Object)"EnableStorageReplicationPortProcessor begin to execute.");
        if (!PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType())) {
            logger.info((Object)"Not air gap template, skip enable ports, pgName: %s", new Object[]{pg.getName()});
            return true;
        }
        List<StorageLinkPort> linkPorts = AirGapLinkPortUtil.getAirGapPortList(pg);
        if (CollectionUtils.isEmpty(linkPorts)) {
            logger.error((Object)"Error: not find pg ports. PgName: %s", new Object[]{pg.getName()});
            throw new LegoCheckedException(201L);
        }
        HashSet<String> failedPortNames = new HashSet<String>();
        long startTime = System.currentTimeMillis();
        if (!this.checkAndEnablePorts(context, linkPorts, pg, failedPortNames)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            String name = AirGapLinkPortUtil.getPortNames(failedPortNames);
            String[] failedNames = new String[]{name};
            this.updateProcessDetail("ism.drm.recovery.airgap.enable.port.error", failedNames);
            AirGapLinkPortUtil portUtil = AirGapLinkPortUtil.getInstance();
            Optional opt = context.getProtectPortTask();
            opt.ifPresent(task -> portUtil.consumeFailedAirGapTask((EnablePortTask)task, DrmEnumDefine.ExecTypeEnum.MANUAL.getType()));
            return false;
        }
        AirGapLinkPortUtil.runAirGapSyncRateAtOnce(pg);
        long endTime = System.currentTimeMillis();
        HashSet<String> enabledPortNames = new HashSet<String>();
        linkPorts.forEach(linkPort -> {
            if (CollectionUtils.isEmpty((Collection)failedPortNames) || !failedPortNames.contains(linkPort.getPortName())) {
                enabledPortNames.add(linkPort.getPortName());
            }
        });
        String name = AirGapLinkPortUtil.getPortNames(enabledPortNames);
        String[] successNames = new String[]{name};
        if (endTime - startTime <= 30000L) {
            this.updateProcessDetail("ism.drm.recovery.airgap.enable.port.already", successNames);
        } else {
            this.updateProcessDetail("ism.drm.recovery.airgap.enable.port.success", successNames);
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    private boolean checkAndEnablePorts(RecoveryProcessorContext context, List<StorageLinkPort> linkPorts, ProtectGroup pg, Set<String> failedPortNames) {
        List portIds = linkPorts.stream().map(StorageLinkPort::getPortId).collect(Collectors.toList());
        ArrayList<StorageLinkPort> waitCheckPorts = new ArrayList<StorageLinkPort>();
        String taskId = UUIDGenerator.getUUID();
        for (StorageLinkPort linkPort : linkPorts) {
            StorageLinkPort portInDb = this.getPortInDb(linkPort);
            if (VerifyUtil.isEmpty((Object)portInDb)) {
                logger.error((Object)"Not get port in db by id: %s. please check.", new Object[]{linkPort.getPortId()});
                throw new LegoCheckedException(201L);
            }
            portInDb.setExecTypeEnum(DrmEnumDefine.ExecTypeEnum.MANUAL);
            portInDb.setTaskId(taskId);
            portInDb.setOperator(pg.getName());
            portInDb.setPgWorkPorts(portIds);
            portInDb.setOperateType(2);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)portInDb);
            logger.info((Object)"Need to enable portName: %s", new Object[]{portInDb.getPortName()});
            waitCheckPorts.add(portInDb);
        }
        ProtectGroupReplica replica = pg.getAnyoneReplicationReplica();
        EnablePortTask task = new EnablePortTask();
        task.setPortList(waitCheckPorts);
        task.setDevSn(((StorageLinkPort)waitCheckPorts.get(0)).getDevSn());
        task.setTaskId(taskId);
        task.setRemoteDevSn(replica.getProductArray());
        task.setProtectGroup(pg);
        context.setAttribute("Recovery_PortTaskInfo", (Object)task);
        AirGapLinkProcessor linkProcessor = AirGapLinkProcessor.getInstance();
        linkProcessor.addEnablePortsToProcessor(task);
        if (CollectionUtils.isEmpty(waitCheckPorts)) {
            return true;
        }
        AirGapLinkPortUtil portUtil = AirGapLinkPortUtil.getInstance();
        HashSet<StorageLinkPort> waitEnableSet = new HashSet<StorageLinkPort>(waitCheckPorts);
        return portUtil.isHasPortEnable(waitEnableSet, failedPortNames);
    }

    private StorageLinkPort getPortInDb(StorageLinkPort linkPort) {
        return (StorageLinkPort)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(StorageLinkPort.class, (Serializable)((Object)linkPort.getPortId()));
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.recovery.framework.process.airgap.EnableStorageReplicationPortProcessor.des");
    }

    public String getStepPosition() {
        return "Enable the replication network port of the storage device.";
    }
}

