/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.framework.provider.RefactorConfigurationProviderMgr;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationProvider;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashSet;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class SaveReprotectedRpTransaction
implements TransactionCallback {
    private static final Log logger = LogFactory.getInstance(SaveReprotectedRpTransaction.class);
    private RecoveryPlan recoveryPlan;
    private boolean isNeedSync = false;

    public SaveReprotectedRpTransaction(RecoveryPlan recoveryPlan, boolean isNeedSync) {
        this.recoveryPlan = recoveryPlan;
        this.isNeedSync = isNeedSync;
    }

    public Object doInTransaction(TransactionStatus transactionStatus) {
        this.recoveryPlan.setRecoveryProcesses(new HashSet());
        this.saveReprotectUpdate(transactionStatus);
        return null;
    }

    private void saveReprotectUpdate(TransactionStatus transactionStatus) {
        try {
            RefactorConfigurationProviderMgr refactorCfgProviderMgr = RefactorConfigurationProviderMgr.getInstance();
            DrmEnumDefine.APP_TYPE appType = RecoveryServiceUtil.getAppType(this.recoveryPlan);
            IRefactorConfigurationProvider provider = refactorCfgProviderMgr.getRefactorConfigurationProvider(appType.name());
            if (null == provider) {
                throw new LegoCheckedException(1073947393L);
            }
            provider.saveConfiguration(this.recoveryPlan);
        }
        catch (Exception e) {
            this.handleSaveReprotectError(transactionStatus, e);
        }
    }

    private void handleSaveReprotectError(TransactionStatus transactionStatus, Exception e) {
        logger.error((Object)("failed to save reprotected recovery plan. Name:" + this.recoveryPlan.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786898L);
        transactionStatus.setRollbackOnly();
        if (e instanceof LegoCheckedException) {
            LegoCheckedException lex = (LegoCheckedException)((Object)e);
            throw new LegoCheckedException(lex.getErrorCode(), lex.getParameters());
        }
        throw new LegoCheckedException(-1L);
    }
}

