/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.provider.DeleteProcessorByNameComparator;
import com.huawei.ism.drm.recovery.framework.provider.IComparator;
import com.huawei.ism.drm.recovery.framework.template.RecoveryProcessDefTemplateMgr;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public abstract class BaseRecoveryProcessProvider
implements IRecoveryProcessProvider {
    private static Log logger = LogFactory.getInstance(BaseRecoveryProcessProvider.class);
    private static List<Integer> isSuitablePTTypesForLocal = new ArrayList<Integer>();
    private static List<Integer> isSuitablePTTypesForRemote = new ArrayList<Integer>();
    private static List<Integer> supportedPolicyTplTypesForReprotect = new ArrayList<Integer>();
    private static List<Integer> needCheckTplForRollBack = new ArrayList<Integer>();
    private static List<Integer> current4DCTpl = new ArrayList<Integer>();
    private static List<Integer> unSupportedTypesForReprotectOnRemoteDisasterSite = new ArrayList<Integer>();

    public RecoveryProcessDefinition getRecoveryProcess(RecoveryPlan recoveryPlan, String disasterSiteId, DrmEnumDefine.APP_TYPE appType, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType, ProtectGroup protectGroup) {
        DrmEnumDefine.RECOVERY_TARGET_TYPE recoveryTargetTypeE = DrmEnumDefine.RECOVERY_TARGET_TYPE.getType((String)recoveryPlan.getRecoveryTargetType());
        Integer replicaType = recoveryPlan.getReplicaType();
        RecoveryProcessDefinition rpDefinition = this.createRecoveryProcess(recoveryPlan.getPlanId(), disasterSiteId, appType, execType, recoveryTargetTypeE, replicaType, protectGroup);
        if (null == rpDefinition) {
            logger.error((Object)"the rpDefinition is null");
            throw new LegoCheckedException(-1L);
        }
        this.resetRecoveryProcessDefinition(recoveryPlan, rpDefinition, false);
        Set recoveryProcessors = rpDefinition.getRecoveryProcessors();
        for (RecoveryProcessor processor : recoveryProcessors) {
            processor.resetEnableStatus(protectGroup, execType);
        }
        return rpDefinition;
    }

    public Set<RecoveryProcessDefinition> getRecoveryProcesses(RecoveryPlan recoveryPlan, DrmEnumDefine.APP_TYPE appType, ProtectGroup protectGroup) {
        DrmEnumDefine.RECOVERY_TARGET_TYPE recoveryTargetTypeE = DrmEnumDefine.RECOVERY_TARGET_TYPE.getType((String)recoveryPlan.getRecoveryTargetType());
        Integer replicaType = recoveryPlan.getReplicaType();
        HashSet<RecoveryProcessDefinition> rpDefinitiones = new HashSet<RecoveryProcessDefinition>();
        List<DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E> procTypes = this.getSuitableProcTypes(recoveryPlan);
        for (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType : procTypes) {
            RecoveryProcessDefinition rpDefinition = this.createRecoveryProcess(recoveryPlan.getPlanId(), null, appType, procType, recoveryTargetTypeE, replicaType, protectGroup);
            if (null == rpDefinition) continue;
            this.resetRecoveryProcessDefinition(recoveryPlan, rpDefinition, false);
            Set recoveryProcessors = rpDefinition.getRecoveryProcessors();
            for (RecoveryProcessor processor : recoveryProcessors) {
                processor.resetEnableStatus(protectGroup, procType);
            }
            rpDefinitiones.add(rpDefinition);
        }
        return rpDefinitiones;
    }

    public int getProtectionType(ProtectGroup protectGroup) {
        return protectGroup.getTemplate().getType();
    }

    public void enableRecoverySyncProcessor(RecoveryProcessDefinition recoveryProcessDef, boolean isNeedUpdateDb) {
        Class<? extends RecoveryProcessor> syncProcessor = RecoveryProcessorMgr.getInstance().getSyncProcessor(recoveryProcessDef.getProtectionType());
        if (null == syncProcessor) {
            return;
        }
        ArrayList<Class<? extends RecoveryProcessor>> classes = new ArrayList<Class<? extends RecoveryProcessor>>();
        classes.add(syncProcessor);
        if (isNeedUpdateDb) {
            this.updateRecoveryProcessorEnableStatus(recoveryProcessDef, classes, true);
        } else {
            this.setRecoveryProcessorEnableStatus(recoveryProcessDef, classes, true);
        }
    }

    public void disableRecoverySyncProcessor(RecoveryProcessDefinition recoveryProcessDef, boolean isNeedUpdateDb) {
        Class<? extends RecoveryProcessor> syncProcessor = RecoveryProcessorMgr.getInstance().getSyncProcessor(recoveryProcessDef.getProtectionType());
        if (null == syncProcessor) {
            return;
        }
        ArrayList<Class<? extends RecoveryProcessor>> classes = new ArrayList<Class<? extends RecoveryProcessor>>();
        classes.add(syncProcessor);
        if (isNeedUpdateDb) {
            this.updateRecoveryProcessorEnableStatus(recoveryProcessDef, classes, false);
        } else {
            this.setRecoveryProcessorEnableStatus(recoveryProcessDef, classes, false);
        }
    }

    public Map<Integer, Class<? extends RecoveryProcessor>> registerSyncProcessor() {
        return new HashMap<Integer, Class<? extends RecoveryProcessor>>();
    }

    public void setRecoveryProcessorEnableStatus(RecoveryProcessDefinition recoveryProcessDef, List<Class<? extends RecoveryProcessor>> processores, boolean isEnable) {
        if (VerifyUtil.isEmpty((Collection)recoveryProcessDef.getRecoveryProcessors())) {
            return;
        }
        for (RecoveryProcessor processor : recoveryProcessDef.getRecoveryProcessors()) {
            if (!this.isSameRecoveryProcess(processor, processores)) continue;
            processor.setIsEnabled(Boolean.valueOf(isEnable));
        }
    }

    public void updateRecoveryProcessorEnableStatus(RecoveryProcessDefinition recoveryProcessDef, List<Class<? extends RecoveryProcessor>> processores, boolean isEnable) {
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        for (RecoveryProcessor processor : recoveryProcessDef.getRecoveryProcessors()) {
            if (!this.isSameRecoveryProcess(processor, processores)) continue;
            recoveryProcessService.deleteSubRecoveryProcessor(processor.getProcId());
            processor.setIsEnabled(Boolean.valueOf(isEnable));
            recoveryProcessService.updateRecoveryProcessor(processor);
        }
    }

    public void insertRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> afterProcCls, RecoveryProcessor recoveryProcessor, boolean isEnable, boolean isNeedUpdateDb) {
        if (null == recoveryProcessDef || recoveryProcessDef.getRecoveryProcessors().isEmpty() || null == afterProcCls || null == recoveryProcessor) {
            return;
        }
        RecoveryProcessor indexProcessor = this.getStartRecoveryProcessor(recoveryProcessDef, afterProcCls);
        if (null == indexProcessor) {
            return;
        }
        this.addRecoveryProcessors(recoveryProcessDef, indexProcessor, indexProcessor.getNextProcessor(), recoveryProcessor, isEnable);
        if (isNeedUpdateDb) {
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
        }
    }

    public void insertRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, RecoveryProcessor afterProcessor, RecoveryProcessor recoveryProcessor, boolean isEnable, boolean isNeedUpdateDb) {
        if (null == recoveryProcessDef || recoveryProcessDef.getRecoveryProcessors().isEmpty() || null == afterProcessor || null == recoveryProcessor) {
            return;
        }
        RecoveryProcessor indexProcessor = this.getStartRecoveryProcessor(recoveryProcessDef, afterProcessor);
        if (null == indexProcessor) {
            return;
        }
        this.addRecoveryProcessors(recoveryProcessDef, indexProcessor, indexProcessor.getNextProcessor(), recoveryProcessor, isEnable);
        if (isNeedUpdateDb) {
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
        }
    }

    public void insertRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> afterProcCls, List<Class<? extends RecoveryProcessor>> procClsList, boolean isEnable, boolean isNeedUpdateDb) {
        if (null == recoveryProcessDef || recoveryProcessDef.getRecoveryProcessors().isEmpty() || null == afterProcCls || null == procClsList || procClsList.isEmpty()) {
            return;
        }
        RecoveryProcessor indexProcessor = this.getStartRecoveryProcessor(recoveryProcessDef, afterProcCls);
        if (null == indexProcessor) {
            return;
        }
        this.addRecoveryProcessors(recoveryProcessDef, indexProcessor, indexProcessor.getNextProcessor(), procClsList, isEnable);
        if (isNeedUpdateDb) {
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
        }
    }

    public void deleteRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, final String procId, boolean isNeedUpdateDb) {
        if (null == recoveryProcessDef || null == procId || procId.isEmpty()) {
            throw new LegoCheckedException(1073947393L);
        }
        IComparator<RecoveryProcessor> comparator = new IComparator<RecoveryProcessor>(){

            @Override
            public boolean isEqual(RecoveryProcessor processor) {
                return null != processor && processor.getProcId().equals(procId);
            }
        };
        this.removeRecoveryProcessors(recoveryProcessDef, comparator, isNeedUpdateDb);
    }

    public void deleteRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, List<Class<? extends RecoveryProcessor>> procClsList, boolean isNeedUpdateDb) {
        if (null == recoveryProcessDef || null == procClsList || procClsList.isEmpty()) {
            return;
        }
        for (Class<? extends RecoveryProcessor> rProcCls : procClsList) {
            DeleteProcessorByNameComparator comparator = new DeleteProcessorByNameComparator(rProcCls);
            this.removeRecoveryProcessors(recoveryProcessDef, comparator, isNeedUpdateDb);
        }
    }

    public void replaceRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> startProcCls, Class<? extends RecoveryProcessor> endProcCls, List<Class<? extends RecoveryProcessor>> procClsList, boolean isEnable, boolean isNeedUpdateDb) {
        if (this.isReplaceProcessorParamEmpty(recoveryProcessDef, startProcCls, endProcCls, procClsList)) {
            return;
        }
        RecoveryProcessor startProcessor = this.getStartRecoveryProcessor(recoveryProcessDef, startProcCls);
        if (null == startProcessor) {
            logger.error((Object)("Does not find the start processor. ClassName:" + startProcCls.getName()), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        RecoveryProcessor endProcessor = null;
        ArrayList<Class<? extends RecoveryProcessor>> processors = new ArrayList<Class<? extends RecoveryProcessor>>();
        RecoveryProcessor indexProcessor = startProcessor;
        do {
            processors.add(indexProcessor.getClass());
            indexProcessor = indexProcessor.getNextProcessor();
            if (null == indexProcessor || !indexProcessor.getClass().getName().equals(endProcCls.getName())) continue;
            endProcessor = indexProcessor;
            processors.add(endProcessor.getClass());
            break;
        } while (null != indexProcessor);
        this.deleteRecoveryProcessors(recoveryProcessDef, processors, isNeedUpdateDb);
        if (null == endProcessor) {
            logger.error((Object)"Invalid end processor", 90160758784001L);
            throw new LegoCheckedException(-1L);
        }
        this.addRecoveryProcessors(recoveryProcessDef, startProcessor.getPreviousProcessor(), endProcessor.getNextProcessor(), procClsList, isEnable);
        if (isNeedUpdateDb) {
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
        }
    }

    public boolean isSuitableProtectGroup(DrmEnumDefine.RECOVERY_PLAN_TYPE_E planType, ProtectGroup protectGroup) {
        Integer policyTemplateType = protectGroup.getTemplate().getType();
        if (DrmEnumDefine.RECOVERY_PLAN_TYPE_E.LOCAL.equals((Object)planType)) {
            return isSuitablePTTypesForLocal.contains(policyTemplateType);
        }
        return isSuitablePTTypesForRemote.contains(policyTemplateType);
    }

    public void checkIfAllowReprotect(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null or getProtectGroups is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        String extAttributes = (String)recoveryPlan.getGlobalSettings().get("RECOVERY_EXTEND_ATTRIBUTES");
        if (String.valueOf(DrmEnumDefine.RECOVERY_EXTEND_ATTRIBUTES.REFACTOR_CONFIGURATION_SUCCESS.getValue()).equals(extAttributes)) {
            return;
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        Integer policyTemplateType = protectGroup.getTemplate().getType();
        if (!supportedPolicyTplTypesForReprotect.contains(policyTemplateType)) {
            logger.error((Object)"Reprotect is not supported for the policy template.", 90160758784001L);
            throw new LegoCheckedException(1073948736L);
        }
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        ProtectGroupReplica pgReplica = null;
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            pgReplica = replica;
            break;
        }
        if (null == pgReplica) {
            logger.error((Object)"There is no suited protect group replica.", 90160758784001L);
            throw new LegoCheckedException(-1L);
        }
        this.doCheck(protectGroup, policyTemplateType, pgReplica);
    }

    private void doCheck(ProtectGroup protectGroup, Integer policyTemplateType, ProtectGroupReplica pgReplica) {
        if (unSupportedTypesForReprotectOnRemoteDisasterSite.contains(policyTemplateType) && this.isRecoveryToRemoteDisasterSite(pgReplica)) {
            if (current4DCTpl.contains(policyTemplateType) && this.checkSpecial4DCTpl(protectGroup)) {
                return;
            }
            logger.error((Object)"Reprotect is not supported after switching to remote disaster center.", 90160758784001L);
            throw new LegoCheckedException(1073948737L);
        }
    }

    private boolean checkSpecial4DCTpl(ProtectGroup protectGroup) {
        Set hmSites = protectGroup.getHyperMetroSiteIdSet();
        String preProductSiteId = protectGroup.getProductSiteId();
        return hmSites.contains(preProductSiteId);
    }

    public void checkIfAllowRollBack(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null || CollectionUtils.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null or protectGroup is illegal.");
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        int policyTemplateType = protectGroup.getTemplate().getType();
        if (!needCheckTplForRollBack.contains(policyTemplateType)) {
            logger.debug((Object)"No need to check when rollback, policyTemplateType: %s", new Object[]{String.valueOf(policyTemplateType)});
            return;
        }
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        Set hyperMetroSiteSet = protectGroup.getHyperMetroSiteIdSet();
        if (policyTemplateType == 40 || policyTemplateType == 42) {
            this.checkCascadeTpl(protectGroup, hyperMetroSiteSet, disasterSiteId);
        }
        if (policyTemplateType == 41 || policyTemplateType == 43) {
            this.checkConcurrentTpl(protectGroup, hyperMetroSiteSet, disasterSiteId);
        }
    }

    private void checkCascadeTpl(ProtectGroup protectGroup, Set<String> hmSiteSet, String disasterSiteId) {
        String productSite = protectGroup.getProductSiteId();
        if (hmSiteSet.contains(productSite)) {
            return;
        }
        if (Objects.equals(protectGroup.getProductSiteId(), disasterSiteId)) {
            return;
        }
        String tmpRecoverySite = null;
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || replica.getProtectLocation() != DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue()) continue;
            tmpRecoverySite = replica.getRecoverySite();
            break;
        }
        if (!VerifyUtil.isEmpty(tmpRecoverySite) && tmpRecoverySite.equals(disasterSiteId)) {
            return;
        }
        String siteName = BaseRecoveryProcessProvider.getSiteNameById(disasterSiteId);
        logger.error((Object)"disasterSiteId: %s is not allowed to rollback when cascade mode", new Object[]{siteName});
        throw new LegoCheckedException(1073948763L, new String[]{siteName});
    }

    private void checkConcurrentTpl(ProtectGroup protectGroup, Set<String> hmSiteSet, String disasterSiteId) {
        String productSite = protectGroup.getProductSiteId();
        if (hmSiteSet.contains(productSite)) {
            return;
        }
        HashSet<String> recoverySites = new HashSet<String>();
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica)) continue;
            recoverySites.add(replica.getRecoverySite());
        }
        if (hmSiteSet.contains(disasterSiteId) && !recoverySites.contains(disasterSiteId)) {
            String siteName = BaseRecoveryProcessProvider.getSiteNameById(disasterSiteId);
            logger.error((Object)"disasterSiteId: %s is not allowed to rollback when current mode", new Object[]{siteName});
            throw new LegoCheckedException(1073948763L, new String[]{siteName});
        }
    }

    private static String getSiteNameById(String siteId) {
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site srcSite = siteService.getSiteById(siteId);
        return srcSite != null ? srcSite.getName() : "";
    }

    public boolean checkProductionBusinessStopped(RecoveryProcessorContext context) {
        if (context == null) {
            return true;
        }
        String productionSiteId = RecoveryServiceUtil.getProductSiteId(context.getRecoveryPlan());
        Site productionSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(productionSiteId);
        Object object = context.getAttribute("recoveryTasks");
        if (object == null) {
            return true;
        }
        Collection recoveryTasks = (Collection)object;
        Set<RecoveryTask> rootRecoveryTasks = RecoveryTaskUtil.getRootRecoveryTasks(recoveryTasks);
        boolean isRollbackType = false;
        if (null != context.getAttribute("PLAN_EXEXUTE_TYPE")) {
            boolean bl = isRollbackType = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK == context.getAttribute("PLAN_EXEXUTE_TYPE");
        }
        if (DrmEnumDefine.RECOVERY_PLAN_TYPE_E.LOCAL.getValue() == context.getRecoveryPlan().getPlanType() || isRollbackType) {
            return RecoveryProcessUtil.isAllSrcLunUnMapping(context, rootRecoveryTasks);
        }
        return RecoveryProcessUtil.isAllSrcLunUnMapping(context, productionSite, rootRecoveryTasks);
    }

    public String addCustomRecoveryProcessor(RecoveryProcessDefinition rpDefinition, Class<? extends RecoveryProcessor> afterProcCls, Map<String, Object> params, boolean isEnable, boolean isNeedUpdateDb) {
        return null;
    }

    public String addCustomRecoveryProcessor(RecoveryProcessDefinition rpDefinition, RecoveryProcessor afterProcessor, Map<String, Object> params, boolean isEnable, boolean isNeedUpdateDb) {
        return null;
    }

    public void modifyCustomRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDefinition, String procId, Map<String, Object> params) {
        logger.debug((Object)"Null implement");
    }

    public Map<String, Object> getCustomRecoveryProcessorInfos(RecoveryProcessDefinition rpDef, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, String procId) {
        return null;
    }

    public Class<? extends RecoveryProcessor> getCustomRecoveryProcessorClass() {
        return null;
    }

    public Map<String, Object> checkRecoveryContext(String planId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, Map<String, String> recoveryContext, User operator) {
        return new HashMap<String, Object>();
    }

    public boolean checkIfAllowDelete(RecoveryProcessor recoveryProcessor) {
        if (null == recoveryProcessor) {
            return true;
        }
        return recoveryProcessor.getIsPreset() == false;
    }

    public String getRecoverySiteId(String planId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, Map<String, String> recoveryContext) {
        return "";
    }

    public String getRecoverySiteId(RecoveryPlan plan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, Map<String, String> recoveryContext) {
        return "";
    }

    public void encryptProperties(RecoveryPlan recoveryPlan) {
        logger.debug((Object)"Enter encryptProperties");
    }

    public void decryptPropreties(RecoveryPlan recoveryPlan) {
        logger.debug((Object)"Enter decryptProperties");
    }

    protected boolean isSameRecoveryProcess(RecoveryProcessor recoveryProcessor, List<Class<? extends RecoveryProcessor>> classes) {
        if (null == recoveryProcessor || VerifyUtil.isEmpty(classes)) {
            return false;
        }
        for (Class<? extends RecoveryProcessor> cls : classes) {
            if (!recoveryProcessor.getClass().getName().equals(cls.getName())) continue;
            return true;
        }
        return false;
    }

    protected RecoveryProcessor getCustomRecoveryProcessor(Map<String, Object> params) {
        return null;
    }

    protected String getDisterSiteId(String defaultSiteId, ProtectGroup pg) {
        ProtectGroupReplica rep = RecoveryProcessUtil.getProtectGroupReplicaBySiteId(pg, defaultSiteId);
        if (null != rep) {
            return rep.getRecoverySite();
        }
        return defaultSiteId;
    }

    private void removeRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, IComparator<RecoveryProcessor> comparator, boolean isNeedUpdateDb) {
        RecoveryProcessor delProcessor = this.getDeletedRecoveryProcessor(recoveryProcessDef, comparator);
        if (null == delProcessor) {
            logger.error((Object)"The processor does not exist.", 90160758784001L);
            return;
        }
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        RecoveryProcessor preProcessor = delProcessor.getPreviousProcessor();
        RecoveryProcessor nextProcessor = delProcessor.getNextProcessor();
        if (null != preProcessor) {
            preProcessor.setNextProcessor(nextProcessor);
        }
        if (null != nextProcessor) {
            nextProcessor.setPreviousProcessor(preProcessor);
        }
        delProcessor.setPreviousProcessor(null);
        delProcessor.setNextProcessor(null);
        if (isNeedUpdateDb) {
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
            recoveryProcessService.deleteRecoveryProcessor(delProcessor);
        }
        recoveryProcessDef.getRecoveryProcessors().remove(delProcessor);
    }

    private RecoveryProcessor getDeletedRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDef, IComparator<RecoveryProcessor> comparator) {
        RecoveryProcessor delProcessor = null;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        for (RecoveryProcessor rProcessor : recoveryProcessors) {
            if (!comparator.isEqual(rProcessor)) continue;
            delProcessor = rProcessor;
            break;
        }
        return delProcessor;
    }

    private RecoveryProcessor getStartRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> startProcCls) {
        RecoveryProcessor startProcessor = null;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        for (RecoveryProcessor recoveryProcessor : recoveryProcessors) {
            if (!recoveryProcessor.getClass().getName().equals(startProcCls.getName())) continue;
            startProcessor = recoveryProcessor;
            break;
        }
        return startProcessor;
    }

    private RecoveryProcessor getStartRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDef, RecoveryProcessor startProcessor) {
        RecoveryProcessor newStartProcessor = null;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        for (RecoveryProcessor recoveryProcessor : recoveryProcessors) {
            if (!recoveryProcessor.getProcId().equals(startProcessor.getProcId())) continue;
            newStartProcessor = recoveryProcessor;
            break;
        }
        return newStartProcessor;
    }

    private void addRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, RecoveryProcessor startRProcessor, RecoveryProcessor endRProcessor, RecoveryProcessor processor, boolean isEnable) {
        RecoveryProcessor indexStartRProcessor = startRProcessor;
        RecoveryProcessor indexEndRProcessor = endRProcessor;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        recoveryProcessors.add(processor);
        processor.setProcType(recoveryProcessDef.getProcType());
        processor.setIsEnabled(Boolean.valueOf(isEnable));
        indexStartRProcessor.setNextProcessor(processor);
        processor.setPreviousProcessor(indexStartRProcessor);
        if (null == indexEndRProcessor) {
            return;
        }
        processor.setNextProcessor(indexEndRProcessor);
        indexEndRProcessor.setPreviousProcessor(processor);
    }

    private void addRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, RecoveryProcessor startRProcessor, RecoveryProcessor endRProcessor, List<Class<? extends RecoveryProcessor>> procClsList, boolean isEnable) {
        RecoveryProcessor indexStartRProcessor = startRProcessor;
        RecoveryProcessor indexEndRProcessor = endRProcessor;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        for (Class<? extends RecoveryProcessor> processorCls : procClsList) {
            RecoveryProcessor processor = this.createRecoveryProcessor(processorCls);
            processor.setProcName(processor.getName());
            processor.setProcType(recoveryProcessDef.getProcType());
            processor.setIsEnabled(Boolean.valueOf(isEnable));
            if (null == startRProcessor) {
                indexStartRProcessor = processor;
                continue;
            }
            indexStartRProcessor.setNextProcessor(processor);
            processor.setPreviousProcessor(indexStartRProcessor);
            recoveryProcessors.add(processor);
            indexStartRProcessor = processor;
        }
        if (null != indexEndRProcessor) {
            indexStartRProcessor.setNextProcessor(indexEndRProcessor);
            indexEndRProcessor.setPreviousProcessor(indexStartRProcessor);
        }
    }

    private RecoveryProcessor createRecoveryProcessor(Class<? extends RecoveryProcessor> processorCls) {
        RecoveryProcessor processor = null;
        try {
            processor = processorCls.newInstance();
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Creating recovery processor failed. ClsName:" + processorCls.getName()), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return processor;
    }

    private RecoveryProcessDefinition createRecoveryProcess(String planId, String disasterSiteId, DrmEnumDefine.APP_TYPE appType, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType, DrmEnumDefine.RECOVERY_TARGET_TYPE recoveryTargetType, Integer replicaType, ProtectGroup protectGroup) {
        int protectionType = null != replicaType ? replicaType.intValue() : this.getProtectionType(protectGroup);
        RecoveryProcessDefTemplateMgr templateMgr = RecoveryProcessDefTemplateMgr.getInstance();
        Set<RecoveryProcessor> recoveryProcessors = templateMgr.createRecoveryProcessors(appType, execType, recoveryTargetType, protectionType);
        if (null == recoveryProcessors || recoveryProcessors.isEmpty()) {
            return null;
        }
        RecoveryProcessDefinition rpDefinition = new RecoveryProcessDefinition();
        this.initRecoveryProcessors(recoveryProcessors, planId, rpDefinition.getProcessId());
        rpDefinition.setPlanId(planId);
        rpDefinition.setDisasterSiteId(disasterSiteId);
        rpDefinition.setProcType(execType.getValue());
        rpDefinition.setAppType(appType.getValue());
        rpDefinition.setProtectionType(protectionType);
        rpDefinition.setVersion(templateMgr.getVersion(appType, execType, recoveryTargetType, protectionType));
        rpDefinition.setRecoveryProcessors(recoveryProcessors);
        return rpDefinition;
    }

    private void initRecoveryProcessors(Set<RecoveryProcessor> recoveryProcessors, String planId, String processId) {
        for (RecoveryProcessor processor : recoveryProcessors) {
            processor.setProcessId(processId);
            processor.setPlanId(planId);
            if (VerifyUtil.isEmpty((Collection)processor.getChildProc())) continue;
            this.initRecoveryProcessors(processor.getChildProc(), planId, processId);
        }
    }

    private List<DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E> getSuitableProcTypes(RecoveryPlan recoveryPlan) {
        ArrayList<DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E> procTypes = new ArrayList<DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E>();
        if (DrmEnumDefine.RECOVERY_PLAN_TYPE_E.REMOTE.getValue() == recoveryPlan.getPlanType()) {
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION);
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION);
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY);
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING);
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING);
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT);
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK);
        } else {
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING);
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING);
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK);
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.MOUNT_REPLICA);
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.UMOUNT_REPLICA);
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SWAP);
            procTypes.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.VM_ROLLBACK);
        }
        return procTypes;
    }

    private boolean isRecoveryToRemoteDisasterSite(ProtectGroupReplica pgReplica) {
        return DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue() == pgReplica.getProtectLocation() || DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue() == pgReplica.getProtectLocation() || DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue() == pgReplica.getProtectLocation();
    }

    private boolean isReplaceProcessorParamEmpty(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> startProcCls, Class<? extends RecoveryProcessor> endProcCls, List<Class<? extends RecoveryProcessor>> procClsList) {
        return null == recoveryProcessDef || VerifyUtil.isEmpty((Collection)recoveryProcessDef.getRecoveryProcessors()) || null == startProcCls || null == endProcCls || VerifyUtil.isEmpty(procClsList);
    }

    public void checkRecoverySettings(List<RecoverySetting> recoverySettingList) {
    }

    public List<RecoveryProcessor> filterProcessor(List<RecoveryProcessor> processors, Map<String, String> filters) {
        return null;
    }

    static {
        isSuitablePTTypesForRemote.add(6);
        isSuitablePTTypesForRemote.add(5);
        isSuitablePTTypesForRemote.add(4);
        isSuitablePTTypesForRemote.add(3);
        isSuitablePTTypesForRemote.add(0);
        isSuitablePTTypesForRemote.add(1);
        isSuitablePTTypesForRemote.add(18);
        isSuitablePTTypesForRemote.add(20);
        isSuitablePTTypesForRemote.add(21);
        isSuitablePTTypesForRemote.add(22);
        isSuitablePTTypesForRemote.add(23);
        isSuitablePTTypesForRemote.add(24);
        isSuitablePTTypesForRemote.add(25);
        isSuitablePTTypesForRemote.add(26);
        isSuitablePTTypesForRemote.add(27);
        isSuitablePTTypesForRemote.add(30);
        isSuitablePTTypesForRemote.add(31);
        isSuitablePTTypesForRemote.add(32);
        isSuitablePTTypesForRemote.add(35);
        isSuitablePTTypesForRemote.add(36);
        isSuitablePTTypesForRemote.add(33);
        isSuitablePTTypesForRemote.add(34);
        isSuitablePTTypesForRemote.add(37);
        isSuitablePTTypesForRemote.add(38);
        isSuitablePTTypesForRemote.add(39);
        isSuitablePTTypesForRemote.add(40);
        isSuitablePTTypesForRemote.add(41);
        isSuitablePTTypesForRemote.add(42);
        isSuitablePTTypesForRemote.add(43);
        isSuitablePTTypesForRemote.add(47);
        isSuitablePTTypesForLocal.add(2);
        isSuitablePTTypesForLocal.add(14);
        isSuitablePTTypesForLocal.add(19);
        isSuitablePTTypesForLocal.add(17);
        isSuitablePTTypesForLocal.add(28);
        isSuitablePTTypesForLocal.add(15);
        isSuitablePTTypesForLocal.add(44);
        isSuitablePTTypesForLocal.add(45);
        isSuitablePTTypesForLocal.add(46);
        supportedPolicyTplTypesForReprotect.add(6);
        supportedPolicyTplTypesForReprotect.add(5);
        supportedPolicyTplTypesForReprotect.add(4);
        supportedPolicyTplTypesForReprotect.add(3);
        supportedPolicyTplTypesForReprotect.add(0);
        supportedPolicyTplTypesForReprotect.add(1);
        supportedPolicyTplTypesForReprotect.add(11);
        supportedPolicyTplTypesForReprotect.add(18);
        supportedPolicyTplTypesForReprotect.add(20);
        supportedPolicyTplTypesForReprotect.add(21);
        supportedPolicyTplTypesForReprotect.add(22);
        supportedPolicyTplTypesForReprotect.add(23);
        supportedPolicyTplTypesForReprotect.add(24);
        supportedPolicyTplTypesForReprotect.add(25);
        supportedPolicyTplTypesForReprotect.add(26);
        supportedPolicyTplTypesForReprotect.add(27);
        supportedPolicyTplTypesForReprotect.add(30);
        supportedPolicyTplTypesForReprotect.add(31);
        supportedPolicyTplTypesForReprotect.add(32);
        supportedPolicyTplTypesForReprotect.add(34);
        supportedPolicyTplTypesForReprotect.add(37);
        supportedPolicyTplTypesForReprotect.add(35);
        supportedPolicyTplTypesForReprotect.add(36);
        supportedPolicyTplTypesForReprotect.add(38);
        supportedPolicyTplTypesForReprotect.add(39);
        supportedPolicyTplTypesForReprotect.add(40);
        supportedPolicyTplTypesForReprotect.add(41);
        supportedPolicyTplTypesForReprotect.add(42);
        supportedPolicyTplTypesForReprotect.add(43);
        supportedPolicyTplTypesForReprotect.add(33);
        supportedPolicyTplTypesForReprotect.add(47);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(5);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(4);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(3);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(35);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(38);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(41);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(39);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(40);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(42);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(43);
        needCheckTplForRollBack.add(40);
        needCheckTplForRollBack.add(41);
        needCheckTplForRollBack.add(42);
        needCheckTplForRollBack.add(43);
        current4DCTpl.add(41);
        current4DCTpl.add(43);
        current4DCTpl.add(39);
    }
}

