/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.drm.base.util.ResourceUtil;
import com.huawei.ism.drm.util.FusionCloudUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class FixedRecoveryThreadPool {
    private static final Log logger = LogFactory.getInstance(FixedRecoveryThreadPool.class);
    private static final String STR_LARGE_SPECIFICATION_POOL_SIZE = "260";
    private static ExecutorService executorService;

    private FixedRecoveryThreadPool() {
    }

    public static Future<Boolean> submit(Callable<Boolean> callable) {
        return executorService.submit(callable);
    }

    static {
        int poolSize = 20;
        try {
            String strPoolSize = ResourceUtil.getValue("recovery.thread.pool.size");
            poolSize = Integer.parseInt(strPoolSize);
            String strLargeSpecificationsPoolSize = ResourceUtil.getValue("recovery.large.specifications.thread.pool.size", STR_LARGE_SPECIFICATION_POOL_SIZE);
            int poolLargeSpecificationsSize = Integer.parseInt(strLargeSpecificationsPoolSize);
            Runtime runtime = Runtime.getRuntime();
            if (runtime.availableProcessors() >= 8 && FusionCloudUtil.isCurrentFCVersionHighThanParamVerion((String)"6.3")) {
                poolSize = poolLargeSpecificationsSize;
                logger.info((Object)("Fixed recovery ThreadPool, poosize=" + poolSize));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting the config of thread pool size failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        executorService = Executors.newFixedThreadPool(poolSize);
    }
}

