/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessCascadeExecutor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class RecoveryProcessSerialExecutor
implements IProcessor {
    private static final Log LOG = LogFactory.getInstance(RecoveryProcessSerialExecutor.class);
    private String name;
    private List<IProcessor> processors = new ArrayList<IProcessor>();
    private int curProcessorIndex = -1;

    /*
     * WARNING - void declaration
     */
    private RecoveryProcessSerialExecutor(String name, List<? extends IProcessor> processors) {
        if (name == null || processors == null || processors.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        for (IProcessor iProcessor : processors) {
            void var4_4;
            RecoveryProcessor rProcessor;
            if (iProcessor instanceof RecoveryProcessor && null != (rProcessor = (RecoveryProcessor)iProcessor).getNextCascadeProcessor()) {
                RecoveryProcessCascadeExecutor recoveryProcessCascadeExecutor = RecoveryProcessCascadeExecutor.createExecutor(rProcessor);
            }
            this.processors.add((IProcessor)var4_4);
        }
    }

    public static RecoveryProcessSerialExecutor createRecoveryProcessExecutor(List<? extends IProcessor> recoveryProcessors, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type) {
        if (null == recoveryProcessors || recoveryProcessors.isEmpty()) {
            return null;
        }
        return new RecoveryProcessSerialExecutor("RCT_" + UUIDGenerator.getUUID(), recoveryProcessors);
    }

    public static RecoveryProcessSerialExecutor createRecoveryProcessExecutor(Set<RecoveryProcessor> recoveryProcessors, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type) {
        if (null == recoveryProcessors || recoveryProcessors.isEmpty()) {
            return null;
        }
        List<? extends IProcessor> sortedProcessors = RecoveryServiceUtil.sortAndUpdateProcessorRation(recoveryProcessors);
        return new RecoveryProcessSerialExecutor("RCT_" + UUIDGenerator.getUUID(), sortedProcessors);
    }

    public static RecoveryProcessSerialExecutor createRecoveryProcessExecutorSort(Set<RecoveryProcessor> recoveryProcessors) {
        if (null == recoveryProcessors || recoveryProcessors.isEmpty()) {
            return null;
        }
        List<? extends IProcessor> sortedProcessors = RecoveryServiceUtil.sortAndUpdateProcessorRation(recoveryProcessors);
        return new RecoveryProcessSerialExecutor("RCT_" + UUIDGenerator.getUUID(), sortedProcessors);
    }

    public boolean isAllProcessorCompleted() {
        return this.curProcessorIndex == this.processors.size() - 1;
    }

    public DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E getLastProcessorResult() {
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E result = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER;
        if (null != this.processors && !this.processors.isEmpty()) {
            for (int i = this.processors.size() - 1; i >= 0; --i) {
                RecoveryProcessor recoveryProcessor = (RecoveryProcessor)this.processors.get(i);
                if (!recoveryProcessor.getIsEnabled().booleanValue()) continue;
                return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.getType((int)recoveryProcessor.getProcStatus());
            }
        }
        return result;
    }

    public boolean process(RecoveryProcessorContext context) {
        return this.callProcessors(context);
    }

    public String getName() {
        return this.name;
    }

    private boolean callProcessors(RecoveryProcessorContext context) {
        IProcessor processor = null;
        boolean isNormal = true;
        try {
            int size = this.processors.size();
            for (int i = 0; i < size; ++i) {
                RecoveryProcessor recoveryProcessor;
                processor = this.processors.get(i);
                if (null == processor) continue;
                this.curProcessorIndex = i;
                boolean isRecoveryProcessor = processor instanceof RecoveryProcessor;
                if (isRecoveryProcessor && !(recoveryProcessor = (RecoveryProcessor)processor).getIsEnabled().booleanValue()) continue;
                boolean processResult = processor.process(context);
                if (isRecoveryProcessor) {
                    RecoveryProcessor recoveryProcessor2 = (RecoveryProcessor)processor;
                    ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor(recoveryProcessor2);
                }
                if (processResult) continue;
                isNormal = false;
                break;
            }
        }
        catch (Exception e) {
            String processorName = "";
            if (null != processor) {
                processorName = processor.getName();
            }
            LOG.error((Object)"Calling processor failed. Name: %s. %s", new Object[]{processorName, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setContextErrorCode(context, e);
            isNormal = false;
        }
        return isNormal;
    }

    private void setContextErrorCode(RecoveryProcessorContext context, Throwable e) {
        if (e instanceof LegoCheckedException) {
            context.setAttribute("icommand:errorcode", (Object)((LegoCheckedException)e).getErrorCode());
        } else if (e instanceof LegoUncheckedException) {
            context.setAttribute("icommand:errorcode", (Object)((LegoUncheckedException)e).getErrorCode());
        } else {
            context.setAttribute("icommand:errorcode", (Object)0x200909L);
        }
    }
}

