/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

public class RecoveryProcessorCallable
implements Callable<Boolean> {
    private static final Log logger = LogFactory.getInstance(RecoveryProcessorCallable.class);
    private RecoveryProcessorContext context;
    private IProcessor recoveryProcessor;
    private CountDownLatch doneSignal;

    public RecoveryProcessorCallable(IProcessor recoveryProcessor, RecoveryProcessorContext context, CountDownLatch doneSignal) {
        this.recoveryProcessor = recoveryProcessor;
        this.context = context;
        this.doneSignal = doneSignal;
    }

    @Override
    public Boolean call() {
        boolean result = this.recoveryProcessor.process(this.context);
        if (this.recoveryProcessor instanceof RecoveryProcessor) {
            try {
                RecoveryProcessor recoveryProcess = (RecoveryProcessor)this.recoveryProcessor;
                ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor(recoveryProcess);
            }
            catch (Exception e) {
                logger.error((Object)("Update recovery processor failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }
        this.doneSignal.countDown();
        return result;
    }
}

