/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.template;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.xml.XmlParser;
import com.huawei.ism.drm.common.sdk.model.ProcessTask;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefTemplate;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class RecoveryProcessDefTemplateParaser {
    private static final Log logger = LogFactory.getInstance(RecoveryProcessDefTemplateParaser.class);
    private XmlParser xmlParser = new XmlParser();
    private List<Document> templateDocuments = new ArrayList<Document>();

    public void readTemplateFile(URL processFileUrl) {
        Document document = this.xmlParser.init(processFileUrl);
        if (null != document) {
            this.templateDocuments.add(document);
        }
    }

    public Set<RecoveryProcessDefTemplate> parseTemplateFile() {
        HashSet<RecoveryProcessDefTemplate> templates = new HashSet<RecoveryProcessDefTemplate>();
        for (Document document : this.templateDocuments) {
            Element rootElement = this.xmlParser.getRootElement(document);
            if (null == rootElement) {
                throw new LegoCheckedException(-1L);
            }
            List<Node> processNodes = this.xmlParser.getNodes(rootElement, "/processes/process");
            for (Node processNode : processNodes) {
                Element processElement = (Element)processNode;
                this.parseRecoveryProcessTemplate(processElement, templates);
            }
        }
        return templates;
    }

    private void parseRecoveryProcessTemplate(Element processElement, Set<RecoveryProcessDefTemplate> templates) {
        String processName = this.xmlParser.getAttribute(processElement, "name");
        ArrayList<Map<String, String>> processKeysList = new ArrayList<Map<String, String>>();
        this.parseProcessKeys(processElement, processKeysList);
        ArrayList<ProcessTask> processTasks = new ArrayList<ProcessTask>();
        List<Node> processorNodes = this.xmlParser.getNodes(processElement, "processor");
        for (Node node : processorNodes) {
            Element processorElement = (Element)node;
            this.parseProcessTask(processorElement, processTasks);
        }
        for (Map map : processKeysList) {
            RecoveryProcessDefTemplate template = new RecoveryProcessDefTemplate();
            template.setName(processName.trim());
            template.setProcessKeys(map);
            template.setProcessTasks(processTasks);
            templates.add(template);
        }
    }

    private void parseProcessKeys(Element processElement, List<Map<String, String>> processKeysList) {
        int index = 0;
        List attributes = processElement.attributes();
        for (Object attributeObj : attributes) {
            ++index;
            Attribute attribute = (Attribute)attributeObj;
            String attributeKey = attribute.getName();
            if (!attributeKey.equals("name")) continue;
            break;
        }
        this.parseProcessKeys(new HashMap<String, String>(), index, attributes, processKeysList);
    }

    private void parseProcessKeys(Map<String, String> processKeys, int index, List<?> attributes, List<Map<String, String>> processKeysList) {
        String[] values;
        if (index >= attributes.size()) {
            logger.warn((Object)"index is bigger than size", 90160758786857L);
            return;
        }
        Attribute attribute = (Attribute)attributes.get(index);
        String attributeKey = attribute.getName();
        String attributeValues = attribute.getValue();
        ++index;
        for (String attributeValue : values = attributeValues.split(",")) {
            if (VerifyUtil.isEmpty((String)attributeValue)) continue;
            HashMap<String, String> newProcessKeys = new HashMap<String, String>();
            newProcessKeys.putAll(processKeys);
            newProcessKeys.put(attributeKey, attributeValue.trim());
            if (index == attributes.size()) {
                processKeysList.add(newProcessKeys);
                continue;
            }
            this.parseProcessKeys(newProcessKeys, index, attributes, processKeysList);
        }
    }

    private void parseProcessTask(Element processorElement, List<ProcessTask> processTasks) {
        ProcessTask processTask = new ProcessTask();
        String processTaskId = this.xmlParser.getAttribute(processorElement, "id");
        String taskClass = this.xmlParser.getAttribute(processorElement, "class");
        processTask.setTaskClass(taskClass);
        processTask.setProcessTaskId(processTaskId);
        processTask.setIsEnabled(Boolean.valueOf(this.getBooleanVlue(processorElement, "isEnabled", true)));
        processTask.setIsEditable(Boolean.valueOf(this.getBooleanVlue(processorElement, "isEditable", false)));
        processTasks.add(processTask);
        HashMap<String, String> attributes = new HashMap<String, String>();
        List<Node> attributeNodes = this.xmlParser.getNodes(processorElement, "attribute");
        for (Node attributeNode : attributeNodes) {
            String attributeName = this.xmlParser.getAttribute((Element)attributeNode, "name");
            String attributeValue = attributeNode.getText();
            attributes.put(attributeName.trim().toLowerCase(Locale.getDefault()), attributeValue.trim());
        }
        processTask.setAttributes(attributes);
        ArrayList<ProcessTask> childProcessTasks = new ArrayList<ProcessTask>();
        processTask.setChildProcessTasks(childProcessTasks);
        List<Node> childProcessorNodes = this.xmlParser.getNodes(processorElement, "subprocess/processor");
        for (Node childProcessorNode : childProcessorNodes) {
            Element element = (Element)childProcessorNode;
            this.parseProcessTask(element, childProcessTasks);
        }
    }

    private boolean getBooleanVlue(Element processorElement, String attributeName, boolean defaultValue) {
        String value = this.xmlParser.getAttribute(processorElement, attributeName);
        if (VerifyUtil.isEmpty((String)value) || !value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("true")) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }
}

