/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.security.service.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.lego.comm.security.ICertificateServerCallback;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;

public class CertificateAlarmService
implements ICertificateServerCallback,
SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(CertificateAlarmService.class);

    public void success(String ipAddress, String port, String moUuid) {
        AlarmReporter.restoreAlarm(52625446L, moUuid + ":" + port);
        AlarmReporter.restoreAlarm(52625444L, moUuid + ":" + port);
        AlarmReporter.restoreAlarm(52625445L, moUuid + ":" + port);
    }

    public void failForCertInvalidity(String ipAddress, String port, String moUuid) {
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        ipInfo = ipInfo != null ? ipInfo : ipAddress;
        String[] alarmParams = new String[]{ipInfo, moUuid + ":" + port, new LegoMoGenerator().getInstallServerIp(), port};
        AlarmReporter.sendAlarmForNoRepeat(52625444L, moUuid + ":" + port, FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.MINOR, alarmParams);
    }

    public void failForCertNoTrust(String ipAddress, String port, String moUuid) {
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        ipInfo = ipInfo != null ? ipInfo : ipAddress;
        String[] alarmParams = new String[]{ipInfo, moUuid + ":" + port, port};
        AlarmReporter.sendAlarmForNoRepeat(52625445L, moUuid + ":" + port, FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.MINOR, alarmParams);
    }

    public void failForRevokedCert(String ipAddress, String port, String moUuid, Set<String> set) {
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        ipInfo = ipInfo != null ? ipInfo : ipAddress;
        String[] alarmParams = new String[]{ipInfo, moUuid + ":" + port, port};
        AlarmReporter.sendAlarmForNoRepeat(52625446L, moUuid + ":" + port, FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.MINOR, alarmParams);
    }

    public void restoreForRevokedCert(String ipAddress, String port) {
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED && !LegoConfig.getInstance().isCertAlarmSwitch()) {
            this.clearCertAlarm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCertAlarm() {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            transaction = session.beginTransaction();
            long clearTime = System.currentTimeMillis();
            List<String> entityList = this.queryAlarm(session);
            if (!VerifyUtil.isEmpty(entityList)) {
                Session finalSession = session;
                List<String> annotationList = entityList.stream().map(entity -> this.queryAnnotationMaxIdForEntity(finalSession, (String)entity)).filter(Objects::nonNull).collect(Collectors.toList());
                this.updateAlarm(session, clearTime, entityList);
                this.updateAnnotation(session, clearTime, annotationList);
            }
            transaction.commit();
        }
        catch (Exception ex) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
                logger.error((Object)"Start system,clear Cert Alarm fail. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    private List<String> queryAlarm(Session session) {
        List<String> alarmEntity = this.getAlarmEntities();
        String sql = "select ENTITY from T_ALARM where CLEAR_STATUS='0' and ENTITY in (:entities);";
        NativeQuery query = session.createSQLQuery(sql);
        query.setParameterList("entities", alarmEntity);
        return query.list();
    }

    protected List<String> getAlarmEntities() {
        return Arrays.asList("0x3230024", "0x3230025", "0x3230026");
    }

    private String queryAnnotationMaxIdForEntity(Session session, String entity) {
        if (entity == null) {
            throw new LegoCheckedException("entity is null.");
        }
        String sql = "select max(ann.id) from Annotation ann where ann.entity = :entity";
        NativeQuery query = session.createSQLQuery(sql);
        query.setParameter("entity", (Object)entity);
        Object result = query.uniqueResult();
        if (result == null || result instanceof String) {
            return (String)result;
        }
        throw new IllegalStateException("Non-String value returned from SQL query.");
    }

    private void updateAlarm(Session session, long clearTime, List<String> entityList) {
        String updateSql = "update T_alarm set CLEAR_STATUS='1',CLEAR_USER='system',CLEAR_TIME=:clearTime where ENTITY in (:entityList);";
        NativeQuery query = session.createSQLQuery(updateSql);
        query.setParameter("clearTime", (Object)clearTime);
        query.setParameterList("entityList", entityList);
        query.executeUpdate();
    }

    private void updateAnnotation(Session session, long clearTime, List<String> annotationList) {
        String updateSql = "update T_ANNOTATION set CLEAR_STATUS='1',CLEAR_USER='system',CLEAR_TIME=:clearTime where id in (:annotationList);";
        NativeQuery query = session.createSQLQuery(updateSql);
        query.setParameter("clearTime", (Object)clearTime);
        query.setParameterList("annotationList", annotationList);
        query.executeUpdate();
    }
}

