/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.resource.service;

import com.huawei.ism.array.sdk.model.HvsStorage;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.sdk.model.RemoteLinkDevice;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindow;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.service.ILocalResourceService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryResult;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.dao.DataAccessException;

public class DiscoverResourceBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(DiscoverResourceBackTask.class);
    private static final int TIME_INTERVAL = 5;
    private static final int POLLING_TIMES = 480;
    private DiscoveryPolicy policy;

    public DiscoverResourceBackTask(DiscoveryPolicy policy) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)policy.getEndIP(), (String)"ism.drm.discovery", (String)"System", (String)"", null), true);
        this.policy = policy;
    }

    protected void doWork() {
        DiscoveryResult result;
        long errorCode;
        this.policy.getExtendAttributeMap().put("discoveryTask", this.getBackTask());
        IDiscoveryService discoveryService = (IDiscoveryService)ServiceLocator.getInstance().getService(IDiscoveryService.class);
        long policyId = discoveryService.icmpDiscovery(this.policy);
        int timeout = 0;
        long totalIpCount = this.policy.getTotalIpCount();
        String countSql = "select count(*) from DiscoveryResult where discoveryPolicy.discoveryPolicyId=" + policyId;
        long resultCount = 0L;
        while (resultCount < totalIpCount) {
            resultCount = this.getResultCount(discoveryService, policyId, countSql);
            if (timeout++ != 480) continue;
            StringBuilder sb = new StringBuilder("Discover resource error");
            sb.append(", totalIpCount=").append(totalIpCount);
            sb.append(", resultCount=").append(resultCount);
            sb.append(", discoveredNum=").append(this.policy.getDiscoveredDeviceCount());
            logger.error((Object)("Discover resource failed, timeout error, " + sb));
            throw new LegoCheckedException(1073947433L, sb.toString());
        }
        int discoveredNum = this.policy.getDiscoveredDeviceCount();
        if (discoveredNum <= 0 && (errorCode = (result = this.getDiscoveryResult(policyId)).getErrorCode().longValue()) != 0L) {
            String errorParam = result.getErrorParam();
            String[] errorParams = null;
            if (!VerifyUtil.isEmpty((String)errorParam)) {
                errorParams = errorParam.split(",");
            }
            logger.error((Object)("policy=" + policyId + ", result=" + result.getDiscoveryResultId() + ", errorCode=" + errorCode));
            throw new LegoCheckedException(errorCode, errorParams);
        }
        if (this.policy.getIsAirGapResource().booleanValue()) {
            this.handleAirGapResourceDiscovery(this.policy.getStartIP());
        }
    }

    private long getResultCount(IDiscoveryService discoveryService, long policyId, String countSql) {
        long resultCount;
        try {
            resultCount = CommonDAOLocator.getBaseDao().getTotalCount(countSql);
            TimeUnit.SECONDS.sleep(5L);
            this.policy = discoveryService.getDiscoveryPolicy(Long.valueOf(policyId));
        }
        catch (InterruptedException ex) {
            logger.error((Object)"Current thread has been interrupted by BackTaskHandler!", (Throwable)ex);
            throw new LegoCheckedException(1073947433L, (Throwable)ex);
        }
        return resultCount;
    }

    private DiscoveryResult getDiscoveryResult(long policyId) {
        String queryResultSql = "from DiscoveryResult discoveryResult where discoveryResult.discoveryPolicy.discoveryPolicyId = ? order by discoveryResult.discoveryResultId asc";
        List disResult = CommonDAOLocator.getMoDao().find(queryResultSql, new Object[]{policyId});
        if (VerifyUtil.isEmpty((Collection)disResult)) {
            logger.error((Object)"DiscoveryResult is empty.");
            throw new LegoCheckedException(1053L, "Discover resource error!");
        }
        return (DiscoveryResult)disResult.get(0);
    }

    private void handleAirGapResourceDiscovery(String ipAddress) {
        ILocalResourceService resourceService = ServiceProvider.getResourceService();
        if (resourceService == null) {
            logger.info((Object)"Get IResourceService null.");
            return;
        }
        ManagedObject managedObject = resourceService.getMoByIp(ipAddress);
        if (!(managedObject instanceof HvsStorage)) {
            logger.info((Object)"Not discover storage, return.");
            return;
        }
        HvsStorage storage = (HvsStorage)managedObject;
        String devSn = storage.getSn();
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"Not find devSn.");
            throw new LegoCheckedException(1073947394L);
        }
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
        List remoteDevices = mgr.getStorageRemoteDevice(devSn);
        if (CollectionUtils.isEmpty((Collection)remoteDevices)) {
            logger.error((Object)"Not remote device info, no need to disable. devSn: %s", new Object[]{devSn});
            return;
        }
        this.addTimeWindowByDeviceId(devSn, mgr, remoteDevices);
        this.disableAndSaveLinkPorts(devSn, mgr, remoteDevices);
    }

    private void addTimeWindowByDeviceId(String devSn, IStoragePortLinksManager mgr, List<RemoteLinkDevice> remoteDevices) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        for (RemoteLinkDevice remoteDevice : remoteDevices) {
            logger.info((Object)"Begin to add time window. devSn: %s, deviceId: %s", new Object[]{devSn, remoteDevice.getDeviceId()});
            ResourceTimeWindow timeWindow = ResourceTimeWindow.instance((String)devSn, (RemoteLinkDevice)remoteDevice);
            resourceService.addResourceTimeWindow(timeWindow);
            logger.info((Object)"Add timeWindow: %s success.", new Object[]{timeWindow.toString()});
        }
        for (RemoteLinkDevice remoteDevice : remoteDevices) {
            this.doIsolateAlarm(devSn, mgr, remoteDevice);
        }
    }

    private void disableAndSaveLinkPorts(String devSn, IStoragePortLinksManager mgr, List<RemoteLinkDevice> remoteDevices) {
        ArrayList linkPorts = new ArrayList();
        for (RemoteLinkDevice remoteDevice : remoteDevices) {
            List tmpPorts = remoteDevice.getLinkPorts();
            linkPorts.addAll(tmpPorts);
        }
        HashSet<String> portIds = new HashSet<String>();
        for (StorageLinkPort port : linkPorts) {
            String portId = port.getPortId();
            if (portIds.contains(portId)) continue;
            portIds.add(portId);
            logger.info((Object)"Begin to disable portName: %s", new Object[]{port.getPortName()});
            if (port.getEnable().booleanValue() || port.getOperationalStatus().booleanValue()) {
                mgr.disableStoragePort(devSn, port);
                port.setEnable(Boolean.valueOf(false));
                port.setOperationalStatus(Boolean.valueOf(false));
            }
            port.setTime(System.currentTimeMillis());
            try {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)port);
            }
            catch (DataAccessException e) {
                logger.error((Object)"Error to save portInfo, portName: %s, msg: %s", new Object[]{port.getPortName(), e.getMessage()});
                throw new LegoCheckedException(-1L);
            }
            logger.info((Object)"Save port: %s success!", new Object[]{port.getPortName()});
        }
    }

    private void doIsolateAlarm(String devSn, IStoragePortLinksManager mgr, RemoteLinkDevice remoteDevice) {
        AirGapLinkPortUtil util = AirGapLinkPortUtil.getInstance();
        try {
            remoteDevice.setNetIsolation(1);
            logger.info((Object)"Begin to isolate alarm. remoteWWn: %s", new Object[]{remoteDevice.getRemoteWwn()});
            mgr.isolateAlarm(devSn, remoteDevice);
            util.updateIsolateAlarmFlag(devSn, remoteDevice.getRemoteWwn(), false);
        }
        catch (Exception e) {
            logger.error((Object)"remoteEsn: %s remote device abnormal, Need to isolate again. msg: %s", new Object[]{remoteDevice.getEsn(), e.getMessage()});
            util.updateIsolateAlarmFlag(devSn, remoteDevice.getRemoteWwn(), true);
        }
        String[] params = new String[]{remoteDevice.getEsn() + remoteDevice.getRemoteName()};
        AlarmReporter.restoreAlarm("0x3230068", params);
    }
}

