/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.dao.IFaultDao;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import java.util.HashMap;
import java.util.Locale;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class DeleteRemoteServerTransactionCallback
implements TransactionCallback {
    private static final Log logger = LogFactory.getInstance(DeleteRemoteServerTransactionCallback.class);
    private ManagementServer server;
    private IFaultDao faultDao;

    public DeleteRemoteServerTransactionCallback(ManagementServer serverInfo) {
        this.server = serverInfo;
        this.faultDao = CommonDAOLocator.getFaultDao();
    }

    public Object doInTransaction(TransactionStatus status) {
        try {
            this.delAlarm(this.server);
            CommonDAOLocator.getMoDao().deleteMo(this.server.getMoId());
            ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
            licenseControl.checkLicenseOutOfControlAlarm(true);
        }
        catch (Exception e) {
            status.setRollbackOnly();
            ExceptionUtil.rethrowException((Throwable)e, (String)"Delete remote server failed.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        return null;
    }

    private void delAlarm(ManagementServer serverInfo) {
        String offAlarmId = "0x" + Long.toHexString(52625435L).toUpperCase(Locale.US);
        String verAlarmId = "0x" + Long.toHexString(52625436L).toUpperCase(Locale.US);
        String entity = "1" + offAlarmId + serverInfo.getMoId();
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("entity", entity);
        this.faultDao.deleteFaultsByCondition(Alarm.class, condition);
        this.faultDao.deleteHistoryOfflineByCondition(condition);
        entity = "1" + verAlarmId + serverInfo.getMoId();
        condition.put("entity", entity);
        this.faultDao.deleteFaultsByCondition(Alarm.class, condition);
        this.faultDao.deleteHistoryOfflineByCondition(condition);
        logger.info((Object)("clear server cert alarm,serverInfo.getMoId()=" + serverInfo.getMoId()));
        AlarmUtil.restoreAlarm((String)"0x3230024", (String[])new String[]{String.valueOf(serverInfo.getMoId())});
        AlarmUtil.restoreAlarm((String)"0x3230025", (String[])new String[]{String.valueOf(serverInfo.getMoId())});
    }
}

