/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.ResourceUtil;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;

@Service(Name="com.huawei.ism.drm.site.sdk.service.IManagementServerService", Desc="", Interface=IManagementServerService.class)
public class ManagementServerServiceImpl
extends IsmBaseService
implements IManagementServerService {
    private static final Log LOG = LogFactory.getInstance(ManagementServerServiceImpl.class);

    public void updateServer(ManagementServer server) {
        if (server == null) {
            LOG.error((Object)"Parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer replica = this.getServer(server.getUuid());
        if (replica == null) {
            LOG.error((Object)"Server does not exist: %s", new Object[]{server.getUuid()});
            throw new LegoCheckedException(2117645L);
        }
        this.updateBasicInfo(replica, server.getName());
        try {
            CommonDAOLocator.getMoDao().getHibernateTemplate().update((Object)replica);
        }
        catch (DataAccessException e) {
            throw new LegoCheckedException("Update server info failed.", (Throwable)e);
        }
    }

    private void updateBasicInfo(ManagementServer replica, String newName) {
        if (VerifyUtil.isEmpty((String)newName) || newName.equals(replica.getName())) {
            LOG.info((Object)"BaseInfo not changed.");
            return;
        }
        this.validateName(newName);
        replica.setName(newName);
    }

    private void validateName(String name) {
        if (VerifyUtil.isEmpty((String)name)) {
            LOG.error((Object)"Server name is empty: %s", new Object[]{name});
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmNameParam((String)name)) {
            LOG.error((Object)"Server name is illegal: %s", new Object[]{name});
            throw new LegoCheckedException(1073947393L);
        }
        List find = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ManagementServer where devAlias=?", new Object[]{name});
        if (!VerifyUtil.isEmpty((Collection)find)) {
            LOG.error((Object)"Duplicate server name found\uff1a%s", new Object[]{name});
            throw new LegoCheckedException(1073947392L);
        }
    }

    public ManagementServer getServerInfo() {
        ManagementServer server = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "serverType", (Object)0);
        if (null != server) {
            server.setUser(null);
            server.setPwd(null);
            String version = ResourceUtil.getValue("sysversion");
            server.setVersion(version);
        }
        return server;
    }

    public List<ManagementServer> getServers() {
        ArrayList<ManagementServer> servers = new ArrayList<ManagementServer>();
        servers.add(this.getServerInfo());
        return servers;
    }

    public ManagementServer getServer(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            LOG.error((Object)"Uuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        return (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "uuid", (Object)uuid);
    }
}

