/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteResourceService;
import com.huawei.ism.drm.site.util.SiteResourceServiceProxy;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

class RefreshOurSiteCallbackImpl
implements TransactionCallback {
    private static Log logger = LogFactory.getInstance(RefreshOurSiteCallbackImpl.class);
    private Site remoteSite = null;

    public RefreshOurSiteCallbackImpl(Site site) {
        this.remoteSite = site;
    }

    public Object doInTransaction(TransactionStatus tstatus) {
        try {
            this.refreshResourceOfSite(this.remoteSite);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("unable to refresh remote site:" + this.remoteSite.getName()), (Throwable)ex, 90160758787071L);
            tstatus.setRollbackOnly();
            throw ex;
        }
        catch (Exception ex) {
            tstatus.setRollbackOnly();
            ExceptionUtil.rethrowException((Throwable)ex, (String)("unable to refresh remote site:" + this.remoteSite.getName()), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return null;
    }

    private void refreshResourceOfSite(Site site) {
        Collection<ISiteResourceService> resourceServices = SiteResourceServiceProxy.getInstance().getAllSiteResourceService();
        for (ISiteResourceService resourceService : resourceServices) {
            resourceService.refreshResouce(site);
        }
    }
}

