/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.storage.manager.StorageManagerUtil;
import com.huawei.ism.drm.storage.replication.service.impl.AbstractReplicationService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

abstract class BaseStorageManagerProxy
extends AbstractReplicationService {
    BaseStorageManagerProxy() {
    }

    protected String getDeviceType(String srcDeviceId, String tgtDeviceId) {
        String deviceType = this.getStorageType(srcDeviceId);
        if (null == deviceType) {
            deviceType = this.getStorageType(tgtDeviceId);
        }
        return deviceType;
    }

    protected String getStorageType(String deviceId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceId);
        List storageUnits = CommonDAOLocator.getMoDao().findMoBy(StorageUnit.class, props);
        if (null == storageUnits || storageUnits.isEmpty()) {
            logger.error((Object)("storage unit not exsit, sn=" + deviceId));
            throw new LegoCheckedException(2117645L);
        }
        return ((StorageUnit)storageUnits.iterator().next()).getClass().getName();
    }

    protected String getStorageTypeWithVersion(String deviceId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceId);
        List storageUnits = CommonDAOLocator.getMoDao().findMoBy(StorageUnit.class, props);
        if (VerifyUtil.isEmpty((Collection)storageUnits)) {
            logger.error((Object)"Storage unit not exist, sn= %s", new Object[]{deviceId});
            throw new LegoCheckedException(2117645L);
        }
        String storageType = ((StorageUnit)storageUnits.iterator().next()).getClass().getName();
        String version = this.getVersionInfo((StorageUnit)CommonUtil.getFirstElement((Collection)storageUnits));
        return storageType + version;
    }

    protected String getVersionInfo(StorageUnit storageUnit) {
        String productVersion = storageUnit.getProductVersion();
        String version = this.extractVersion(productVersion);
        List<String> supportedVersions = this.getSupportedVersions(storageUnit.getClass().getName());
        if (supportedVersions.size() == 1 || version.isEmpty()) {
            return supportedVersions.get(0);
        }
        for (int i = supportedVersions.size() - 1; i >= 1; --i) {
            String supportedVersion = supportedVersions.get(i);
            int result = StorageManagerUtil.versionCompare(version, supportedVersion);
            if (result < 0) continue;
            return supportedVersion;
        }
        return supportedVersions.get(0);
    }

    protected String extractVersion(String versionInfo) {
        String[] strings = versionInfo.trim().split(" ", -1);
        String version = strings[0];
        if (VerifyUtil.isEmpty((String)version)) {
            return "";
        }
        if (version.charAt(0) == 'v' || version.charAt(0) == 'V') {
            return version.length() == 1 ? "" : version;
        }
        return "";
    }

    protected List<String> getSupportedVersions(String storageType) {
        return Collections.singletonList("");
    }
}

