/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.manager.proxy.BaseStorageManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageAppManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageAppManagerProxy
extends BaseStorageManagerProxy {
    private static final Log logger = LogFactory.getInstance(StorageAppManagerProxy.class);
    private static StorageAppManagerProxy storageAppManager = new StorageAppManagerProxy();
    private Map<String, IStorageAppManager> storageAppManagers = new HashMap<String, IStorageAppManager>();

    public static StorageAppManagerProxy getInstance() {
        return storageAppManager;
    }

    public void onBind(IStorageAppManager handler, Map<String, Object> properties) {
        this.storageAppManagers.put(handler.getStorageType(), handler);
    }

    public void onUnbind(IStorageAppManager handler, Map<String, Object> properties) {
        this.storageAppManagers.remove(handler.getStorageType());
    }

    public Map<Integer, List> getSupportedApp(String deviceId) {
        String typeName;
        if (VerifyUtil.isEmpty((String)deviceId)) {
            return null;
        }
        try {
            typeName = super.getStorageType(deviceId);
        }
        catch (LegoCheckedException ex) {
            String msg = MessageFormatUtil.format((String)"Get storage type catch exception, deviceId:[{0}], error code:[{1}]", (Object[])new Object[]{deviceId, ex.getErrorCode()});
            logger.warn((Object)msg);
            if (ex.getErrorCode() == 2117645L) {
                return null;
            }
            throw ex;
        }
        if (VerifyUtil.isEmpty((String)typeName) || !this.storageAppManagers.containsKey(typeName)) {
            return null;
        }
        return this.storageAppManagers.get(typeName).getSupportedApp(deviceId);
    }
}

