/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.manager.proxy.BaseStorageManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReplicationManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class StorageReplicationManagerProxy
extends BaseStorageManagerProxy
implements IStorageReplicationManager {
    private static final Log logger = LogFactory.getInstance(StorageReplicationManagerProxy.class);
    private static StorageReplicationManagerProxy instance = new StorageReplicationManagerProxy();
    private Map<String, IStorageReplicationManager> mgrs = new ConcurrentHashMap<String, IStorageReplicationManager>();

    private StorageReplicationManagerProxy() {
    }

    public static StorageReplicationManagerProxy getInstance() {
        return instance;
    }

    public IStorageReplicationManager getStorageReplicationAdapter(String devSn) {
        String storageType = this.getStorageType(devSn);
        IStorageReplicationManager iStorageReplicationManager = this.mgrs.get(storageType);
        if (null == iStorageReplicationManager) {
            logger.error((Object)("IStorageReplicationManager is null, sn=" + devSn));
            throw new LegoCheckedException(1073947395L);
        }
        return iStorageReplicationManager;
    }

    public IStorageReplicationManager getStorageReplicationManager(String storageType) {
        IStorageReplicationManager iStorageReplicationManager = this.mgrs.get(storageType);
        if (null == iStorageReplicationManager) {
            logger.error((Object)("IStorageReplicationManager is null, sn=" + storageType));
            throw new LegoCheckedException(1073947395L);
        }
        return iStorageReplicationManager;
    }

    public void onBind(IStorageReplicationManager sra, Map<?, ?> properties) {
        if (sra.getStorageType() != null) {
            this.mgrs.put(sra.getStorageType(), sra);
        }
    }

    public void onUnbind(IStorageReplicationManager sra, Map<?, ?> properties) {
        this.mgrs.remove(sra.getStorageType());
    }

    public OperationResult syncOnce(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationManager sra = this.getReplicationManagerInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sra.syncOnce(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public OperationResult splitReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationManager sra = this.getReplicationManagerInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sra.splitReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public OperationResult switchReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationManager sra = this.getReplicationManagerInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sra.switchReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public OperationResult forceSwitchReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationManager sra = this.getStorageReplicationAdapter(targetArrayId);
        return sra.forceSwitchReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public List<ReplicationTargetLun> querySyncStatus(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationManager sra = this.getReplicationManagerInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sra.querySyncStatus(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public OperationResult setSecondaryLunReadWrite(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationManager sra = this.getReplicationManagerInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sra.setSecondaryLunReadWrite(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public OperationResult reverseReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        IStorageReplicationManager sra = this.getReplicationManagerInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return sra.reverseReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public OperationResult setLunWriteProtection(String commandDevSN, String replicationId, boolean isConsistentGroup, int secResAccess) {
        IStorageReplicationManager sra = this.getStorageReplicationAdapter(commandDevSN);
        return sra.setLunWriteProtection(commandDevSN, replicationId, isConsistentGroup, secResAccess);
    }

    public List<ReplicationPair> queryReplications(String deviceSn, String lunId, Integer resourceType) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(deviceSn);
        return manager.queryReplications(deviceSn, lunId, resourceType);
    }

    public String getStorageType() {
        return null;
    }

    public List<String> supportedDeviceList() {
        return null;
    }

    private IStorageReplicationManager getReplicationManagerInternal(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        ReplicationRelation relation = this.getReplicationInternal(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        return this.getStorageReplicationAdapter(relation.getDevSn());
    }

    private ReplicationRelation getReplicationInternal(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        ReplicationRelation relation = this.getReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        if (null == relation) {
            logger.error((Object)("Replication does not exist. SrcDevId:" + sourceArrayId + ",TgtDevId:" + targetArrayId + ",replicationId:" + replicationId + ",isConsistentGroup:" + isConsistentGroup), 90160758784001L);
            if (isConsistentGroup) {
                throw new LegoCheckedException(1073948767L, new String[]{replicationId});
            }
            throw new LegoCheckedException(1073948677L, new String[]{replicationId});
        }
        return relation;
    }

    public void changeRate(String sn, String id, boolean isCg, DmEnumDefine.SPEED_LEVEL_E rate) {
        this.getStorageReplicationAdapter(sn).changeRate(sn, id, isCg, rate);
    }

    public void modify(String sn, String id, boolean isCg, Map<String, Object> params) {
        IStorageReplicationManager adapter = this.getStorageReplicationAdapter(sn);
        adapter.modify(sn, id, isCg, params);
    }

    public void refresh(String sn, List<String> ids, boolean isCg) {
        IStorageReplicationManager adapter = this.getStorageReplicationAdapter(sn);
        adapter.refresh(sn, ids, isCg);
    }

    public List<ReplicationPair> queryReplications(String deviceSn, Collection<String> resources, Integer resourceType) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(deviceSn);
        return manager.queryReplications(deviceSn, resources, resourceType);
    }

    public ReplicationPair createReplicationPair(ReplicationPair pair) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(pair.getSrcDevSN());
        return manager.createReplicationPair(pair);
    }

    public ReplicationGroup addReplicationPair(ReplicationGroup group, List<ReplicationPair> pairList) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(group.getSrcDevSN());
        return manager.addReplicationPair(group, pairList);
    }

    public void deleteReplicationPair(ReplicationPair pair) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(pair.getSrcDevSN());
        manager.deleteReplicationPair(pair);
    }

    public ReplicationGroup createReplicationGroup(ReplicationGroup group) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(group.getSrcDevSN());
        return manager.createReplicationGroup(group);
    }

    public void deleteReplicationGroup(ReplicationGroup group) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(group.getSrcDevSN());
        manager.deleteReplicationGroup(group);
    }

    public void removeReplicationPair(ReplicationGroup group, List<ReplicationPair> pairList) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(group.getSrcDevSN());
        manager.removeReplicationPair(group, pairList);
    }

    public ReplicationGroup getReplicationGroup(String devSN, String groupId) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(devSN);
        return manager.getReplicationGroup(devSN, groupId);
    }

    public List<ReplicationPair> getReplicationPair(String devSN, Map<String, String> filter) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(devSN);
        return manager.getReplicationPair(devSN, filter);
    }

    public List<ReplicationPair> getAllReplicationPairs(String deviceSN, String vstoreId) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(deviceSN);
        return manager.getAllReplicationPairs(deviceSN, vstoreId);
    }

    public List<ReplicationGroup> getAllReplicationGroups(String deviceSN) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(deviceSN);
        return manager.getAllReplicationGroups(deviceSN);
    }

    public ReplicationPair getReplicationPair(String devSN, String pairId) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(devSN);
        return manager.getReplicationPair(devSN, pairId);
    }

    public List<ReplicationPair> queryReplicationPairByCgId(String devSN, String cgId) {
        IStorageReplicationManager manager = this.getStorageReplicationAdapter(devSN);
        return manager.queryReplicationPairByCgId(devSN, cgId);
    }
}

