/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.service.impl;

import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.service.IsmDrmBaseService;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateCallback;

public class AbstractReplicationService
extends IsmDrmBaseService {
    protected static final Log logger = LogFactory.getInstance(AbstractReplicationService.class);
    protected static final boolean IS_MAIN_OPERATION = true;
    protected static final int SLEEP_TIME = 1500;

    public List<ReplicationPair> queryReplicationPairByGroupId(String deviceSn, String replicationGroupId, boolean queryTgtLun) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceSn);
        props.put("consistentGroupId", replicationGroupId);
        ArrayList<ReplicationPair> pairs = CommonDAOLocator.getMoDao().findMoBy(ReplicationPair.class, props);
        if (VerifyUtil.isEmpty((Collection)pairs)) {
            pairs = new ArrayList<ReplicationPair>();
            return pairs;
        }
        if (queryTgtLun) {
            for (ReplicationPair pair : pairs) {
                List<ReplicationTargetLun> tgtLuns = this.queryReplicationTargetLunById(pair.getMoId());
                pair.setRepTgtLuns(tgtLuns);
            }
        }
        return pairs;
    }

    protected ReplicationRelation queryReplication(String deviceSN, String replicationId, boolean isGroup) {
        if (null == deviceSN || null == replicationId) {
            logger.error((Object)("Parameter is invalid. DeviceId:" + deviceSN + ",RepId:" + replicationId + ",IsCG:" + isGroup), 90160758784001L);
            return null;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", deviceSN);
        props.put("replicationId", replicationId);
        int repType = isGroup ? 1 : 0;
        props.put("relationType", repType);
        List<ReplicationRelation> groups = CommonDAOLocator.getMoDao().findMoBy(ReplicationRelation.class, props);
        if (null == groups || groups.isEmpty()) {
            replicationId = this.reConstructReplicationId(replicationId);
            props.put("replicationId", replicationId);
            groups = CommonDAOLocator.getMoDao().findMoBy(ReplicationRelation.class, props);
            if (null == groups || groups.isEmpty()) {
                groups = this.queryReplicationById(deviceSN, replicationId, isGroup);
            }
        }
        if (null != groups && groups.size() == 1) {
            return (ReplicationRelation)groups.get(0);
        }
        logger.error((Object)("The replication does not exist. DeviceId:" + deviceSN + ",RepId:" + replicationId + ",IsCG:" + isGroup), 90160758784001L);
        return null;
    }

    public ReplicationRelation getReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        String resArrayId = RecoveryTaskUtil.getAirGapQueryArrayId(sourceArrayId, targetArrayId);
        if (!VerifyUtil.isEmpty((String)resArrayId)) {
            ReplicationRelation replication = this.queryReplication(resArrayId, replicationId, isConsistentGroup);
            if (replication != null) {
                replication.setDevSn(resArrayId);
            }
            return replication;
        }
        ReplicationRelation replication = this.queryReplication(sourceArrayId, replicationId, isConsistentGroup);
        String deviceId = sourceArrayId;
        if (null == replication || !replication.getIsPrimary().booleanValue()) {
            replication = this.queryReplication(targetArrayId, replicationId, isConsistentGroup);
            deviceId = targetArrayId;
        }
        if (null != replication) {
            replication.setDevSn(deviceId);
        }
        return replication;
    }

    protected ReplicationTargetLun getTargetLun(String targetArrayId, String replicationId, String deviceId) {
        ReplicationTargetLun targetLun = null;
        List<ReplicationTargetLun> tgtLunList = this.queryReplicationTargetLunById(replicationId, deviceId, false);
        if (VerifyUtil.isEmpty(tgtLunList)) {
            return null;
        }
        for (ReplicationTargetLun tgtLun : tgtLunList) {
            if (!targetArrayId.equalsIgnoreCase(tgtLun.getTgtDevSN())) continue;
            targetLun = tgtLun;
            break;
        }
        return targetLun;
    }

    protected StorageNE getArray(String deviceId) {
        StorageNE array = null;
        try {
            array = this.getUniqueMO(StorageNE.class, "sn", deviceId);
        }
        catch (Exception e) {
            logger.error((Object)("Exception : " + deviceId), 90160758784257L);
        }
        return array;
    }

    protected List<ReplicationTargetLun> queryReplicationTargetLunById(long replicationPairMoId) {
        Class<ReplicationTargetLun> clazz = ReplicationTargetLun.class;
        HashMap props = new HashMap();
        long moId = replicationPairMoId;
        List targetLuns = CommonDAOLocator.getMoDao().findSubMoBy(moId, clazz, props);
        return targetLuns;
    }

    protected List<ReplicationTargetLun> queryReplicationTargetLunById(String replicationId, String deviceSN) {
        Class<ReplicationTargetLun> clazz = ReplicationTargetLun.class;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceSN);
        props.put("replicationPairId", replicationId);
        List<ReplicationTargetLun> targetLuns = CommonDAOLocator.getMoDao().findMoBy(clazz, props);
        if ((null == targetLuns || targetLuns.isEmpty()) && null != replicationId) {
            replicationId = this.reConstructReplicationId(replicationId);
            props.put("replicationPairId", replicationId);
            targetLuns = CommonDAOLocator.getMoDao().findMoBy(clazz, props);
            if (null == targetLuns || targetLuns.isEmpty()) {
                targetLuns = this.queryTargetLuns(deviceSN, replicationId);
            }
        }
        return targetLuns;
    }

    protected List<ReplicationTargetLun> queryReplicationTargetLunById(String replicationId, String deviceSN, boolean queryTgtDev) {
        List<ReplicationTargetLun> tgtLuns = this.queryReplicationTargetLunById(replicationId, deviceSN);
        if (null == tgtLuns || tgtLuns.isEmpty()) {
            return new ArrayList<ReplicationTargetLun>();
        }
        if (queryTgtDev) {
            for (ReplicationTargetLun tgtLun : tgtLuns) {
                tgtLun.setTgtDevice(this.queryStorageDeviceBySn(tgtLun.getTgtDevSN()));
            }
        }
        return tgtLuns;
    }

    protected StorageNE queryStorageDeviceBySn(String deviceSN) {
        return this.getArray(deviceSN);
    }

    private <T> T getUniqueMO(Class<T> clazz, String name, Object value) {
        HibernateCallback callBack = session -> {
            Criteria criteria = session.createCriteria(clazz);
            criteria.add((Criterion)Restrictions.eq((String)name, (Object)value));
            return criteria.uniqueResult();
        };
        Object mo = CommonDAOLocator.getMoDao().getHibernateTemplate().execute(callBack);
        return (T)mo;
    }

    private String reConstructReplicationId(String replicationId) {
        if (16 > replicationId.length()) {
            replicationId = "00" + replicationId;
        } else {
            String prefix = replicationId.substring(0, 2);
            if (prefix.equals("00")) {
                replicationId = replicationId.substring(2, replicationId.length());
            }
        }
        return replicationId;
    }

    private List<ReplicationTargetLun> queryTargetLuns(String deviceSn, String replicationId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceSn);
        props.put("replicationPairId", replicationId.toUpperCase(Locale.getDefault()));
        List targetLuns = CommonDAOLocator.getMoDao().findMoBy(ReplicationTargetLun.class, props);
        if (null == targetLuns || targetLuns.isEmpty()) {
            props.put("replicationPairId", replicationId.toLowerCase(Locale.getDefault()));
            targetLuns = CommonDAOLocator.getMoDao().findMoBy(ReplicationTargetLun.class, props);
        }
        return targetLuns;
    }

    private List<ReplicationRelation> queryReplicationById(String deviceSn, String replicationId, boolean isGroup) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", deviceSn);
        int repType = isGroup ? 1 : 0;
        props.put("relationType", repType);
        props.put("replicationId", replicationId.toUpperCase(Locale.getDefault()));
        List groups = CommonDAOLocator.getMoDao().findMoBy(ReplicationRelation.class, props);
        if (null == groups || groups.isEmpty()) {
            props.put("replicationId", replicationId.toLowerCase(Locale.getDefault()));
            groups = CommonDAOLocator.getMoDao().findMoBy(ReplicationRelation.class, props);
        }
        return groups;
    }
}

