/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.service.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.QuorumServer;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.array.sdk.model.RemoteDevice;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.base.service.IsmDrmBaseService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageVstoreHyperMetroPairManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageVstoreHyperMetroPairManager;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.util.CollectionUtils;

@Service(Name="com.huawei.ism.drm.storage.sdk.service.IStorageResourceService", Desc="", Interface=IStorageResourceService.class)
public class StorageResourceServiceImpl
extends IsmDrmBaseService
implements IStorageResourceService {
    private Log logger = LogFactory.getInstance(((Object)((Object)this)).getClass());
    private LoadingCache<String, Map<String, String>> wwnMapCache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Map<String, String>>(){

        public Map<String, String> load(String key) throws Exception {
            return StorageResourceServiceImpl.this.getTakeOverWwnMap();
        }
    });

    public <T extends StorageResource> List<T> getStorageResources(String devSn, List<String> resourceIds, Class<T> clazz) {
        this.logger.debug((Object)("sn=" + devSn + ", resourceIds=" + resourceIds + ",clazz=" + clazz));
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", devSn);
        props.put("resourceId", resourceIds.toArray());
        List list = this.getMoDao().findMoBy(clazz, props);
        return list;
    }

    public <T extends StorageResource> T getStorageResource(String devSn, String resourceId, Class<T> clazz) {
        this.logger.debug((Object)("sn=" + devSn + ", resourceId=" + resourceId + ",clazz=" + clazz));
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)resourceId)) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", devSn);
        props.put("resourceId", resourceId);
        List list = this.getMoDao().findMoBy(clazz, props);
        if (!VerifyUtil.isEmpty((Collection)list)) {
            return (T)((StorageResource)list.get(0));
        }
        return null;
    }

    public List<Initiator> getArrayInitiators(String deviceSn, Site site) {
        this.logger.debug((Object)("sn=" + deviceSn + ", site=" + site));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceSn);
        List list = this.getMoDao().findMoBy(StorageUnit.class, props);
        if (VerifyUtil.isEmpty((Collection)list)) {
            return null;
        }
        HashMap<String, Long> iprops = new HashMap<String, Long>();
        iprops.put("parentMo.moId", ((StorageUnit)list.get(0)).getMoId());
        return this.getMoDao().findMoBy(Initiator.class, iprops);
    }

    public List<Lun> pageQueryReplicasLunsBySnAndLunIds(String devSn, List<String> lunIdList, int startPage, int pageSize) {
        ArrayList<String> curLunIdList = new ArrayList<String>();
        int curIdx = ++startPage > 1 ? (startPage - 1) * pageSize : 0;
        for (int i = 0; i < pageSize && i < lunIdList.size() - curIdx; ++i) {
            String lunId = lunIdList.get(curIdx + i);
            curLunIdList.add(lunId);
        }
        List listLuns = null;
        try {
            StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
            IStorageLunManager manager = proxy.getStorageLunMgrByDevId(devSn);
            listLuns = manager.queryLunsWithHostName(devSn, curLunIdList);
            Collections.sort(listLuns, Comparator.comparing(Lun::getLunId));
        }
        catch (Exception e) {
            this.logger.error((Object)"Query failed. The DR array is abnormal.");
        }
        return listLuns;
    }

    public List<Lun> queryRemoteLunsByResource(String devSn, List<Lun> lunList) {
        ArrayList<String> wwns = new ArrayList<String>();
        ArrayList<String> tmpLunIdList = new ArrayList<String>();
        for (Lun lun : lunList) {
            wwns.add(lun.getWwn());
            tmpLunIdList.add(lun.getLunId());
        }
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(wwns.toArray(new String[wwns.size()]));
        ArrayList<Lun> remoteLunList = new ArrayList();
        ArrayList<String> remoteLunIds = new ArrayList<String>();
        String resourceDevSn = null;
        for (StorageResource resource : resources) {
            String lunId = resource.getResourceId();
            if (tmpLunIdList.contains(lunId)) continue;
            remoteLunIds.add(resource.getResourceId());
            resourceDevSn = resource.getDevSn();
        }
        StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
        IStorageLunManager manager = proxy.getStorageLunMgrByDevId(devSn);
        try {
            remoteLunList = manager.queryLunsWithHostName(resourceDevSn, remoteLunIds);
            Collections.sort(remoteLunList, Comparator.comparing(Lun::getLunId));
        }
        catch (Exception e) {
            this.logger.error((Object)"get remoteLunList failed.");
        }
        return remoteLunList;
    }

    public boolean checkLunMapping(String devSn, List<String> lunIds) {
        List<Lun> lunList = this.getStorageResources(devSn, lunIds, Lun.class);
        for (Lun lun : lunList) {
            if (lun.getMapped().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public ArrayUnit getLunStorageModule(String devSn) {
        return ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageBySn(devSn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NasFileSystem> getFileSystemsByNFSShare(String lifIpAddr, String nfsSharePath, boolean isPrimary) {
        Session session;
        block10: {
            List<NasFileSystem> list;
            ArrayList<NasFileSystem> fileSystems;
            block9: {
                this.logger.debug((Object)("lifIpAddr=" + lifIpAddr + ", nfsSharePath=" + nfsSharePath));
                fileSystems = new ArrayList<NasFileSystem>();
                session = null;
                session = this.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
                StringBuilder strHQL = new StringBuilder();
                strHQL.append("select fs from NasFileSystem fs, LogicInterface lif ");
                strHQL.append("where (lif.ipv4Addr=:ipv4Addr or lif.ipv6Addr=:ipv6Addr) ");
                strHQL.append("and fs.devSn = lif.devSn and fs.name=:fsName");
                Query query = session.createQuery(strHQL.toString());
                query.setString("ipv4Addr", lifIpAddr);
                query.setString("ipv6Addr", lifIpAddr);
                if (nfsSharePath.endsWith("/")) {
                    query.setString("fsName", nfsSharePath.substring(1, nfsSharePath.length() - 1));
                } else {
                    query.setString("fsName", nfsSharePath.substring(1));
                }
                List results = query.list();
                if (!VerifyUtil.isEmpty((Collection)results)) {
                    for (Object obj : results) {
                        fileSystems.add((NasFileSystem)obj);
                    }
                }
                if (fileSystems.size() <= 1 || !isPrimary) break block9;
                list = Arrays.asList(this.getHyperNasFileSystemByNFSShare(fileSystems));
                DBOperationUtil.closeSession(session);
                return list;
            }
            try {
                if (VerifyUtil.isEmpty(fileSystems)) break block10;
                list = fileSystems;
            }
            catch (Exception e) {
                try {
                    this.logger.error((Object)("Getting fs by nfs share failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
            DBOperationUtil.closeSession(session);
            return list;
        }
        DBOperationUtil.closeSession(session);
        return null;
    }

    private NasFileSystem getHyperNasFileSystemByNFSShare(List<NasFileSystem> nasList) {
        ArrayList<String> fileIds = new ArrayList<String>();
        for (NasFileSystem fileSystem : nasList) {
            fileIds.add(fileSystem.getResourceId());
        }
        List<HyperMetroPair> pairlist = this.getHyperMetroPairByFileSystems(null, fileIds, Boolean.TRUE);
        if (!CollectionUtils.isEmpty(pairlist)) {
            for (HyperMetroPair hyperMetroPair : pairlist) {
                for (NasFileSystem fileSystem : nasList) {
                    if (!fileSystem.getResourceId().equals(hyperMetroPair.getLocalObjId()) || !fileSystem.getDevSn().equals(hyperMetroPair.getDevSn()) || VerifyUtil.isEmpty((String)hyperMetroPair.getVstorePairId())) continue;
                    return fileSystem;
                }
            }
        }
        return nasList.get(0);
    }

    public List<NasFileSystem> getFileSystemsByVstore(String devSN, String vstoreId) {
        this.logger.debug((Object)("getFileSystemsByVstore devSN=" + devSN + ", vstoreId=" + vstoreId));
        VerifyUtil.checkStrs((String[])new String[]{devSN, vstoreId});
        IStorageFileSystemManager mgr = StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(devSN);
        return mgr.queryFileSystems(devSN, vstoreId);
    }

    private void setStatus(JSONObject jsonObject, Initiator initiator) {
        if (jsonObject.containsKey((Object)"healthStatus")) {
            initiator.setHealthStatus(Integer.valueOf(jsonObject.getInt("healthStatus")));
        }
        if (jsonObject.containsKey((Object)"runningStatus")) {
            initiator.setRunningStatus(Integer.valueOf(jsonObject.getInt("runningStatus")));
        }
    }

    public HyperMetroPair getHyperMetroPair(String sn, String id, boolean isRealTime, String vstoreId) {
        this.logger.debug((Object)("Enter getHyperMetroPair, sn=" + sn + ", id=" + id + ", isRealTime=" + isRealTime));
        VerifyUtil.checkStrs((String[])new String[]{sn, id});
        HyperMetroPair pair = null;
        if (isRealTime) {
            IStorageHyperMetroManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(sn);
            pair = mgr.queryHyperMetroPair(sn, id, vstoreId);
        } else {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("devSn", sn);
            props.put("id", id);
            List pairs = this.getMoDao().findMoBy(HyperMetroPair.class, props);
            if (VerifyUtil.isEmpty((Collection)pairs)) {
                this.logger.info((Object)"pair not exist.");
            } else {
                pair = (HyperMetroPair)pairs.get(0);
            }
        }
        this.logger.debug((Object)("Exit getHyperMetroPair, pair=" + pair));
        return pair;
    }

    public List<HyperMetroPair> getHyperMetroPairByFileSystems(String devSN, List<String> fileSystemIds, Boolean isPrimary) {
        return this.getHyperMetroPairByFileSystems(devSN, fileSystemIds, isPrimary, false);
    }

    public List<HyperMetroPair> getHyperMetroPairByFileSystems(String devSN, List<String> fileSystemIds, Boolean isPrimary, Boolean isRealtime) {
        this.logger.debug((Object)("devSn=" + devSN + ", isPrimary=" + isPrimary));
        if (null == isRealtime || !isRealtime.booleanValue()) {
            return this.getHyperMetroPairByFileSystems(fileSystemIds, devSN, isPrimary);
        }
        List<HyperMetroPair> pairsInDb = this.getHyperMetroPairByFileSystems(fileSystemIds, devSN, null);
        return this.queryHyperMetroPairRealtime(pairsInDb, isPrimary);
    }

    public List<HyperMetroPair> getHyperMetroPairByWwn(List<String> wwns, Boolean isPrimary) {
        return this.getHyperMetroPairByWwn(wwns, isPrimary, "", false);
    }

    public List<HyperMetroPair> getHyperMetroPairByWwn(List<String> wwns, Boolean isPrimary, boolean isRealtime) {
        return this.getHyperMetroPairByWwn(wwns, isPrimary, "", isRealtime);
    }

    public List<HyperMetroPair> getHyperMetroPairByWwn(List<String> wwns, Boolean isPrimary, String devSn, boolean isRealtime) {
        ArrayList<String> wwnTemp = new ArrayList<String>(wwns);
        Map<String, String> wwnMap = this.getTakeOverWwnMapWithCache();
        ArrayList<String> addWwnList = new ArrayList<String>();
        ArrayList<String> removeWwnList = new ArrayList<String>();
        for (String wwn : wwnTemp) {
            String deviceWwn = wwnMap.get(wwn);
            if (VerifyUtil.isEmpty((String)deviceWwn)) continue;
            this.logger.debug((Object)("finde devicewwn:" + deviceWwn + " for takeOverWwn:" + wwn));
            addWwnList.add(deviceWwn);
            removeWwnList.add(wwn);
        }
        wwnTemp.addAll(addWwnList);
        wwnTemp.removeAll(removeWwnList);
        return this.getHyperMetroPairByWwnOld(wwnTemp, isPrimary, devSn, isRealtime);
    }

    public Map<String, String> getTakeOverWwnMapWithCache() {
        Map<String, String> wwnMap;
        try {
            wwnMap = (Map<String, String>)this.wwnMapCache.get((Object)"");
        }
        catch (Exception e) {
            this.logger.error((Object)"cache get error:", (Throwable)e);
            wwnMap = this.getTakeOverWwnMap();
        }
        return wwnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getTakeOverWwnMap() {
        HashMap<String, String> wwnMap = new HashMap<String, String>();
        Session session = null;
        try {
            HibernateTemplate template = this.getMoDao().getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            String querySQL = "select WWN,DEVICE_LUN_WWN from ti_lun where WWN is not null and DEVICE_LUN_WWN is not null";
            NativeQuery query = session.createSQLQuery(querySQL);
            List results = query.list();
            for (Object object : results) {
                Object[] values;
                if (!(object instanceof Object[]) || 2 != (values = (Object[])object).length) continue;
                String wwn = CommUtil.convertToString((Object)values[0]);
                String deviceWwn = CommUtil.convertToString((Object)values[1]);
                wwnMap.put(wwn, deviceWwn);
            }
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("Getting plan progress failed. Ids:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return wwnMap;
    }

    private List<HyperMetroPair> getHyperMetroPairByWwnOld(List<String> wwns, Boolean isPrimary, String devSn, boolean isRealtime) {
        this.logger.info((Object)("Query HyperMetroPair by wwn, wwns=" + StringUtil.arrayToString((Object[])wwns.toArray()) + ", isPrimary=" + isPrimary + ", isRealtime=" + isRealtime), 90160758784000L);
        if (VerifyUtil.isEmpty(wwns)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!isRealtime) {
            return this.getHyperMetroPairByWwn(wwns, isPrimary, devSn);
        }
        List<HyperMetroPair> pairsInDb = this.getHyperMetroPairByWwn(wwns, null, devSn);
        return this.queryHyperMetroPairRealtime(pairsInDb, isPrimary);
    }

    private List<HyperMetroPair> getHyperMetroPairByWwn(List<String> wwns, Boolean isPrimary, String devSn) {
        this.logger.debug((Object)("wwns=" + wwns + ", isPrimary=" + isPrimary));
        if (VerifyUtil.isEmpty(wwns)) {
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("resourceWwn", wwns.toArray(new String[wwns.size()]));
        if (null != isPrimary) {
            props.put("isPrimary", isPrimary);
        }
        if (!VerifyUtil.isEmpty((String)devSn)) {
            props.put("devSn", devSn);
        }
        List pairs = this.getMoDao().findMoBy(HyperMetroPair.class, props);
        return pairs;
    }

    private List<HyperMetroPair> getHyperMetroPairByFileSystems(List<String> fileSystemIds, String devSN, Boolean isPrimary) {
        if (VerifyUtil.isEmpty(fileSystemIds)) {
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("localObjId", fileSystemIds.toArray(new String[fileSystemIds.size()]));
        if (null != isPrimary) {
            props.put("isPrimary", isPrimary);
        }
        if (null != devSN) {
            props.put("devSn", devSN);
        }
        List<HyperMetroPair> pairs = this.getMoDao().findMoBy(HyperMetroPair.class, props);
        pairs = pairs.stream().filter(pair -> VerifyUtil.isEmpty((String)pair.getResourceWwn())).collect(Collectors.toList());
        return pairs;
    }

    private String getVstoreIdByHyperMetroPair(HyperMetroPair hyperMetroPair) {
        if (VerifyUtil.isEmpty((String)hyperMetroPair.getVstorePairId())) {
            return null;
        }
        String uuid = new XveUUID(hyperMetroPair.getDevSn(), XveMOType.VSTORE_HYPERMETRO_PAIR, hyperMetroPair.getVstorePairId()).toString();
        VstoreHyperMetroPair vstoreHyperMetroPair = (VstoreHyperMetroPair)this.getMoDao().getMoByUuid(uuid, Boolean.valueOf(true));
        if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
            return null;
        }
        return vstoreHyperMetroPair.getLocalVstoreId();
    }

    private List<HyperMetroPair> queryHyperMetroPairRealtime(List<HyperMetroPair> pairsInDb, Boolean isPrimary) {
        ArrayList<HyperMetroPair> pairs = new ArrayList<HyperMetroPair>();
        HashSet pairIdSet = new HashSet();
        ArrayList exceptionList = new ArrayList();
        ExecutionService.map(pairsInDb, oldPair -> {
            try {
                this.queryHyperMetroByOld(isPrimary, (List<HyperMetroPair>)pairs, pairIdSet, (HyperMetroPair)oldPair);
            }
            catch (Exception e) {
                exceptionList.add(e instanceof LegoCheckedException ? (LegoCheckedException)((Object)((Object)e)) : new LegoCheckedException(0x300001L, (Throwable)e));
            }
            return Collections.emptyList();
        });
        if (!exceptionList.isEmpty()) {
            throw (LegoCheckedException)((Object)exceptionList.get(0));
        }
        return pairs;
    }

    private void queryHyperMetroByOld(Boolean isPrimary, List<HyperMetroPair> pairs, Set<String> pairIdSet, HyperMetroPair mo) {
        String sn = mo.getDevSn();
        String id = mo.getId();
        String vstoreId = this.getVstoreIdByHyperMetroPair(mo);
        if (pairIdSet.contains(id)) {
            this.logger.info((Object)"The pair is in list: %s, sn=%s", new Object[]{id, sn});
            return;
        }
        StorageNE storage = (StorageNE)this.getMoDao().getMo(StorageNE.class, "sn", (Object)sn);
        if (VerifyUtil.isEmpty((Object)storage) || Integer.valueOf(-1).equals(storage.getStatus()) || Integer.valueOf(2).equals(storage.getStatus())) {
            this.logger.warn((Object)"The storage is no valid: %s, sn=%s", new Object[]{id, sn});
            return;
        }
        IStorageHyperMetroManager manager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(sn);
        HyperMetroPair pair = manager.queryHyperMetroPair(sn, id, vstoreId);
        this.logger.info((Object)"devSn=%s, id=%s, realSn= %s, realId=%s, realWwn=%s", new Object[]{sn, id, pair.getDevSn(), pair.getId(), pair.getResourceWwn()});
        this.synchronizeUpdatePairs(isPrimary, pairs, pairIdSet, pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeUpdatePairs(Boolean isPrimary, List<HyperMetroPair> pairs, Set<String> pairIdSet, HyperMetroPair pair) {
        List<HyperMetroPair> list = pairs;
        synchronized (list) {
            if (null == isPrimary) {
                pairs.add(pair);
            } else if (isPrimary.equals(pair.getIsPrimary())) {
                pairs.add(pair);
                pairIdSet.add(pair.getId());
            }
        }
    }

    public List<QuorumServer> getQuorumServers(String devSn) {
        this.logger.debug((Object)("sn=" + devSn));
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        List servers = this.getMoDao().getMoList(QuorumServer.class, "devSn", (Object)devSn);
        return servers;
    }

    public List<QuorumServerLink> getQuorumServerLink(String devSn, String quorumServerId) {
        this.logger.debug((Object)("sn=" + devSn + ", quorumServerId=" + quorumServerId));
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)quorumServerId)) {
            throw new LegoCheckedException(1073947393L);
        }
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (null == drResource) {
            throw new LegoCheckedException(2117645L);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", devSn);
        props.put("quorumServerId", quorumServerId);
        return this.getMoDao().findMoBy(QuorumServerLink.class, props);
    }

    public List<QuorumServerLink> getQuorumServerLink(String devSn, String quorumServerId, boolean isRealTime) {
        this.logger.debug((Object)("sn=" + devSn + ", quorumServerId=" + quorumServerId + ",isRealtime=" + isRealTime));
        List<QuorumServerLink> moList = this.getQuorumServerLink(devSn, quorumServerId);
        if (!isRealTime || VerifyUtil.isEmpty(moList)) {
            return moList;
        }
        IStorageHyperMetroManager manager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
        List links = manager.queryQuorumServerLinks(devSn, quorumServerId);
        return links;
    }

    public List<HyperMetroDomain> getHyperMetroDomains(String devSn) {
        this.logger.debug((Object)("sn=" + devSn));
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        List domains = CommonDAOLocator.getMoDao().getMoList(HyperMetroDomain.class, "devSn", (Object)devSn);
        return domains;
    }

    public HyperMetroDomain getHyperMetroDomainById(String id, boolean isRealTime) {
        this.logger.debug((Object)"id=%s", new Object[]{id});
        if (VerifyUtil.isEmpty((String)id)) {
            throw new LegoCheckedException(1073947393L);
        }
        HyperMetroDomain domain = (HyperMetroDomain)this.getMoDao().getMo(HyperMetroDomain.class, "id", (Object)id);
        if (domain == null) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)domain.getServiceStatus()) || isRealTime) {
            IStorageHyperMetroManager service = (IStorageHyperMetroManager)ServiceLocator.getInstance().getService(IStorageHyperMetroManager.class);
            domain = service.queryHyperMetroDomainById(domain.getDevSn(), id);
        }
        return domain;
    }

    public HyperMetroPair getHyperMetroPairById(String id) {
        this.logger.debug((Object)"id=%s", new Object[]{id});
        if (VerifyUtil.isEmpty((String)id)) {
            throw new LegoCheckedException(1073947393L);
        }
        HyperMetroPair hyperMetroPair = (HyperMetroPair)CommonDAOLocator.getMoDao().getMo(HyperMetroPair.class, "id", (Object)id);
        return hyperMetroPair;
    }

    public <T extends StorageResource> List<T> getStorageResourcesByUuid(List<String> resourceUuids, Class<T> clazz) {
        this.logger.debug((Object)("resourceUuids=" + resourceUuids + ", clazz=" + clazz));
        HashMap<String, Object[]> props = new HashMap<String, Object[]>();
        props.put("uuid", resourceUuids.toArray());
        List list = this.getMoDao().findMoBy(clazz, props);
        return list;
    }

    public List<HyperMetroConsistentGroup> getHyperMetroConsistentGroupByLunWwn(String devSn, String wwn, boolean isRealtime) {
        this.logger.debug((Object)("devSn=" + devSn + ", wwn=" + wwn + ", isRealtime=" + isRealtime));
        if (VerifyUtil.isEmpty((String)wwn)) {
            this.logger.error((Object)"wwn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (null != devSn) {
            props.put("devSn", devSn);
        }
        props.put("resourceWwn", new String[]{wwn});
        List pairs = this.getMoDao().findMoBy(HyperMetroPair.class, props);
        ArrayList<HyperMetroConsistentGroup> groups = new ArrayList<HyperMetroConsistentGroup>();
        for (HyperMetroPair pair : pairs) {
            if (!pair.getInCg().booleanValue()) {
                this.logger.info((Object)("Current pair is not in cg, sn=" + pair.getDevSn() + ", id=" + pair.getId() + ", www=" + wwn));
                continue;
            }
            IStorageHyperMetroManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(pair.getDevSn());
            HyperMetroConsistentGroup group = mgr.queryHyperMetroConsistentGroup(pair.getDevSn(), pair.getCgId());
            if (null == group) {
                this.logger.error((Object)("can not find cg, sn=" + pair.getDevSn() + ", id=" + pair.getCgId()));
                continue;
            }
            groups.add(group);
        }
        return groups;
    }

    public HyperMetroConsistentGroup getHyperMetroConsistentGroup(String devSn, String cgId, boolean isRealTime) {
        this.logger.debug((Object)("sn=" + devSn + ", cgId=" + cgId + ", isRealTime=" + isRealTime));
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId});
        HyperMetroConsistentGroup group = null;
        if (isRealTime) {
            IStorageHyperMetroManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
            group = mgr.queryHyperMetroConsistentGroup(devSn, cgId);
        } else {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("devSn", devSn);
            props.put("id", cgId);
            List list = this.getMoDao().findMoBy(HyperMetroConsistentGroup.class, props);
            if (!VerifyUtil.isEmpty((Collection)list)) {
                group = (HyperMetroConsistentGroup)list.get(0);
            }
        }
        this.logger.debug((Object)group);
        return group;
    }

    public List<HyperMetroPair> getHyperMetroPairByConsistentGroup(String devSn, String cgId, boolean isRealTime) {
        List pairs;
        this.logger.debug((Object)("sn=" + devSn + ", cgId=" + cgId + ", isRealTime=" + isRealTime));
        if (VerifyUtil.isEmpty((String)devSn)) {
            this.logger.error((Object)"sn is empty.");
            throw new LegoCheckedException(1073947393L, devSn);
        }
        if (VerifyUtil.isEmpty((String)cgId)) {
            this.logger.error((Object)"cgId is empty.");
            throw new LegoCheckedException(1073947393L, cgId);
        }
        if (isRealTime) {
            IStorageHyperMetroManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
            pairs = mgr.queryHyperMetroPairsByCg(devSn, cgId);
        } else {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("devSn", devSn);
            props.put("cgId", cgId);
            pairs = this.getMoDao().findMoBy(HyperMetroPair.class, props);
        }
        return pairs;
    }

    public List<StorageResource> queryRemoteResource(String devSn, String srcResourceId, String remoteDeviceSn, int arrayType, int resType, int rssType) {
        this.logger.debug((Object)("sn=" + devSn + ", srcResourceId=" + srcResourceId + ", remoteDeviceSn=" + remoteDeviceSn + "arrayType=" + arrayType + ", resType=" + resType + ",rssType=" + rssType));
        VerifyUtil.checkStrs((String[])new String[]{devSn, srcResourceId, remoteDeviceSn});
        IStorageHyperVaultManager mgr = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(devSn);
        if (null == mgr) {
            this.logger.error((Object)("mgr is not exsit, sn=" + devSn));
            throw new LegoCheckedException(102L);
        }
        NasFileSystem fs = this.getStorageResource(devSn, srcResourceId, NasFileSystem.class);
        if (null == fs) {
            this.logger.error((Object)("FileSystem not exist, sn=" + devSn + ", id=" + srcResourceId));
            throw new LegoCheckedException(2117645L);
        }
        long capacityInBytelongValue = fs.getCapacity();
        if (null == ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageBySn(remoteDeviceSn)) {
            this.logger.error((Object)("Storage not exist, remoteDeviceSn=" + remoteDeviceSn));
            throw new LegoCheckedException(2117645L);
        }
        RemoteDevice remoteDevice = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryRemoteDevice(devSn, remoteDeviceSn);
        if (null == remoteDevice) {
            this.logger.error((Object)("remoteDevice is null, devSn=" + devSn + ", remoteSn=" + remoteDeviceSn));
            throw new LegoCheckedException(1073947393L);
        }
        String remoteDeviceId = remoteDevice.getId();
        if (VerifyUtil.isEmpty((String)remoteDeviceId)) {
            this.logger.error((Object)("remoteDeviceId is empty, devSn=" + devSn + ", remoteSn=" + remoteDeviceSn));
            throw new LegoCheckedException(2117645L);
        }
        List remoteResources = mgr.queryRemoteResource(devSn, capacityInBytelongValue, remoteDeviceId, XveEnumDefinePParent.EPL_ARRAY_TYPE_E.valueOf((int)arrayType), XveMOType.getType((int)resType), XveEnumDefine.RSSLUN_TYPE_E.getType((int)rssType));
        return remoteResources;
    }

    public List<NasFileSystem> queryHyperVaultCandidateTargetFs(String devSn, String srcFsId, String remoteDeviceSn) {
        this.logger.debug((Object)("devSn=" + devSn + ",srcFsId=" + srcFsId + ", remoteDevicesn=" + remoteDeviceSn));
        VerifyUtil.checkStrs((String[])new String[]{devSn, srcFsId, remoteDeviceSn});
        List<StorageResource> remoteResources = this.queryRemoteResource(devSn, srcFsId, remoteDeviceSn, XveEnumDefinePParent.EPL_ARRAY_TYPE_E.EPL_ARRAY_PRIVATE.getValue(), XveMOType.FILESYSTEM.getValue(), XveEnumDefine.RSSLUN_TYPE_E.REPHV_SECONDARY_FS.getValue());
        return Arrays.asList(remoteResources.toArray(new NasFileSystem[remoteResources.size()]));
    }

    public void synchronize(String devSn, String id, boolean isCg, String vstoreId) {
        this.logger.debug((Object)("devSn=" + devSn + ",id=" + id + ", isCg=" + isCg));
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        IStorageHyperMetroManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
        mgr.synchronize(devSn, id, isCg, vstoreId);
    }

    public void disable(String devSn, String id, DrmEnumDefine.ROLE_TYPE role, boolean isCg, String vstoreId) {
        this.logger.debug((Object)("devSn=" + devSn + ",id=" + id + ", role=" + role + ", isCg=" + isCg));
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        IStorageHyperMetroManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
        mgr.disable(devSn, id, role, isCg, vstoreId);
    }

    public VstoreHyperMetroPair getVstoreHyperMetroPairById(String devSN, String id, Boolean isAssociate) {
        this.logger.debug((Object)("devSn=" + devSN + ",id=" + id + " ,isAssociate=" + isAssociate));
        VerifyUtil.checkStrs((String[])new String[]{devSN, id});
        VstoreHyperMetroPair vstoreHyperMetroPair = null;
        IStorageVstoreHyperMetroPairManager mgr = StorageVstoreHyperMetroPairManagerProxy.getInstance().getMgrByDevId(devSN);
        vstoreHyperMetroPair = mgr.queryVstoreHyperMetroPair(devSN, id, isAssociate.booleanValue());
        return vstoreHyperMetroPair;
    }

    public List<HyperMetroPair> getHyperMetroPairByVstore(String devSn, String vstoreId) {
        this.logger.debug((Object)("sn=" + devSn + ", vstoreId=" + vstoreId));
        VerifyUtil.checkStrs((String[])new String[]{devSn, vstoreId});
        IStorageHyperMetroManager mgr = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(devSn);
        List pairs = mgr.queryHyperMetroPairs(devSn, vstoreId);
        return pairs;
    }

    public void swapVstoreHyperMetroPair(String devSN, String vstorePairId) {
        this.logger.debug((Object)("devSn=" + devSN + ",vstorePairId=" + vstorePairId));
        VerifyUtil.checkStrs((String[])new String[]{devSN, vstorePairId});
        IStorageVstoreHyperMetroPairManager mgr = StorageVstoreHyperMetroPairManagerProxy.getInstance().getMgrByDevId(devSN);
        mgr.swap(devSN, vstorePairId, Boolean.FALSE.booleanValue());
    }

    public List<VstoreHyperMetroPair> getRemoteVstoreHyperMetroPair(String vstorePairId, String localVstoreId, String remoteVstoreId) {
        VerifyUtil.checkStrs((String[])new String[]{vstorePairId});
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("vstorePairId", vstorePairId);
        if (!VerifyUtil.isEmpty((String)remoteVstoreId)) {
            condition.put("localVstoreId", remoteVstoreId);
        }
        if (!VerifyUtil.isEmpty((String)localVstoreId)) {
            condition.put("remoteVstoreId", localVstoreId);
        }
        return CommonDAOLocator.getMoDao().findMoBy(VstoreHyperMetroPair.class, condition);
    }

    public List<VstoreHyperMetroPair> getVstoreHyperPair(String serverUuid, String vstorePairId, String localVstoreId, String remoteVstoreId) {
        this.logger.debug((Object)"Enter getVstoreHyperPair, serverUuid=%s", new Object[]{serverUuid});
        VerifyUtil.checkStrs((String[])new String[]{vstorePairId});
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("vstorePairId", vstorePairId);
        if (!VerifyUtil.isEmpty((String)remoteVstoreId)) {
            condition.put("localVstoreId", remoteVstoreId);
        }
        if (!VerifyUtil.isEmpty((String)localVstoreId)) {
            condition.put("remoteVstoreId", localVstoreId);
        }
        List list = CommonDAOLocator.getMoDao().findMoBy(VstoreHyperMetroPair.class, condition);
        this.logger.debug((Object)"Exit getVstoreHyperPair");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStorageUsedByPoStorageInfo(String storageSn) {
        Session session;
        block6: {
            int num;
            NativeQuery sqlQuery;
            String sql;
            block7: {
                Object result;
                block5: {
                    boolean bl;
                    this.logger.debug((Object)("storageSn=" + storageSn));
                    sql = "select count(*) from ti_hoststorageresource h where lower(h.LUNWWN) in (select lower(wwn) from ti_lun l left join ti_storageresource s on l.moid = s.moid where s.devsn = :devsn UNION select lower(wwn) from ti_volume v left join ti_storageresource s on v.moid = s.moid where s.devsn = :devsn ) or h.REPROVIDERSN = :devsn";
                    session = null;
                    try {
                        session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                        sqlQuery = session.createSQLQuery(sql);
                        sqlQuery.setString("devsn", storageSn);
                        result = sqlQuery.uniqueResult();
                        if (!(result instanceof BigInteger) || ((BigInteger)result).intValue() == 0) break block5;
                        this.logger.debug((Object)("result is " + result));
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        DBOperationUtil.closeSession(session);
                        throw throwable;
                    }
                    DBOperationUtil.closeSession(session);
                    return bl;
                }
                sql = "select count(*) from ti_protectgroupreplica where PROARRAYID = :devsn or RECARRAYID = :devsn";
                sqlQuery = session.createSQLQuery(sql);
                sqlQuery.setString("devsn", storageSn);
                result = sqlQuery.uniqueResult();
                if (!(result instanceof BigInteger)) break block6;
                num = ((BigInteger)result).intValue();
                if (num != 0) break block7;
                boolean bl = false;
                DBOperationUtil.closeSession(session);
                return bl;
            }
            sql = "select count(*) from ti_protectgroupreplica a INNER JOIN ti_protectgroupreplica_prop b on a.id = b.id AND b.PROPNAME = 'isAirGapType' AND b.PROPVALUE = 'true' where a.PROARRAYID = :devsn";
            sqlQuery = session.createSQLQuery(sql);
            sqlQuery.setParameter("devsn", (Object)storageSn);
            Object airGapMasterNum = sqlQuery.uniqueResult();
            boolean bl = !(airGapMasterNum instanceof BigInteger) || ((BigInteger)airGapMasterNum).intValue() != num;
            DBOperationUtil.closeSession(session);
            return bl;
        }
        boolean bl = false;
        DBOperationUtil.closeSession(session);
        return bl;
    }

    public boolean isStorageUsedByPoType(String devSn, int poType) {
        this.logger.debug((Object)"storageSn=%s, poType=", new Object[]{devSn, poType});
        String hql = "from ProtectObject where poType = ?";
        int startPageNo = 0;
        int pageSize = 500;
        List protectObjects = null;
        do {
            Page page = CommonDAOLocator.getBaseDao().pagedQuery(hql, startPageNo, pageSize, new Object[]{poType});
            protectObjects = (List)page.getResult();
            ++startPageNo;
            for (ProtectObject protectObject : protectObjects) {
                String storageMetadata = protectObject.getStorageMetadata();
                if (VerifyUtil.isEmpty((String)storageMetadata)) {
                    this.logger.warn((Object)"po storageMetadata is empty: moUUid=%s", new Object[]{protectObject.getMoUuid()});
                    continue;
                }
                JSONArray metaDataArray = JSONArray.fromObject((Object)storageMetadata);
                List storageInfos = JSONArray.toCollection((JSONArray)metaDataArray, ProtectObjectStorageInfo.class);
                for (ProtectObjectStorageInfo storageInfo : storageInfos) {
                    if (!devSn.equals(storageInfo.getResourceProviderSN())) continue;
                    this.logger.info((Object)"devSn is used: devSn=%s, lunWWN=%s", new Object[]{devSn, storageInfo.getLunWWN()});
                    return true;
                }
            }
        } while (!VerifyUtil.isEmpty((Collection)protectObjects));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStorageControllerNum(String devSn) {
        Session session;
        block4: {
            int n;
            String sql = "SELECT count(*) FROM ti_controller c left join t_managedobject m on c.moid = m.moid WHERE parent_id =(SELECT s.moid FROM ti_storageunit s LEFT JOIN t_managedobject m ON s.moid = m.moid WHERE devsn = :devsn)";
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                NativeQuery sqlQuery = session.createSQLQuery(sql);
                sqlQuery.setParameter("devsn", (Object)devSn);
                Object result = sqlQuery.uniqueResult();
                if (!(result instanceof BigInteger)) break block4;
                n = ((BigInteger)result).intValue();
            }
            catch (Exception e) {
                int n2;
                try {
                    this.logger.error((Object)"Query storage controller num error, dev sn: %s, error msg: %s.", new Object[]{devSn, ExceptionUtil.getErrorMessage((Throwable)e)});
                    n2 = 0;
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
                return n2;
            }
            DBOperationUtil.closeSession(session);
            return n;
        }
        DBOperationUtil.closeSession(session);
        return 0;
    }
}

