/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.util;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.backup.BackupManagerProxy;
import com.huawei.ism.drm.backup.IBackupManager;
import com.huawei.ism.drm.backup.model.BackupStoragePool;
import com.huawei.ism.drm.backup.model.BackupStorageRepository;
import com.huawei.ism.drm.backup.service.IBackupStorageService;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunManager;
import com.huawei.ism.drm.storage.sdk.model.BackupPlan;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BackupPlanUtil {
    private static Log logger = LogFactory.getInstance(BackupPlanUtil.class);
    private static ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();
    private static BackupManagerProxy managerProxy = BackupManagerProxy.getInstance();

    public static BackupPlan createBackupPlan(ProtectGroup protectGroup, Schedule schedule, String devSn) {
        if (!BackupPlanUtil.isExistBackupPlan(schedule)) {
            return null;
        }
        IReplicaBuilder builder = factory.getTemplateByType(protectGroup.getTemplate().getType());
        Map storageInfos = builder.getAllStroageInfo(protectGroup);
        StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
        IStorageLunManager lunManager = proxy.getStorageLunMgrByDevId(devSn);
        List storageInfoList = (List)storageInfos.get(devSn);
        BackupPlan params = null;
        BackupPlan backupPlan = null;
        IBackupManager backupManager = managerProxy.getBackupService("NativeBackupEngine");
        try {
            BackupStoragePool backupStoragePool;
            int transferStatus;
            params = BackupPlanUtil.constructBackupPlanFromSchedule(protectGroup, schedule, devSn);
            logger.info((Object)"start createBackupPlan: backupPlan's name is %s.", new Object[]{params.getName()});
            backupPlan = backupManager.createBackupPlan(params);
            ArrayList<String> lunIds = new ArrayList<String>();
            for (ProtectObjectStorageInfo storageInfo : storageInfoList) {
                String lunId = storageInfo.getResourceId();
                Lun lun = lunManager.getLunById(devSn, lunId);
                if (VerifyUtil.isEmpty((Object)lun)) {
                    throw new LegoCheckedException(1073948705L, "lunId does not exist: lunId=" + lunId);
                }
                lunIds.add(lunId);
                backupManager.addLun(devSn, backupPlan.getId(), lunId, lun.getWwn());
            }
            backupPlan.setSrcLuns(lunIds);
            String offlineTransferStatus = (String)schedule.getExtParameters().get("offlineTransferStatus");
            if (!VerifyUtil.isEmpty((String)offlineTransferStatus) && (transferStatus = NumberUtil.convertToInteger((Object)offlineTransferStatus).intValue()) == 1) {
                backupManager.offlineTransfer(devSn, backupPlan.getId(), transferStatus);
            }
            if (!VerifyUtil.isEmpty((Object)(backupStoragePool = BackupPlanUtil.getBackUpStoragePool(backupPlan.getRepositoryName(), schedule)))) {
                String cloudSiteId = backupStoragePool.getSiteId();
                schedule.getExtParameters().put("CLOUD_SITE_ID", cloudSiteId);
            }
        }
        catch (LegoCheckedException e) {
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(backupPlan)) {
                BackupPlanUtil.deleteBackupPlan(backupPlan.getDevSn(), backupPlan.getId());
            }
            throw e;
        }
        catch (Exception e) {
            String backupPlanName = "";
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(backupPlan)) {
                backupPlanName = backupPlan.getName();
                BackupPlanUtil.deleteBackupPlan(backupPlan.getDevSn(), backupPlan.getId());
            }
            String errorMsg = "create backupPlan(" + backupPlanName + ") failed";
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, null, (Log)logger);
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)backupPlan)) {
            schedule.getExtParameters().put("BACKUP_PLAN_ID", backupPlan.getId());
            schedule.getExtParameters().put("BACKUP_PLAN_NAME", backupPlan.getName());
        }
        return backupPlan;
    }

    private static BackupStoragePool getBackUpStoragePool(String repositoryName, Schedule schedule) {
        if (VerifyUtil.isEmpty((String)repositoryName) || VerifyUtil.isEmpty((Object)schedule)) {
            return null;
        }
        BackupStoragePool backupStoragePool = null;
        HashMap<String, String> filter = new HashMap<String, String>();
        IBackupStorageService iBackupStorageService = (IBackupStorageService)ServiceLocator.getInstance().getService(IBackupStorageService.class);
        List backupStorageRepositories = iBackupStorageService.listBackupStorageRepository(schedule.getTargetSn(), filter);
        if (!VerifyUtil.isEmpty((Collection)backupStorageRepositories)) {
            List backupStoragePools;
            filter.clear();
            String storagePoolName = null;
            Optional<BackupStorageRepository> backupStorageRepositoryOptional = backupStorageRepositories.stream().filter(o -> o != null && o.getName().equals(repositoryName)).findFirst();
            if (backupStorageRepositoryOptional.isPresent()) {
                storagePoolName = backupStorageRepositoryOptional.get().getStoragePoolName();
                filter.put("poolName", storagePoolName);
            }
            if (!VerifyUtil.isEmpty((Collection)(backupStoragePools = iBackupStorageService.listBackupStoragePool(schedule.getTargetSn(), filter)))) {
                String tempStoragePoolName = storagePoolName;
                backupStoragePool = backupStoragePools.stream().filter(o -> o != null && o.getName().equals(tempStoragePoolName)).findFirst().get();
            }
        }
        if (!VerifyUtil.isEmpty(backupStoragePool)) {
            backupStoragePool = iBackupStorageService.getBackupStoragePool(schedule.getTargetSn(), backupStoragePool.getPoolId());
        }
        return backupStoragePool;
    }

    public static boolean isExistBackupPlan(Schedule schedule) {
        if (VerifyUtil.isEmpty((Object)schedule)) {
            return false;
        }
        return schedule.getProtectedType() == ScheduleProtectedType.CLOUD_BACKUP.getValue();
    }

    public static BackupPlan constructBackupPlanFromSchedule(ProtectGroup protectGroup, Schedule schedule, String engineId) {
        BackupPlan backupPlan = new BackupPlan();
        backupPlan.setName(protectGroup.getName() + System.currentTimeMillis());
        backupPlan.setDevSn(engineId);
        backupPlan.setRepositoryName((String)schedule.getExtParameters().get("repositoryName"));
        backupPlan.setDataLayout(NumberUtil.convertToInteger(schedule.getExtParameters().get("dataLayout")));
        backupPlan.setActivated(BackupPlan.BACKUP_PLAN_ACTIVE);
        backupPlan.setRunType("AllInOne");
        backupPlan.setOnceDate(1419232552L);
        backupPlan.setRetentionType(BackupPlan.RETENTION_FOREVER);
        backupPlan.setScheduleType(BackupPlan.MANUAL_EXECUTE.intValue());
        backupPlan.setRetryEnable(Boolean.valueOf(true));
        backupPlan.setRetryTimes(Integer.valueOf(3));
        backupPlan.setRetryDuration(Integer.valueOf(4));
        return backupPlan;
    }

    public static void addLun(String engineId, String backupPlanId, List<String> lunIds) {
        StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
        IStorageLunManager lunManager = proxy.getStorageLunMgrByDevId(engineId);
        IBackupManager backupManager = managerProxy.getBackupService("NativeBackupEngine");
        BackupPlan backupPlan = backupManager.queryBackupPlan(engineId, backupPlanId);
        if (VerifyUtil.isEmpty((Object)backupPlan)) {
            logger.error((Object)("query backupPlan param error, backupPlan not exists. backupPlanId is " + backupPlanId));
            throw new LegoCheckedException(1073947393L);
        }
        List<String> existLunIds = BackupPlanUtil.getBackupLuns(engineId, backupPlan.getId());
        ArrayList<String> successAddedLuns = new ArrayList<String>();
        try {
            for (String lunId : lunIds) {
                if (existLunIds.contains(lunId)) continue;
                Lun lun = lunManager.getLunById(engineId, lunId);
                if (VerifyUtil.isEmpty((Object)lun)) {
                    logger.error((Object)"lun id does not exist: lunId=%s", new Object[]{lunId});
                    throw new LegoCheckedException(1073948705L);
                }
                backupManager.addLun(engineId, backupPlanId, lunId, lun.getWwn());
                successAddedLuns.add(lunId);
            }
        }
        catch (LegoCheckedException e) {
            if (!successAddedLuns.isEmpty()) {
                BackupPlanUtil.removeLun(engineId, backupPlanId, successAddedLuns);
            }
            throw e;
        }
    }

    public static void removeLun(String engineId, String backupPlanId, List<String> lunIds) {
        StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
        IStorageLunManager lunManager = proxy.getStorageLunMgrByDevId(engineId);
        IBackupManager backupManager = managerProxy.getBackupService("NativeBackupEngine");
        BackupPlan backupPlan = backupManager.queryBackupPlan(engineId, backupPlanId);
        if (VerifyUtil.isEmpty((Object)backupPlan)) {
            logger.error((Object)("query backupPlan param error, backupPlan not exists. backupPlanId is " + backupPlanId));
            throw new LegoCheckedException(1073947393L);
        }
        List<String> existLunIds = BackupPlanUtil.getBackupLuns(engineId, backupPlanId);
        for (String lunId : lunIds) {
            if (!existLunIds.contains(lunId)) continue;
            Lun lun = lunManager.getLunById(engineId, lunId);
            if (VerifyUtil.isEmpty((Object)lun)) {
                logger.error((Object)"lun id does not exist: lunId=%s", new Object[]{lunId});
                throw new LegoCheckedException(1073948705L);
            }
            String wwn = lun.getWwn();
            backupManager.removeLun(engineId, backupPlanId, lunId, wwn);
        }
    }

    public static void deleteBackupPlan(String engineId, String backupPlanId) {
        if (VerifyUtil.isEmpty((String)backupPlanId) || VerifyUtil.isEmpty((String)engineId)) {
            return;
        }
        IBackupManager backupManager = managerProxy.getBackupService("NativeBackupEngine");
        try {
            BackupPlan backupPlan = backupManager.queryBackupPlan(engineId, backupPlanId);
        }
        catch (Exception e) {
            logger.error((Object)("query backupPlan param error, backupPlan not exists. backupPlanId is " + backupPlanId));
            return;
        }
        List<Lun> luns = backupManager.getBackupLun(engineId, backupPlanId);
        for (Lun lun : luns) {
            String wwn = lun.getWwn();
            backupManager.removeLun(engineId, backupPlanId, lun.getLunId(), wwn);
        }
        backupManager.deleteBackupPlan(engineId, backupPlanId);
    }

    public static BackupPlan queryBackupPlanWithProtectObjects(String engineId, String backupPlanId) {
        if (VerifyUtil.isEmpty((String)engineId)) {
            logger.error((Object)"engineId is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)backupPlanId)) {
            logger.error((Object)"backupPlanId is null.");
            throw new LegoCheckedException(1073947393L);
        }
        IBackupManager backupManager = managerProxy.getBackupService("NativeBackupEngine");
        BackupPlan backupPlan = backupManager.queryBackupPlan(engineId, backupPlanId);
        if (null == backupPlan) {
            logger.error((Object)"query backupPlan param error, backupPlan not exists. engineId is %s, backupPlanId is %s.", new Object[]{engineId, backupPlanId});
            throw new LegoCheckedException(1073947393L);
        }
        List<String> lunIds = BackupPlanUtil.getBackupLuns(engineId, backupPlanId);
        backupPlan.setSrcLuns(lunIds);
        return backupPlan;
    }

    public static List<String> getBackupLuns(String engineId, String backupPlanId) {
        IBackupManager backupManager = managerProxy.getBackupService("NativeBackupEngine");
        List<Lun> luns = backupManager.getBackupLun(engineId, backupPlanId);
        ArrayList<String> existLunIds = new ArrayList<String>();
        if (VerifyUtil.isEmpty(luns)) {
            return existLunIds;
        }
        for (Lun lun : luns) {
            existLunIds.add(lun.getLunId());
        }
        return existLunIds;
    }
}

