/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class ConfigDataCommon {
    private static final Log logger = LogFactory.getInstance(ConfigDataCommon.class);

    private ConfigDataCommon() {
    }

    public static int calculateFirstRunDelayTime(String time) {
        Date firstRunDate;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            firstRunDate = sdf.parse(time);
        }
        catch (ParseException e) {
            logger.error((Object)("failed to parse first run time :" + time), (Throwable)e, 90160758787071L);
            return 0;
        }
        Date now = new Date();
        Calendar cNow = Calendar.getInstance();
        Calendar cFirstRun = Calendar.getInstance();
        cNow.setTime(now);
        cFirstRun.setTime(firstRunDate);
        cFirstRun.set(1, cNow.get(1));
        cFirstRun.set(2, cNow.get(2));
        cFirstRun.set(5, cNow.get(5));
        long nowMs = cNow.getTimeInMillis();
        long firstMs = cFirstRun.getTimeInMillis();
        long intervalMs = nowMs - firstMs;
        long delayValue = intervalMs > 0L ? 86400000L - intervalMs : Math.abs(intervalMs);
        delayValue = delayValue / 1000L / 60L;
        Long retValue = NumberUtil.convertToLong((Object)delayValue);
        return retValue.intValue();
    }

    public static int daysBetween(Date now, Date returnDate) {
        Calendar cNow = Calendar.getInstance();
        Calendar cReturnDate = Calendar.getInstance();
        cNow.setTime(now);
        cReturnDate.setTime(returnDate);
        ConfigDataCommon.setTimeToMidnight(cNow);
        ConfigDataCommon.setTimeToMidnight(cReturnDate);
        long todayMs = cNow.getTimeInMillis();
        long returnMs = cReturnDate.getTimeInMillis();
        long intervalMs = todayMs - returnMs;
        return ConfigDataCommon.millisecondsToDays(intervalMs);
    }

    private static int millisecondsToDays(long intervalMs) {
        return (int)(intervalMs / 86400000L);
    }

    private static void setTimeToMidnight(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
    }

    public static TopoObject getManagementSystemMO() {
        TopoObject topObj = (TopoObject)CommonDAOLocator.getMoDao().getMo(TopoObject.class, "moId", (Object)Long.valueOf("1"));
        return topObj;
    }
}

