/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.database;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.system.cfgdata.database.AESUtil;
import com.huawei.ism.drm.system.cfgdata.database.CmdUtil;
import com.huawei.ism.drm.system.cfgdata.database.ZipUtil;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GuassDBdumpImpl {
    private static final Log logger = LogFactory.getInstance(GuassDBdumpImpl.class);
    private static final String LINUX_DMP = "/usr/local/gaussdb/bin/gs_dump";
    private static final String WCC_FILE = "wcc.conf";
    private static final int BYTELEN = 1024;
    private static String saltFile = "zip1.tmp";
    private static String ivFile = "zip2.tmp";
    private static String destZipFile = "SQLData.zip";
    private static String installedFile;
    private static String installPath;
    private static final List<String> DATA_BASE_SCHEMES;
    private String exportPath = "";
    private String host = "";
    private String userName = "";
    private String userPass = "";
    private String dbName = "lego";
    private String dbPort = "6432";
    private String dataBaseNode = "database";
    private List<String> fileList = new ArrayList<String>();

    public GuassDBdumpImpl() {
        this.parseXML();
    }

    private void parseXML() {
        try {
            String runTimeTmpPath = installPath + File.separator + "tmp";
            File tmpPathFile = new File(runTimeTmpPath);
            File tmpFile = tmpPathFile.exists() ? File.createTempFile("lego", ".sql", tmpPathFile) : File.createTempFile("lego", ".sql");
            this.exportPath = tmpFile.getParent() + File.separator;
            if (!tmpFile.delete()) {
                logger.error((Object)"parseXML delete failed.", 90160758787071L);
            }
        }
        catch (Exception e) {
            logger.error((Object)"parseXML error:", 90160758787071L);
        }
        try {
            File file = new File(installedFile);
            DocumentBuilder builder = CommonUtil.createDocumentBuilder((boolean)false);
            Document doc = builder.parse(file);
            NodeList nl = doc.getElementsByTagName("install");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element bookElement = (Element)nl.item(i);
                NodeList childNodes = bookElement.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node node = childNodes.item(j);
                    this.degradeParseXML(node);
                }
            }
            this.checkParam();
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"parseXML error:", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSaltAndIV(byte[] salt, byte[] iv) {
        String output1 = this.exportPath + saltFile;
        String output2 = this.exportPath + ivFile;
        FileOutputStream out1 = null;
        FileOutputStream out2 = null;
        try {
            out1 = new FileOutputStream(output1, false);
            ((OutputStream)out1).write(salt);
            out1.flush();
            out2 = new FileOutputStream(output2, false);
            ((OutputStream)out2).write(iv);
            out2.flush();
            this.closeOutStream(out1, out2);
        }
        catch (IOException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"WriteSaltAndIV failed:", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
        finally {
            this.closeOutStream(out1, out2);
        }
    }

    private void closeOutStream(OutputStream stream1, OutputStream stream2) {
        try {
            if (stream1 != null) {
                stream1.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"close error:", 90160758787071L);
        }
        try {
            if (stream2 != null) {
                stream2.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"close error:", 90160758787071L);
        }
    }

    private void checkParam() {
        if (VerifyUtil.isEmpty((String)this.userName) || VerifyUtil.isEmpty((String)this.host) || VerifyUtil.isEmpty((String)this.userPass) || VerifyUtil.isEmpty((String)this.dbPort)) {
            logger.error((Object)"check param failed~!", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkParam((String)this.userName, (String)"^[A-Za-z]+$", (int)4, (int)8)) {
            logger.error((Object)"check userName failed~!", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmPortParam((String)this.dbPort) || !this.checkIpParam().booleanValue()) {
            logger.error((Object)"check IP/Port failed~!", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (CommUtil.isBlackListCharacter((String)this.userPass)) {
            logger.error((Object)"check userPass failed~!", new Object[]{Long.toString(90160758787071L)});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private Boolean checkIpParam() {
        return AddressUtil.isIpAddress((String)this.host);
    }

    private void degradeParseXML(Node node) {
        if (node.getNodeType() == 1 && this.dataBaseNode.equals(node.getNodeName())) {
            NamedNodeMap nnm = node.getAttributes();
            this.host = nnm.getNamedItem("dbhost").getNodeValue();
            this.userName = nnm.getNamedItem("dbuserName").getNodeValue();
            this.userPass = WccEncryptor.decrypt((String)nnm.getNamedItem("dbpassword").getNodeValue());
            this.dbPort = nnm.getNamedItem("dbport").getNodeValue();
        }
    }

    public File backup(String encryptPwd, boolean isDataAnonymous) {
        String osName = System.getProperty("os.name");
        if (null == osName) {
            throw new LegoCheckedException(-1L, "The system property os.name does not exist.");
        }
        this.checkParam();
        return this.backupLinux(encryptPwd, isDataAnonymous);
    }

    private void exportWccKey(String pwd) {
        String file = this.exportPath + WCC_FILE;
        WccEncryptor.exportWccConfig((String)file, (String)pwd);
        this.fileList.add(WCC_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipOutPutFile(String zipPath, String zipFile) {
        ZipOutputStream zip = null;
        try {
            zip = new ZipOutputStream(new FileOutputStream(zipFile));
            File srcFile = new File(zipPath);
            String base = "";
            this.fileZip(srcFile, zip, base);
        }
        catch (FileNotFoundException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"FileNotFoundException.", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close failed. ", 90160758787071L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileZip(File srcFile, ZipOutputStream zos, String base) {
        FileInputStream fis = null;
        try {
            if (srcFile.isDirectory()) {
                File[] files = srcFile.listFiles();
                if (files != null) {
                    for (File file : files) {
                        if (!this.fileList.contains(file.getName())) continue;
                        this.fileZip(file, zos, base + file.getName());
                    }
                }
            } else {
                int n;
                zos.putNextEntry(new ZipEntry(base));
                fis = new FileInputStream(srcFile);
                byte[] buf = new byte[1024];
                while ((n = fis.read(buf, 0, buf.length)) != -1) {
                    zos.write(buf, 0, n);
                }
                zos.flush();
            }
        }
        catch (IOException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"zip file failed.", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
        finally {
            this.doCloseStream(fis);
        }
    }

    private void doCloseStream(FileInputStream in) {
        try {
            if (null != in) {
                in.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"zipFile close in error", 90160758787071L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File backupLinux(String encryptPwd, boolean isDataAnonymous) {
        File wccFile;
        File outPut;
        StringBuilder path = new StringBuilder();
        StringBuilder param = new StringBuilder();
        String fileName = this.exportPath.replace(" ", "\" \"") + this.dbName + ".sql";
        path.append(LINUX_DMP);
        param.append(" -h").append(this.host);
        param.append(" -U").append(this.userName);
        param.append(" -W ").append(this.userPass);
        param.append(" -p ").append(this.dbPort);
        param.append(" --pg-format ");
        param.append(this.dbName);
        param.append(" -f ");
        param.append(fileName);
        logger.info((Object)"Linux GAUSS Backup is started. LogCode: %s", new Object[]{String.valueOf(90160758786816L)});
        String cmd = path.toString();
        File sf = null;
        File tempFile = null;
        File zipFile = null;
        try {
            CmdUtil.runShell(cmd, new String[]{param.toString()});
            sf = new File(fileName);
            if (!sf.exists() || 0L == sf.length()) {
                throw new LegoCheckedException(0x300001L);
            }
            if (isDataAnonymous) {
                tempFile = this.resolveSQLFile(sf);
                zipFile = ZipUtil.getInstance().zipFile(tempFile);
            } else {
                zipFile = ZipUtil.getInstance().zipFile(sf);
            }
            File f = AESUtil.getInstance().encryptFile(zipFile, ".zip", encryptPwd);
            this.exportWccKey(encryptPwd);
            outPut = this.getOutPutFile(f);
            this.deleteTemFiles(sf, tempFile, zipFile);
            String file = this.exportPath + WCC_FILE;
            wccFile = new File(file);
            if (!wccFile.exists() || wccFile.delete()) return outPut;
        }
        catch (Exception e) {
            File wccFile2;
            File file;
            try {
                ExceptionUtil.rethrowException((Throwable)e, (String)"backupLinux error:", (long)0x300001L, (String[])new String[0], (Log)logger);
                file = null;
                this.deleteTemFiles(sf, tempFile, zipFile);
                String file2 = this.exportPath + WCC_FILE;
                wccFile2 = new File(file2);
                if (!wccFile2.exists() || wccFile2.delete()) return file;
            }
            catch (Throwable throwable) {
                this.deleteTemFiles(sf, tempFile, zipFile);
                String file3 = this.exportPath + WCC_FILE;
                File wccFile3 = new File(file3);
                if (!wccFile3.exists() || wccFile3.delete()) throw throwable;
                logger.error((Object)("Filed to delete temp file: " + wccFile3.getName()));
                throw throwable;
            }
            logger.error((Object)("Filed to delete temp file: " + wccFile2.getName()));
            return file;
        }
        logger.error((Object)("Filed to delete temp file: " + wccFile.getName()));
        return outPut;
    }

    private void deleteTemFiles(File sf, File tempFile, File zipFile) {
        this.deleteTmpFile(sf);
        this.deleteTmpFile(tempFile);
        this.deleteTmpFile(zipFile);
    }

    private File resolveSQLFile(File file) {
        BufferedReader reader = null;
        BufferedWriter write = null;
        try {
            String absolutePath = file.getCanonicalPath();
            String fileName = file.getName();
            String pathPrefix = absolutePath.substring(0, absolutePath.indexOf(fileName));
            String copyFile = pathPrefix + "temp_" + fileName;
            File newFile = new File(copyFile);
            if (!newFile.exists()) {
                boolean createResult = newFile.createNewFile();
                if (!createResult) {
                    logger.error((Object)"Create file failed, the name is : %s", new Object[]{fileName});
                    throw new LegoCheckedException(0x300001L);
                }
            } else {
                File f;
                while ((f = new File(copyFile = pathPrefix + "_temp_" + System.nanoTime() + fileName)).exists()) {
                }
                newFile = f;
                boolean createResult = newFile.createNewFile();
                if (!createResult) {
                    logger.error((Object)"Create file failed.");
                    throw new LegoCheckedException(0x300001L);
                }
            }
            boolean isContinue = false;
            String line = null;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "utf-8"));
            while (null != (line = reader.readLine())) {
                for (String scheme : DATA_BASE_SCHEMES) {
                    if (line.startsWith(scheme.toUpperCase(Locale.getDefault()))) {
                        isContinue = true;
                        continue;
                    }
                    if (!line.equals("--")) continue;
                    isContinue = false;
                }
                if (!isContinue) {
                    write.write(line);
                    write.newLine();
                }
                write.flush();
            }
            File file2 = newFile;
            this.closeReaderWriteStream(reader, write);
            return file2;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("resolveSQLFile failed," + ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new LegoCheckedException(0x300001L);
            }
            catch (Throwable throwable) {
                this.closeReaderWriteStream(reader, write);
                throw throwable;
            }
        }
    }

    private void closeReaderWriteStream(BufferedReader reader, BufferedWriter write) {
        try {
            if (null != reader) {
                reader.close();
            }
        }
        catch (Exception e2) {
            logger.error((Object)("close reader steam failed," + ExceptionUtil.getErrorMessage((Throwable)e2)));
        }
        try {
            if (null != write) {
                write.close();
            }
        }
        catch (Exception e3) {
            logger.error((Object)("close write steam failed," + ExceptionUtil.getErrorMessage((Throwable)e3)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getOutPutFile(File zipFile) {
        if (null == zipFile || !zipFile.exists()) {
            return null;
        }
        File outFile = null;
        try {
            this.fileList.add(zipFile.getName());
            this.fileList.add(ivFile);
            this.fileList.add(saltFile);
            this.zipOutPutFile(this.exportPath, this.exportPath + destZipFile);
            outFile = new File(this.exportPath + destZipFile);
        }
        catch (Exception e) {
            logger.error((Object)"GetCanonicalPath error!");
            ExceptionUtil.rethrowException((Exception)e, (String)"GetCanonicalPath error!", (long)90160758787071L, null);
        }
        finally {
            this.deleteTmpFile(zipFile);
            String output1 = this.exportPath + saltFile;
            String output2 = this.exportPath + ivFile;
            File tmpSaltFile = new File(output1);
            File tmpIvFile = new File(output2);
            if (tmpSaltFile.exists() && !tmpSaltFile.delete()) {
                logger.error((Object)("Filed to delete tmp saltFile: " + tmpSaltFile.getName()));
            }
            if (tmpIvFile.exists() && !tmpIvFile.delete()) {
                logger.error((Object)("Filed to delete tmp ivFile: " + tmpIvFile.getName()));
            }
        }
        return outFile;
    }

    private void deleteTmpFile(File delFile) {
        if (null == delFile) {
            return;
        }
        if (delFile.exists() && !delFile.delete()) {
            logger.error((Object)String.format(Locale.ROOT, "Failed to delete temp file: %s", delFile.getName()));
        }
    }

    static {
        installPath = "";
        DATA_BASE_SCHEMES = Arrays.asList("COPY T_cloudservice_bureauInfo", "COPY T_cloudservice_email", "COPY T_alarm_notifyserver", "COPY T_alarm_notifyrule");
        String userDir = System.getProperties().getProperty("user.dir");
        if (null == userDir) {
            throw new LegoCheckedException(1073947393L);
        }
        File legoRuntimeDir = new File(userDir);
        try {
            installedFile = legoRuntimeDir.getParentFile().getCanonicalPath() + File.separator + "bin" + File.separator + "config" + File.separator + "system.xml";
            installPath = legoRuntimeDir.getParentFile().getCanonicalPath();
        }
        catch (IOException e) {
            logger.error((Object)"get INSTALLED_FILE error!", 90160758787071L);
        }
    }
}

