/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.database;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ZipUtil {
    private static ZipUtil instance = new ZipUtil();
    private static final Log logger = LogFactory.getInstance(ZipUtil.class);
    private static final int SIZE = 10240;

    private ZipUtil() {
    }

    public static ZipUtil getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File zipFile(File souceFile) {
        ZipOutputStream out = null;
        FileInputStream in = null;
        try {
            int b;
            this.checkFile(souceFile);
            String dir = souceFile.getParent();
            String name = souceFile.getName().replace(".sql", "");
            String zipFile = dir + File.separator + name + ".zip";
            out = new ZipOutputStream(new FileOutputStream(zipFile));
            out.putNextEntry(new ZipEntry(souceFile.getName()));
            in = new FileInputStream(souceFile);
            byte[] by = new byte[10240];
            while ((b = in.read(by)) != -1) {
                out.write(by, 0, b);
            }
            out.flush();
            File file = new File(zipFile);
            this.doCloseStream(out, in);
            return file;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"zipFile error", (long)0x300001L, (String[])new String[0], (Log)logger);
            File file = null;
            return file;
        }
        finally {
            this.doCloseStream(out, in);
        }
    }

    private void checkFile(File f) throws FileNotFoundException {
        if (null == f || !f.canRead()) {
            throw new LegoCheckedException(102404L);
        }
    }

    private void doCloseStream(ZipOutputStream out, FileInputStream in) {
        try {
            if (null != out) {
                out.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"zipFile close out error", 90160758787071L);
        }
        try {
            if (null != in) {
                in.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"zipFile close in error", 90160758787071L);
        }
    }
}

