/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.builder;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.topo.builder.AbstractTopoBaseBuilder;
import com.huawei.ism.drm.topo.element.PGElement;
import com.huawei.ism.drm.topo.element.SiteElement;
import com.huawei.ism.drm.topo.sdk.builder.ITopoBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoContext;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.dao.DataAccessException;
import twaver.ElementBox;
import twaver.IData;
import twaver.Layer;
import twaver.Node;

public abstract class AbstractTopoBuilder
extends AbstractTopoBaseBuilder
implements ITopoBuilder {
    private static final String TGT_LUN_ID = "tgtLunId";
    private static final String DEV_SN = "devSn";
    private static final String TGT_DEV_SN = "tgtDevSN";
    private static Log logger = LogFactory.getInstance(AbstractTopoBuilder.class);

    public abstract void buildTopo(TopoContext var1);

    @Deprecated
    public String getTopoType() {
        return null;
    }

    public DrResource getDrResource(String sn) {
        String hql = "from DrResource where deviceSn=?";
        List drHost = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{sn});
        if (drHost == null || drHost.isEmpty()) {
            return null;
        }
        return (DrResource)drHost.get(0);
    }

    protected void initialize(TopoContext context) {
        PGElement root = new PGElement(null);
        ElementBox box = context.getElementBox();
        box.setStyle("background.type", (Object)"image");
        box.setStyle("background.image", (Object)"/theme/recoverydirector/images/topo/default.png");
        box.setStyle("background.image.stretch", (Object)"tile");
        context.setRootNode((Node)root);
        context.add((IData)root);
        String linkLayerId = "linkLayer";
        Layer layer = new Layer((Object)linkLayerId);
        box.getLayerBox().add((IData)layer);
        box.getLayerBox().moveTo((IData)layer, 1);
        Layer layer0 = new Layer((Object)"layer0");
        box.getLayerBox().add((IData)layer0);
        box.getLayerBox().moveTo((IData)layer0, 0);
        layer.setEditable(false);
        layer.setMovable(false);
        box.getLayerBox().getDefaultLayer().setMovable(false);
        box.getLayerBox().getDefaultLayer().setEditable(false);
    }

    protected List<String> getHyperMetroSiteIds(TopoContext context, ProtectObjectStorageInfo poStorageInfo) {
        List<StorageResource> srList;
        String wwn = poStorageInfo.getLunWWN();
        if (DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue() == this.getStorageResourceType(context.getProtectGroup())) {
            String devSn = null;
            HashSet<String> resourceIds = new HashSet<String>();
            for (ProtectObject protectObject : context.getProtectGroup().getPolist()) {
                for (ProtectObjectStorageInfo storageInfo : protectObject.getUsedStorageResourceSet()) {
                    devSn = storageInfo.getResourceProviderSN();
                    resourceIds.add(storageInfo.getResourceId());
                }
            }
            List<HyperMetroPair> hmList = this.getHyperMetroPairList(devSn, new ArrayList<String>(resourceIds));
            String vstorePairId = (String)context.getProtectGroup().getProps().get("PROP_KEY_VSTORE_PAIR_ID");
            srList = StorageResourceServiceRouter.getInstance().getNasHyperMetroStoreageList(devSn, vstorePairId, hmList);
        } else {
            srList = this.getSanHyperMetroStoreageList(context, wwn);
        }
        List<String> siteIdList = this.getSiteIdList(srList);
        return siteIdList;
    }

    protected int getStorageResourceType(ProtectGroup pg) {
        int type = DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue();
        if (null == pg) {
            logger.error((Object)"getStorageResourceType failed, the pg is null.");
            return type;
        }
        Set poList = pg.getPolist();
        if (VerifyUtil.isEmpty((Collection)poList)) {
            logger.error((Object)"getStorageResourceType failed, poList is empty.");
            return type;
        }
        for (ProtectObject po : poList) {
            Set poStorageInfos = po.getUsedStorageResourceSet();
            Iterator iterator = poStorageInfos.iterator();
            if (!iterator.hasNext()) continue;
            ProtectObjectStorageInfo poStorageInfo = (ProtectObjectStorageInfo)iterator.next();
            type = poStorageInfo.getResourceType();
        }
        return type;
    }

    protected List<HyperMetroPair> getHyperMetroPairList(String devSn, List<String> resourceIds) {
        StorageResourceServiceRouter router = StorageResourceServiceRouter.getInstance();
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (VerifyUtil.isEmpty((Object)((Object)router)) || VerifyUtil.isEmpty((Object)drResource)) {
            logger.error((Object)"getRouter or getDrResource error!");
            throw new LegoCheckedException(1073947394L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(drResource.getSiteId());
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)"getSite error!");
            throw new LegoCheckedException(1073947394L);
        }
        List<HyperMetroPair> pairList = router.getHyperMetroPairsByFileSystemIds(site.getServerUuid(), devSn, resourceIds, null, false);
        return pairList;
    }

    protected Map<String, String> getVstoreIdMap(List<HyperMetroPair> hmList) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (VerifyUtil.isEmpty(hmList)) {
            return dataMap;
        }
        for (HyperMetroPair hyperMetroPair : hmList) {
            if (!dataMap.containsKey(hyperMetroPair.getDevSn())) {
                dataMap.put(hyperMetroPair.getDevSn(), hyperMetroPair.getVstorePairId());
            }
            if (dataMap.size() != 2) continue;
            break;
        }
        logger.debug((Object)("getVstoreId, dataMap: " + dataMap));
        HashMap<String, String> vstoreMap = new HashMap<String, String>();
        try {
            for (Map.Entry entry : dataMap.entrySet()) {
                String devSn = (String)entry.getKey();
                String vstorePairId = (String)entry.getValue();
                if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)vstorePairId)) {
                    logger.error((Object)("getVstoreIdMap failed, devSn=" + devSn + ", vstorePairId=" + vstorePairId));
                    return vstoreMap;
                }
                VstoreHyperMetroPair vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstorePairId(devSn, vstorePairId);
                vstoreMap.put(devSn, vstoreHyperMetroPair.getLocalVstoreId());
            }
        }
        catch (DataAccessException dataAccessException) {
            logger.error((Object)("getVstoreIdMap failed, err=" + ExceptionUtil.getErrorMessage((Throwable)dataAccessException)));
        }
        logger.debug((Object)("vstoreMap=" + vstoreMap));
        return vstoreMap;
    }

    protected Map<String, String> getNasHyperMetroPairMap(ProtectGroup pg, List<HyperMetroPair> hmList) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        Map<String, String> vstoreMap = this.getVstoreIdMap(hmList);
        for (HyperMetroPair pair : hmList) {
            String vstoreId = vstoreMap.get(pair.getDevSn());
            if (VerifyUtil.isEmpty((String)vstoreId)) {
                logger.error((Object)"getNasHyperMetroPairMap failed, vstoreId is empty.");
                return dataMap;
            }
            String uuid = new XveUUID(pair.getDevSn(), XveMOType.FILESYSTEM, pair.getLocalObjId() + "_vstoreId=" + vstoreId).toString();
            dataMap.put(uuid, pair.getId());
        }
        return dataMap;
    }

    protected List<StorageResource> getSanHyperMetroStoreageList(TopoContext context, String wwn) {
        List<Object> storageList = new ArrayList<StorageResource>();
        ProtectGroup pg = context.getProtectGroup();
        if (null == pg) {
            logger.error((Object)"getHyperMetroStorageList failed, pg is null.");
            return storageList;
        }
        logger.debug((Object)"enter not nas progress.");
        if (pg.isPrimary()) {
            storageList = context.getStorageService().getStorageResourceByWwn(new String[]{wwn});
        } else {
            Site productSite = context.getSiteService().getSiteById(pg.getProductSiteId());
            storageList = context.getStorageService().getResourceByWwnFromRemote(productSite, new ArrayList<String>(Arrays.asList(wwn)));
        }
        return storageList;
    }

    private List<String> getSiteIdList(List<StorageResource> lunList) {
        ArrayList<String> siteIdList = new ArrayList<String>();
        for (StorageResource sr : lunList) {
            String siteId;
            String devSn;
            DrResource drStorage;
            if (!(sr instanceof Lun) && !(sr instanceof NasFileSystem) || (drStorage = this.getDrResource(devSn = sr.getDevSn())) == null || siteIdList.contains(siteId = drStorage.getSiteId())) continue;
            siteIdList.add(siteId);
        }
        return siteIdList;
    }

    protected Node createSiteNode(TopoContext context, Site site, Node root) {
        Node old = (Node)context.getElementBox().getElementByID((Object)site.getSiteId());
        if (old != null) {
            return old;
        }
        SiteElement node = new SiteElement(site);
        node = (Node)context.addChild((IData)root, (IData)node);
        return node;
    }

    protected List<StorageResource> getResourceListFromDB(Site site, String srcSN, List<String> listResourceID) {
        return this.getResourceListFromDB(srcSN, listResourceID);
    }

    protected List<StorageResource> getResourceListFromDB(String srcSN, List<String> listResourceID) {
        List<Object> listResources = null;
        try {
            HashMap<String, Object> srcProps = new HashMap<String, Object>();
            srcProps.put(DEV_SN, srcSN);
            srcProps.put("resourceId", listResourceID.toArray());
            listResources = CommonDAOLocator.getMoDao().findMoBy(StorageResource.class, srcProps);
        }
        catch (Exception e) {
            listResources = new ArrayList<StorageResource>();
            logger.error((Object)("getResourceListFromDB failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return listResources;
    }

    protected void setResouceInfo(List<StorageResource> srcResources, JSONArray jsonArray) {
        Iterator it = jsonArray.iterator();
        while (it.hasNext()) {
            NasFileSystem storageResource;
            JSONObject jsonObject = JSONObject.fromObject(it.next());
            int resourceType = 0;
            if (jsonObject.containsKey((Object)"resourceType")) {
                resourceType = jsonObject.getInt("resourceType");
            }
            if (DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue() == resourceType) {
                storageResource = new NasFileSystem();
                if (jsonObject.containsKey((Object)"vstoreId")) {
                    storageResource.setVstoreId(jsonObject.getString("vstoreId"));
                }
            } else {
                if (DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue() != resourceType) continue;
                storageResource = new Lun();
                this.setWwn(jsonObject, (StorageResource)storageResource);
            }
            storageResource.setResourceId(jsonObject.getString("id"));
            storageResource.setName(jsonObject.getString("name"));
            storageResource.setTotalCapacity(Double.valueOf(jsonObject.getDouble("totalCapacity")));
            storageResource.setTotalCapacityUnit(jsonObject.getString("totalCapacityUnit"));
            storageResource.setDevSn(jsonObject.getString(DEV_SN));
            if (jsonObject.containsKey((Object)"usedCapacity")) {
                storageResource.setUsedCapacity(Double.valueOf(jsonObject.getDouble("usedCapacity")));
            }
            if (jsonObject.containsKey((Object)"usedCapacityUnit")) {
                storageResource.setUsedCapacityUnit(jsonObject.getString("usedCapacityUnit"));
            }
            storageResource.setHealthStatus(jsonObject.getString("healthStatus"));
            srcResources.add((StorageResource)storageResource);
        }
    }

    protected List<ReplicationTargetLun> getTrgLunListFromDB(String srcSN, String trgSN, List<String> listTrgLunID) {
        List<Object> listReplicationTargetLun = new ArrayList<ReplicationTargetLun>();
        try {
            HashMap<String, Object> trgProps = new HashMap<String, Object>();
            trgProps.put(TGT_DEV_SN, trgSN);
            trgProps.put(DEV_SN, srcSN);
            trgProps.put(TGT_LUN_ID, listTrgLunID.toArray());
            listReplicationTargetLun = CommonDAOLocator.getMoDao().findMoBy(ReplicationTargetLun.class, trgProps);
        }
        catch (Exception e) {
            logger.error((Object)("get TargetLuns By devSn And LunID failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return listReplicationTargetLun;
    }

    protected List<Lun> getLunListFromDB(String devSn, List<String> listLunID) {
        List<Object> listLun = null;
        try {
            HashMap<String, Object> srcProps = new HashMap<String, Object>();
            srcProps.put(DEV_SN, devSn);
            srcProps.put("lunId", listLunID.toArray());
            listLun = CommonDAOLocator.getMoDao().findMoBy(Lun.class, srcProps);
        }
        catch (Exception e) {
            listLun = new ArrayList<Lun>();
            logger.error((Object)("getSrcLunBySnAndLunID failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return listLun;
    }

    protected List<String> getPoStorageWwns(ProtectGroup pg) {
        List poStorageList = pg.distinctStorageInfo();
        List<String> poStorageWwns = poStorageList.stream().map(e -> e.getLunWWN()).collect(Collectors.toList());
        return poStorageWwns;
    }

    protected Map<String, String> getHostAndAppMap(String appName) {
        HashMap<String, String> hostAppNameMap = new HashMap<String, String>();
        if (appName == null) {
            return hostAppNameMap;
        }
        try {
            appName = appName.replace("&quot;", "\"");
            JSONArray instanceArray = JSONArray.fromObject((Object)appName);
            int jsonLenth = instanceArray.size();
            for (int iter = 0; iter < jsonLenth; ++iter) {
                JSONObject instanceObj = instanceArray.getJSONObject(iter);
                hostAppNameMap.put(instanceObj.get("ip").toString(), instanceObj.get("INSTANCENAME").toString());
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"getHostAndAppMap json Exception", (Throwable)e, 90160758786989L);
            return null;
        }
        return hostAppNameMap;
    }

    private void setWwn(JSONObject jsonObject, StorageResource storageResource) {
        if (jsonObject.containsKey((Object)"wwn")) {
            ((Lun)storageResource).setWwn(jsonObject.getString("wwn"));
        }
    }

    protected String getUuidKey(ProtectObjectStorageInfo hostStorageInfo) {
        String uuid = new XveUUID(hostStorageInfo.getResourceProviderSN(), XveMOType.FILESYSTEM, hostStorageInfo.getResourceId() + "_vstoreId=" + hostStorageInfo.getVstoreId()).toString();
        return uuid;
    }

    protected Map<String, String> getHyperMetroPairMap(TopoContext context, ProtectGroup pg) {
        HashSet<String> resourceIds = new HashSet<String>();
        String devSn = null;
        for (ProtectObject protectObject : context.getProtectGroup().getPolist()) {
            for (ProtectObjectStorageInfo storageInfo : protectObject.getUsedStorageResourceSet()) {
                devSn = storageInfo.getResourceProviderSN();
                resourceIds.add(storageInfo.getResourceId());
            }
        }
        List<HyperMetroPair> hmList = this.getHyperMetroPairList(devSn, new ArrayList<String>(resourceIds));
        return this.getNasHyperMetroPairMap(pg, hmList);
    }

    protected void linkeNodeToLunByWwn(TopoContext context, Node node, String lunWwn) {
        if (VerifyUtil.isEmpty((Object)context) || VerifyUtil.isEmpty((Object)context.getProtectGroup()) || VerifyUtil.isEmpty((Object)node)) {
            return;
        }
        ProtectGroup pg = context.getProtectGroup();
        if (PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(pg.getTemplate().getType()) && ProtectionJobUtil.isHyperMetroInFirstSite(context.getProtectGroup()) || 32 == pg.getTemplate().getType()) {
            Site site = context.getSiteService().getSiteById(pg.getProductSiteId());
            List lunList = 0 == site.getSiteType() ? context.getStorageService().getStorageResourceByWwn(new String[]{lunWwn}) : context.getStorageService().getResourceByWwnFromRemote(site, Arrays.asList(lunWwn));
            lunList.stream().forEach(lun -> context.linkTo(node, (Object)(lun.getDevSn() + lun.getResourceId()), new Skin[0]));
        }
    }
}

