/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.builder;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.topo.builder.TopoLegendBuilder;
import com.huawei.ism.drm.topo.sdk.builder.ITopoBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoBuilderManager;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.sdk.model.Topo;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.dao.DataAccessException;
import twaver.DataBox;
import twaver.ElementBox;
import twaver.Group;
import twaver.Node;
import twaver.XMLSerializer;

public class GlobalTopoBuilder {
    private static final String USEFUL = "useful";
    private static final String CENTER = "center";
    private static final String COUNT = "count";
    private static final double NUM_TWO = 2.0;
    private static final double NODE_START_X = 300.0;
    private static final double NODE_INTERVAL_X = 200.0;
    private static final double NODE_INTERVAL_X_SMALL = 100.0;
    private static final double NODE_LEVEL_HOST = 100.0;
    private static final double NODE_LEVEL_VIS = 300.0;
    private static final double NODE_LEVEL_STORAGE = 500.0;
    private static final double NODE_LEVEL_SERVER = 700.0;
    private static final double VIS_DOUBLE_ACTIVE_GAP = 100.0;
    private static final List<Integer> RECOVERY_PLAN_STATUS_LIST = new ArrayList<Integer>(Arrays.asList(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING.getValue()));
    private long userId = 1L;
    private final Log logger = LogFactory.getInstance(this.getClass());
    private ITopoResourceManager resourceManager;
    private IProtectGroupService protectGroupService;
    private ISiteService siteService;
    private IStorageService storageService;
    private IRecoveryPlanService recoveryPlanService;
    private ITopoBuilderManager topoBuilderManager;
    private ILicenseControl licenseControl;
    private IReplicaService replicaService;
    private IDrmTopoService topoService;
    private IStorageResourceService storageResourceService;

    public IStorageResourceService getStorageResourceService() {
        return this.storageResourceService;
    }

    public void setStorageResourceService(IStorageResourceService storageResourceService) {
        this.storageResourceService = storageResourceService;
    }

    public IDrmTopoService getTopoService() {
        return this.topoService;
    }

    public void setTopoService(IDrmTopoService topoService) {
        this.topoService = topoService;
    }

    public IReplicaService getReplicaService() {
        return this.replicaService;
    }

    public void setReplicaService(IReplicaService replicaService) {
        this.replicaService = replicaService;
    }

    public ILicenseControl getLicenseControl() {
        return this.licenseControl;
    }

    public void setLicenseControl(ILicenseControl licenseControl) {
        this.licenseControl = licenseControl;
    }

    public ISiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteService siteService) {
        this.siteService = siteService;
    }

    public IRecoveryPlanService getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public void setRecoveryPlanService(IRecoveryPlanService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public IStorageService getStorageService() {
        return this.storageService;
    }

    public void setStorageService(IStorageService storageService) {
        this.storageService = storageService;
    }

    public IProtectGroupService getProtectGroupService() {
        return this.protectGroupService;
    }

    public void setProtectGroupService(IProtectGroupService protectGroupService) {
        this.protectGroupService = protectGroupService;
    }

    public ITopoResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ITopoResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setTopoBuilderManager(ITopoBuilderManager topoBuilderManager) {
        this.topoBuilderManager = topoBuilderManager;
    }

    public ITopoBuilderManager getTopoBuilderManager() {
        return this.topoBuilderManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> createGlobalTopo() {
        ElementBox box = new ElementBox();
        ElementBox layout = this.getLayoutBox("1000001");
        List<String> results = null;
        try {
            List protectGroups = this.protectGroupService.getAllProtectGroupBasicInfo(Long.valueOf(this.userId), false, true, false);
            TopoContext context = null;
            if (null != protectGroups) {
                context = this.buildTopoForAllProtectGroups(box, layout, protectGroups);
            }
            this.setGlobalTopoLayout(context);
            results = new ArrayList<String>();
            results.add("success");
            String legendBoxStr = new TopoLegendBuilder().getLegendBoxString(box);
            results.add(new XMLSerializer((DataBox)box).serializeCommon());
            results.add(legendBoxStr);
            results.add(String.valueOf(layout.getClient(USEFUL)));
            results.add(this.getClusterFlag(context));
            results.add(this.getVisWWNMap(context));
            results.add(this.getVisTakeBackWWNMap(context));
            results.add(this.getVisNodeMap(context));
        }
        catch (LegoCheckedException exception) {
            this.logger.error((Object)"Get global topo failed. ", (Throwable)exception, 90160758787071L);
            results = this.getErrorResults(exception.getErrorCode());
        }
        catch (Exception exception) {
            this.logger.error((Object)("Get global topo failed. " + ExceptionUtil.getErrorMessage((Throwable)exception)), 90160758787071L);
            results = this.getErrorResults(-1L);
        }
        finally {
            TopoContext.setCurrentTopoContext(null);
        }
        return results;
    }

    private TopoContext buildTopoForAllProtectGroups(ElementBox box, ElementBox layout, List<ProtectGroup> protectGroups) {
        TopoContext context = null;
        Map<String, Long> poNumMap = this.getPoNumMap();
        for (ProtectGroup protectGroup : protectGroups) {
            try {
                int type = protectGroup.getTemplate().getType();
                if (this.checkProtectGroup(protectGroup, poNumMap) || !this.checkPgLicense(protectGroup)) continue;
                ITopoBuilder builder = null;
                int poType = protectGroup.getPoType();
                builder = poType == 12 ? this.topoBuilderManager.getTopoBuilder("Global-Topology-" + type + "-" + poType) : this.topoBuilderManager.getTopoBuilder("Global-Topology-" + type);
                if (builder == null) continue;
                if (context == null) {
                    context = new TopoContext(this.topoBuilderManager, protectGroup, box);
                    context.setProtectGroupService(this.protectGroupService);
                    context.setSiteService(this.siteService);
                    context.setStorageService(this.storageService);
                    context.setReplicaService(this.replicaService);
                    context.setTopoService(this.topoService);
                    context.setStorageResourceService(this.storageResourceService);
                } else {
                    context = new TopoContext(context, protectGroup);
                }
                context.bind((Object)"layout", (Object)layout);
                TopoContext.setCurrentTopoContext((TopoContext)context);
                builder.buildTopo(context);
            }
            catch (Exception e) {
                this.logger.error((Object)("buildTopoForAllProtectGroups failed. PgId: " + protectGroup.getUuid() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
        return context;
    }

    private boolean checkPgLicense(ProtectGroup protectGroup) {
        try {
            this.licenseControl.checkEnablePgTopo(protectGroup);
        }
        catch (Exception e) {
            this.logger.debug((Object)("checkPgLicense failed. PgId: " + protectGroup.getUuid() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return false;
        }
        return true;
    }

    private Map<String, Long> getPoNumMap() {
        HashMap<String, Long> poNumMap = new HashMap<String, Long>();
        String hql = "select protectGroup.pgId, count(poId) from ProtectObject group by protectGroup.pgId";
        try {
            List listResult = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, null);
            for (Object eachStatus : listResult) {
                Object[] objArr;
                if (!(eachStatus instanceof Object[]) || (objArr = (Object[])eachStatus).length != 2) continue;
                String pgId = (String)objArr[0];
                long lNum = (Long)objArr[1];
                poNumMap.put(pgId, lNum);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("getPoNumMap failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return poNumMap;
    }

    private String getClusterFlag(TopoContext context) {
        if (context == null) {
            return "false";
        }
        return String.valueOf(context.isVisCluster());
    }

    private String getVisWWNMap(TopoContext context) {
        StringBuilder builder = new StringBuilder();
        if (context == null) {
            return builder.toString();
        }
        Map visWWNMaps = context.getVisWWNMaps();
        for (Map.Entry eachEntry : visWWNMaps.entrySet()) {
            builder.append((String)eachEntry.getKey());
            builder.append("---");
            builder.append((String)eachEntry.getValue());
            builder.append(";");
        }
        String mapStr = builder.toString();
        if (mapStr == null || mapStr.isEmpty()) {
            return mapStr;
        }
        return mapStr.substring(0, mapStr.length() - 1);
    }

    private String getVisTakeBackWWNMap(TopoContext context) {
        StringBuilder builder = new StringBuilder();
        if (context == null) {
            return builder.toString();
        }
        Map visWWNMaps = context.getVisTakeBackNodeIdMaps();
        for (Map.Entry eachEntry : visWWNMaps.entrySet()) {
            builder.append((String)eachEntry.getKey());
            builder.append("---");
            builder.append((String)eachEntry.getValue());
            builder.append(";");
        }
        String mapStr = builder.toString();
        if (mapStr == null || mapStr.isEmpty()) {
            return mapStr;
        }
        return mapStr.substring(0, mapStr.length() - 1);
    }

    private String getVisNodeMap(TopoContext context) {
        StringBuilder builder = new StringBuilder();
        if (context == null) {
            return builder.toString();
        }
        Map visNodeIdMaps = context.getVisNodeIdMaps();
        if (visNodeIdMaps == null || visNodeIdMaps.isEmpty()) {
            return builder.toString();
        }
        for (Map.Entry eachEntry : visNodeIdMaps.entrySet()) {
            builder.append((String)eachEntry.getKey());
            builder.append("+++");
            builder.append((String)eachEntry.getValue());
            builder.append(";");
        }
        return builder.toString();
    }

    private boolean checkProtectGroup(ProtectGroup protectGroup, Map<String, Long> poNumMap) {
        if (protectGroup.isInvalid()) {
            long poNum = 0L;
            if (poNumMap.containsKey(protectGroup.getUuid())) {
                poNum = poNumMap.get(protectGroup.getUuid());
            }
            if (poNum == 0L) {
                this.logger.error((Object)("Po is empty, PgName: " + protectGroup.getName()), 90160758786962L);
                return true;
            }
            String recoveryPlanId = this.recoveryPlanService.getAssociatedRecoveryPlanWithProtectGroup(protectGroup.getUuid());
            if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
                return false;
            }
            RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlan(recoveryPlanId, false, false);
            if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
                this.logger.error((Object)("recoveryPlan is null, PgName: " + protectGroup.getName()), 90160758786962L);
                return true;
            }
            int recoveryPlanStatus = recoveryPlan.getPlanStatus();
            if (RECOVERY_PLAN_STATUS_LIST.contains(recoveryPlanStatus)) {
                this.logger.error((Object)("recoveryPlan is completed, PgName: " + protectGroup.getName()), 90160758786962L);
                return true;
            }
        }
        return false;
    }

    private void setGlobalTopoLayout(TopoContext context) {
        if (context == null) {
            this.logger.debug((Object)"topoContext is null,not set setGlobalTopoLayout.");
            return;
        }
        ElementBox layout = (ElementBox)context.find((Object)"layout");
        if (layout == null) {
            return;
        }
        String isUseSaved = String.valueOf(layout.getClient(USEFUL));
        if (Boolean.valueOf(isUseSaved).booleanValue()) {
            return;
        }
        layout.setClient(USEFUL, (Object)true);
        List visNodeIds = context.getVisNodeIds();
        if (!visNodeIds.isEmpty()) {
            this.setVisGlobalTopoLayout(context);
        } else {
            this.setReplicationGlobalTopoLayout(context);
        }
    }

    private void setVisGlobalTopoLayout(TopoContext context) {
        Node hostNode;
        List hostNodeIds = context.getHostNodeIds();
        List storageNodeIds = context.getStorageNodeIds();
        List visNodeIds = context.getVisNodeIds();
        Map visNodeIdMaps = context.getVisNodeIdMaps();
        Map visSiteNodeIdMaps = context.getVisSiteMapList();
        ArrayList<String> visArrayNodeIds = new ArrayList<String>();
        int hostNodeNum = hostNodeIds.size();
        int storageNodeNum = storageNodeIds.size();
        int visNodeNum = visNodeIds.size();
        double maxNum = Math.max(Math.max((double)hostNodeNum / 2.0, (double)visNodeNum), (double)storageNodeNum);
        ElementBox box = context.getElementBox();
        this.locateHostNode(hostNodeIds, hostNodeNum, maxNum, box);
        double visi = (maxNum - (double)visNodeNum) / 2.0;
        double storagei = (maxNum - (double)storageNodeNum) / 2.0;
        double nodeStorageY = 500.0;
        boolean isResetArrayY = true;
        for (String nodeId : visNodeIds) {
            Node slaveNode;
            hostNode = (Node)box.getElementByID((Object)nodeId);
            if (hostNode == null) continue;
            hostNode.setLocation(300.0 + 200.0 * visi, 300.0);
            String slaveNodeId = (String)visNodeIdMaps.get(nodeId);
            if (slaveNodeId != null && (slaveNode = (Node)box.getElementByID((Object)slaveNodeId)) != null) {
                slaveNode.setLocation(300.0 + 200.0 * visi, 400.0);
                if (isResetArrayY) {
                    isResetArrayY = false;
                    nodeStorageY = 600.0;
                }
            }
            visi += 1.0;
            storagei = this.locateVisArray(visSiteNodeIdMaps, visArrayNodeIds, box, storagei, nodeStorageY, nodeId);
        }
        for (String nodeId : storageNodeIds) {
            if (visArrayNodeIds.contains(nodeId) || (hostNode = (Node)box.getElementByID((Object)nodeId)) == null) continue;
            hostNode.setLocation(300.0 + 200.0 * storagei, nodeStorageY);
            storagei += 1.0;
        }
        List serverNodeIds = context.getServerNodeIds();
        this.locateServerNode(serverNodeIds, maxNum, box);
    }

    private void locateServerNode(List<String> serverNodeIds, double maxNum, ElementBox box) {
        if (VerifyUtil.isEmpty(serverNodeIds)) {
            return;
        }
        int serverNodeNum = serverNodeIds.size();
        double i = (maxNum - (double)serverNodeNum / 2.0) / 2.0;
        for (String nodeId : serverNodeIds) {
            Node serverNode;
            if ((double)serverNodeNum > 2.0) {
                serverNode = (Node)box.getElementByID((Object)nodeId);
                if (serverNode == null) continue;
                serverNode.setLocation(300.0 + 100.0 * i, 700.0);
                i += 1.0;
                continue;
            }
            serverNode = (Node)box.getElementByID((Object)nodeId);
            if (serverNode == null) continue;
            serverNode.setLocation(300.0 + 200.0 * i, 700.0);
            i += 1.0;
        }
    }

    private void locateHostNode(List<String> hostNodeIds, int hostNodeNum, double maxNum, ElementBox box) {
        double i = (maxNum - (double)hostNodeNum / 2.0) / 2.0;
        for (String nodeId : hostNodeIds) {
            Node hostNode;
            if ((double)hostNodeNum > 2.0) {
                hostNode = (Node)box.getElementByID((Object)nodeId);
                if (hostNode == null) continue;
                hostNode.setLocation(300.0 + 100.0 * i, 100.0);
                i += 1.0;
                continue;
            }
            hostNode = (Node)box.getElementByID((Object)nodeId);
            if (hostNode == null) continue;
            hostNode.setLocation(300.0 + 200.0 * i, 100.0);
            i += 1.0;
        }
    }

    private double locateVisArray(Map<String, List<String>> visSiteNodeIdMaps, List<String> visArrayNodeIds, ElementBox box, double storagei, double nodeStorageY, String nodeId) {
        List<String> arrayIds = visSiteNodeIdMaps.get(nodeId);
        if (arrayIds != null) {
            for (String arrayId : arrayIds) {
                visArrayNodeIds.add(arrayId);
                Node arrayNode = (Node)box.getElementByID((Object)arrayId);
                if (null != arrayNode) {
                    arrayNode.setLocation(300.0 + 200.0 * storagei, nodeStorageY);
                }
                storagei += 1.0;
            }
        }
        return storagei;
    }

    private void setReplicationGlobalTopoLayout(TopoContext context) {
        Node hostNode;
        List hostNodeIds = context.getHostNodeIds();
        List storageNodeIds = context.getStorageNodeIds();
        List serverNodeIds = context.getServerNodeIds();
        ElementBox box = context.getElementBox();
        double i = 0.0;
        for (String nodeId : hostNodeIds) {
            hostNode = (Node)box.getElementByID((Object)nodeId);
            if (hostNode == null) continue;
            hostNode.setLocation(300.0 + 200.0 * i, 100.0);
            i += 1.0;
        }
        i = 0.0;
        for (String nodeId : storageNodeIds) {
            hostNode = (Node)box.getElementByID((Object)nodeId);
            if (hostNode == null) continue;
            hostNode.setLocation(300.0 + 200.0 * i, 300.0);
            i += 1.0;
        }
        i = 0.0;
        for (String nodeId : serverNodeIds) {
            hostNode = (Node)box.getElementByID((Object)nodeId);
            if (hostNode == null) continue;
            hostNode.setLocation(300.0 + 200.0 * i, 500.0);
            i += 1.0;
        }
    }

    private List<String> getErrorResults(long code) {
        ArrayList<String> results = new ArrayList<String>();
        results.add("error");
        results.add(this.resourceManager.getText("ism.drm.topo.err.msg.title"));
        results.add(this.resourceManager.getErrText("lego.err." + code));
        results.add("false");
        results.add("false");
        results.add("");
        results.add("");
        results.add("");
        return results;
    }

    private ElementBox getLayoutBox(String topoIndexId) {
        ElementBox layout = new ElementBox();
        String topoXml = this.getLayoutXml(topoIndexId);
        Point center = new Point();
        AtomicInteger count = new AtomicInteger();
        layout.setClient(CENTER, (Object)center);
        layout.setClient(COUNT, (Object)count);
        layout.setClient(USEFUL, (Object)false);
        if (topoXml == null || topoXml.isEmpty()) {
            return layout;
        }
        XMLSerializer serializer = new XMLSerializer((DataBox)layout);
        serializer.deserializeXML(topoXml);
        for (Object data : layout.getDatas()) {
            if (!(data instanceof Group)) continue;
            Group group = (Group)data;
            Point2D location = group.getLocation();
            double v = count.getAndIncrement();
            double x = (center.getX() * v + location.getX()) / (v + 1.0);
            double y = (center.getY() * v + location.getY()) / (v + 1.0);
            center.setLocation(x, y);
        }
        return layout;
    }

    protected String getLayoutXml(String topoIndexId) {
        String info = null;
        try {
            Topo topoInfo = (Topo)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Topo.class, (Serializable)((Object)topoIndexId));
            if (topoInfo != null) {
                info = topoInfo.getTopoDetail();
            }
        }
        catch (DataAccessException ex) {
            this.logger.error((Object)"unable to get sites", (Throwable)ex, 90160758786873L);
        }
        return info;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }
}

