/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.poll;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class SitePollTask
implements Runnable {
    private static final Log logger = LogFactory.getInstance(SitePollTask.class);
    private static final long SLEEP_INTERVAL_TIME = 30000L;
    private static final long DEFAULT_CONN_CHECK_INTERVAL = 120000L;
    private static final int DEFAULT_CONN_CHECK_NUM = 4;
    private boolean cycle = true;
    private int sleepNum = 4;
    private long connCheckIntervalTime = 120000L;

    @Override
    public void run() {
        CommUtil.pauseThread((long)120000L);
        while (this.cycle) {
            try {
                List siteList = new ArrayList();
                try {
                    String hql = "from Site as st where st.siteType = 1 order by st.name asc";
                    siteList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[0]);
                }
                catch (DataAccessException ex) {
                    logger.error((Object)"unable to get sites", (Throwable)ex, 90160758786873L);
                }
                for (Site eachSite : siteList) {
                    try {
                        ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).refreshSite(eachSite);
                    }
                    catch (Exception e) {
                        logger.error((Object)("sitePoller pollResource error. Site name:" + eachSite.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                    }
                }
            }
            catch (Throwable e) {
                logger.error((Object)("sitePoller pollResource error. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            try {
                for (int i = 0; i < this.sleepNum && this.cycle; ++i) {
                    CommUtil.pauseThread((long)30000L);
                }
            }
            catch (Exception e) {
                logger.error((Object)("sitePoller sleep error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }
    }

    public long getConnCheckIntervalTime() {
        return this.connCheckIntervalTime;
    }

    public void setConnCheckIntervalTime(long connCheckIntervalTime) {
        try {
            this.connCheckIntervalTime = connCheckIntervalTime;
            this.sleepNum = (int)(connCheckIntervalTime / 30000L);
        }
        catch (Exception e) {
            this.connCheckIntervalTime = 120000L;
            this.sleepNum = 4;
            logger.error((Object)("setConnCheckIntervalTime error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
    }
}

