/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array;

import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.port.sdk.model.ManagementPort;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.discover.array.V1RunningStateMapper;
import com.huawei.ism.common.entity.components.Array;
import com.huawei.ism.common.entity.components.Initiator;
import com.huawei.ism.common.entity.components.Port;
import com.huawei.ism.common.entity.hosts.Host;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ArrayDiscoverUtil {
    private static final Log LOGGER = LogFactory.getInstance(ArrayDiscoverUtil.class);

    public static List<com.huawei.ism.base.sdk.model.Initiator> getInitiators(Array array, StorageUnit unit) {
        HashMap<Integer, Host> hostMap = new HashMap<Integer, Host>();
        for (Host host : array.getHosts()) {
            hostMap.put(host.getHostId(), host);
        }
        ArrayList<com.huawei.ism.base.sdk.model.Initiator> v2Initiators = new ArrayList<com.huawei.ism.base.sdk.model.Initiator>();
        ArrayList v1Initiators = new ArrayList();
        v1Initiators.addAll(array.getFcHostPorts());
        v1Initiators.addAll(array.getIscsiHostPorts());
        v1Initiators.addAll(array.getSasHostPorts());
        for (Initiator v1Initiator : v1Initiators) {
            com.huawei.ism.base.sdk.model.Initiator initiator = ArrayDiscoverUtil.transitionInitiator(v1Initiator);
            if (v1Initiator instanceof Port) {
                Port port = (Port)v1Initiator;
                Host host = (Host)hostMap.get(port.getHostId());
                if (host != null) {
                    initiator.setHostUUID(host.getUUID());
                }
                initiator.setUuid(port.getUUID());
            }
            initiator.setParentMo((ManagedObject)unit);
            unit.addChildMo((ManagedObject)initiator);
            v2Initiators.add(initiator);
        }
        return v2Initiators;
    }

    public static com.huawei.ism.base.sdk.model.Initiator transitionInitiator(Initiator v1Initiator) {
        com.huawei.ism.base.sdk.model.Initiator initiator = new com.huawei.ism.base.sdk.model.Initiator();
        initiator.setAlias(v1Initiator.getAlias());
        initiator.setName(v1Initiator.getIdentity());
        initiator.setIdentity(v1Initiator.getIdentity());
        initiator.setHbaType(v1Initiator.getProtocolType().name());
        initiator.setStatus(Integer.valueOf(0));
        initiator.setHealthStatus(Integer.valueOf(0));
        if (v1Initiator.getLinkState() != null) {
            LOGGER.debug((Object)"linkState is not null!");
            initiator.setRunningStatus(V1RunningStateMapper.V1_INITIATOR_STATE.get(v1Initiator.getLinkState()));
        }
        return initiator;
    }

    public static void setControllerIp(Map<String, List<ManagementPort>> managePortsMap, Map<String, Controller> controllersIDMap, boolean isIpv4) {
        Set<Map.Entry<String, List<ManagementPort>>> entrys = managePortsMap.entrySet();
        for (Map.Entry<String, List<ManagementPort>> entry : entrys) {
            Controller controller = controllersIDMap.get(entry.getKey());
            List<ManagementPort> ports = entry.getValue();
            if (VerifyUtil.isEmpty(ports) || null == controller) {
                LOGGER.debug((Object)("ports:" + ports));
                continue;
            }
            StringBuilder ipsBuffer = new StringBuilder();
            for (ManagementPort port : ports) {
                String ip = isIpv4 ? port.getIpAddress() : port.getIpv6Address();
                if (ip == null || ip.length() < 1) continue;
                ipsBuffer.append(ip).append(",");
            }
            String ips = "";
            if (ipsBuffer.length() > 0) {
                ips = ipsBuffer.substring(0, ipsBuffer.length() - 1);
            }
            if (isIpv4) {
                controller.setManageIpAddrs(ips);
                continue;
            }
            controller.setIpv6Address(ips);
        }
    }

    public static double getMappedLunCap(List<XveLun> xveLuns) {
        double mappedCap = 0.0;
        if (VerifyUtil.isEmpty(xveLuns)) {
            LOGGER.debug((Object)"xveLuns is null");
            return mappedCap;
        }
        for (XveLun lun : xveLuns) {
            if (!lun.getMapped().booleanValue()) continue;
            mappedCap += lun.getTotalCapacity().doubleValue();
        }
        return mappedCap;
    }

    public static double getTotalLunCap(List<XveLun> xveLuns) {
        double totalCap = 0.0;
        if (VerifyUtil.isEmpty(xveLuns)) {
            LOGGER.debug((Object)"xveLuns is null.");
            return totalCap;
        }
        for (XveLun lun : xveLuns) {
            totalCap += lun.getTotalCapacity().doubleValue();
        }
        return totalCap;
    }
}

