/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.transition;

import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.base.sdk.model.HSObject;
import com.huawei.ism.cbb.discover.array.V1HealthStateMapper;
import com.huawei.ism.cbb.discover.array.V1RunningStateMapper;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.ism.common.entity.components.Cache;
import com.huawei.ism.common.entity.components.ManagementPort;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;

public class ControllerTransition
implements ITransition {
    private Log logger = LogFactory.getInstance((Object)this);

    @Override
    public Object convertToV1(HSObject ismObj) {
        return null;
    }

    @Override
    public HSObject convertToV2(Object v1Obj) {
        Controller ismCtl = null;
        if (v1Obj instanceof com.huawei.ism.common.entity.components.Controller) {
            Integer runningStatus;
            ismCtl = new Controller();
            com.huawei.ism.common.entity.components.Controller ctl = (com.huawei.ism.common.entity.components.Controller)v1Obj;
            ismCtl.setIsMaster(Boolean.valueOf(ctl.isMaster()));
            ismCtl.setLogicalVersion(ctl.getLogicalVersion());
            ismCtl.setPcbVersion(ctl.getPCBVersion());
            ismCtl.setSesVersion(ctl.getSesVersion());
            ismCtl.setSystemVersion(ctl.getSystemSoftwareVersion());
            ismCtl.setTime(Long.valueOf(ctl.getTime()));
            ismCtl.setName(ctl.getName());
            ismCtl.setDevSn(ctl.getDeviceID());
            ismCtl.setControllerId(String.valueOf(ctl.getControllerId()));
            ismCtl.setChassisId(ctl.getChassisId());
            Integer healthStatus = V1HealthStateMapper.V1_CONTROLLER_HEALTH_STATE.get(ctl.getHealthState());
            if (null == healthStatus) {
                this.logger.error((Object)("Unknown v1 Controller health state : " + ctl.getHealthState().getDescription()), 90160777658624L);
                healthStatus = 4;
            }
            ismCtl.setStatus(healthStatus);
            ismCtl.setHealthStatus(healthStatus);
            if (!VerifyUtil.isEmpty((Collection)ctl.getIps())) {
                ismCtl.setManageIpAddrs(StringUtil.arrayToStrWithSplit((Object[])ctl.getIps().toArray(), (String)","));
            }
            this.setIpV6Address(ismCtl, ctl);
            ismCtl.setUuid(ctl.getUUID());
            Cache cache = ctl.getCache();
            if (cache != null) {
                ismCtl.setCacheSize(NumberUtil.convertToDouble((Object)cache.getCacheSize()));
                ismCtl.setCacheSizeUnit(CapabilityUnitType.MB.name());
            }
            if ((runningStatus = V1RunningStateMapper.V1_CONTROLLER_RUNNING_STATE.get(ctl.getRunningState())) != null) {
                ismCtl.setRunningStatus(runningStatus);
            } else {
                ismCtl.setRunningStatus(Integer.valueOf(4));
            }
            if (null != ctl.getControllerType()) {
                ismCtl.setControllerType(ctl.getControllerType().toString());
                ismCtl.setName(ismCtl.getControllerType());
            }
        }
        return ismCtl;
    }

    private void setIpV6Address(Controller ismCtl, com.huawei.ism.common.entity.components.Controller ctl) {
        Collection managementPorts = ctl.getManagementPorts();
        if (!VerifyUtil.isEmpty((Collection)managementPorts)) {
            ArrayList<String> managedIpv6Addresses = new ArrayList<String>();
            for (ManagementPort managementPort : managementPorts) {
                if (null == managementPort.getPortLogicType() || VerifyUtil.isEmpty((String)managementPort.getIPV6()) || managementPort.getPortLogicType() != TypeEnum.PortLogicType.Management && managementPort.getPortLogicType() != TypeEnum.PortLogicType.ManageService) continue;
                managedIpv6Addresses.add(managementPort.getIPV6());
            }
            String ipv6Addresses = StringUtil.arrayToStrWithSplit((Object[])managedIpv6Addresses.toArray(), (String)",");
            if (!VerifyUtil.isEmpty((String)ipv6Addresses)) {
                ismCtl.setIpv6Address(ipv6Addresses);
            }
        }
    }

    @Override
    public String getSmisType() {
        return "ISM_Controller";
    }

    @Override
    public Class<?> getV1Type() {
        return com.huawei.ism.common.entity.components.Controller.class;
    }

    @Override
    public Class<?> getV2Type() {
        return Controller.class;
    }
}

