/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.transition;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.LunMapping;
import com.huawei.ism.base.sdk.model.HSObject;
import com.huawei.ism.cbb.discover.array.V1HealthStateMapper;
import com.huawei.ism.cbb.discover.array.V1RunningStateMapper;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.common.entity.State;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.ism.common.entity.components.ExpandedLun;
import com.huawei.ism.common.entity.components.Mapping;
import com.huawei.ism.common.util.CommonServiceUtils;
import java.util.ArrayList;
import java.util.Collection;

public class LunTransition
implements ITransition {
    @Override
    public Object convertToV1(HSObject ismObj) {
        com.huawei.ism.common.entity.components.Lun v1Lun = null;
        if (ismObj instanceof Lun) {
            Lun v2Lun = (Lun)ismObj;
            v1Lun = new com.huawei.ism.common.entity.components.Lun(v2Lun.getDevSn());
            v1Lun.setComponentName(v2Lun.getName());
            v1Lun.setUUID(v2Lun.getUuid());
            v1Lun.setLunId(NumberUtil.convertToInteger((Object)v2Lun.getLunId()).intValue());
            v1Lun.setLunWWN(v2Lun.getWwn());
            v1Lun.setTotalSize(v2Lun.getTotalCapacity().doubleValue());
            v1Lun.setReadPolicy(TypeEnum.PrefetchPolicyType.getPrefetchType((int)v2Lun.getReadPolicy()));
            v1Lun.setWritePolicy(TypeEnum.WritePolicyType.getWritePolicy((int)v2Lun.getWritePolicy()));
            v1Lun.setWormAble(State.BooleanState.getBooleanState((int)v2Lun.getWormable()));
            v1Lun.setWormState(State.WormState.getWormState((int)v2Lun.getWormState()));
            v1Lun.setMappingLunId(v2Lun.getMapId().intValue());
            v1Lun.setExtendedCapacity(v2Lun.getExtendedCapacity().longValue());
            v1Lun.setHypermirrorID(v2Lun.getReplicationPairId());
            v1Lun.setOwnerController(TypeEnum.ControllerType.getController((long)NumberUtil.convertToLong((Object)v2Lun.getControllerId())));
        }
        return v1Lun;
    }

    @Override
    public HSObject convertToV2(Object v1Obj) {
        Lun ismLun = null;
        if (v1Obj instanceof com.huawei.ism.common.entity.components.Lun) {
            com.huawei.ism.common.entity.components.Lun lun = (com.huawei.ism.common.entity.components.Lun)v1Obj;
            String uuid = lun.getUUID();
            String deviceId = lun.getDeviceID();
            String name = lun.getName();
            int lunId = lun.getLunId();
            double capacity = lun.getTotalSize();
            boolean isMapped = lun.isMapped();
            ismLun = new Lun();
            ismLun.setDevSn(deviceId);
            ismLun.setTotalCapacity(Double.valueOf(capacity));
            ismLun.setTotalCapacityUnit(CapabilityUnitType.MB.name());
            ismLun.setName(name);
            ismLun.setUuid(uuid);
            ismLun.setCanextendCapacity(Long.valueOf(lun.getCanExtendCapacity()));
            ismLun.setExtendedCapacity(Long.valueOf(lun.getExtendedCapacity()));
            ismLun.setHost(lun.getHost());
            ismLun.setHostGroup(lun.getHostGroup());
            ismLun.setWwn(lun.getLunWWN());
            ismLun.setLunId(String.valueOf(lunId));
            ismLun.setResourceType(Integer.valueOf(this.getLunType(lun)));
            ismLun.setRaidUuid(lun.getParentUUID());
            if (null != lun.getWritePolicy()) {
                ismLun.setWritePolicy(Integer.valueOf(TypeEnum.WritePolicyType.getValue((TypeEnum.WritePolicyType)lun.getWritePolicy())));
            }
            ismLun.setMapped(Boolean.valueOf(isMapped));
            Integer state = V1HealthStateMapper.V1_LUN_HEALTH_STATE.get(lun.getHealthState());
            if (state == null) {
                state = 4;
            }
            ismLun.setStatus(state);
            ismLun.setMapId(Integer.valueOf(lun.getMappingLunId()));
            if (null != lun.getReadPolicy()) {
                ismLun.setReadPolicy(Integer.valueOf(lun.getReadPolicy().getValue()));
            }
            ismLun.setWormable(Integer.valueOf(lun.getWormAble().getValue()));
            ismLun.setWormState(Integer.valueOf(lun.getWormState().getValue()));
            ismLun.setMirror(Boolean.valueOf(lun.isMirror()));
            ismLun.setReplicationPairId(lun.getHypermirrorID());
            if (lun.getController() != null) {
                ismLun.setControllerId(String.valueOf(TypeEnum.ControllerType.getValue((TypeEnum.ControllerType)lun.getController())));
            }
            this.setLunStatus(ismLun, lun);
            this.setLunMapping(ismLun, lun.getLunMappingObjects(), lunId);
        }
        return ismLun;
    }

    private void setLunStatus(Lun ismLun, com.huawei.ism.common.entity.components.Lun lun) {
        Integer healthStatus = V1HealthStateMapper.V1_LUN_HEALTH_STATE.get(lun.getHealthState());
        if (null == healthStatus) {
            healthStatus = 4;
        }
        ismLun.setStatus(healthStatus);
        ismLun.setHealthStatus(String.valueOf(healthStatus));
        Integer runningStatus = V1RunningStateMapper.V1_LUN_RUNNING_STATE.get(lun.getRunningState());
        if (null == runningStatus) {
            runningStatus = 4;
        }
        ismLun.setRunningStatus(String.valueOf(runningStatus));
    }

    private void setLunMapping(Lun lun, Collection<Mapping> v1LunMappings, int lunId) {
        if (VerifyUtil.isEmpty(v1LunMappings)) {
            return;
        }
        ArrayList<LunMapping> v2LunMappingsList = new ArrayList<LunMapping>();
        for (Mapping v1LunMapping : v1LunMappings) {
            if (lunId != v1LunMapping.getId()) continue;
            LunMapping v2LunMapping = new LunMapping();
            v2LunMapping.setMapType(Integer.valueOf(v1LunMapping.getMapType()));
            v2LunMapping.setHostOrHostGroupId(String.valueOf(v1LunMapping.getHostOrHostGroupID()));
            v2LunMapping.setLunUUID(lun.getUuid());
            v2LunMappingsList.add(v2LunMapping);
        }
        lun.setLunMappings(v2LunMappingsList);
    }

    private int getLunType(com.huawei.ism.common.entity.components.Lun lun) {
        if (lun instanceof ExpandedLun) {
            return 3;
        }
        if (CommonServiceUtils.isPrivateLun((com.huawei.ism.common.entity.components.Lun)lun)) {
            return 2;
        }
        if (lun.isThinLUN()) {
            return 4;
        }
        return 1;
    }

    @Override
    public String getSmisType() {
        return "ISM_StorageVolume";
    }

    @Override
    public Class<?> getV1Type() {
        return com.huawei.ism.common.entity.components.Lun.class;
    }

    @Override
    public Class<?> getV2Type() {
        return Lun.class;
    }
}

