/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.transition;

import com.huawei.ism.base.sdk.model.HSObject;
import com.huawei.ism.cbb.discover.array.V1HealthStateMapper;
import com.huawei.ism.cbb.discover.array.V1RunningStateMapper;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.common.bean.HealthState;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.ism.common.entity.components.Drive;
import com.huawei.ism.common.entity.components.HibernateSettings;
import com.huawei.ism.common.entity.components.RaidGroup;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Iterator;

public class RaidGroupTransition
implements ITransition {
    private Log logger = LogFactory.getInstance((Object)this);

    @Override
    public Object convertToV1(HSObject ismObj) {
        return null;
    }

    @Override
    public HSObject convertToV2(Object v1Obj) {
        com.huawei.ism.array.sdk.model.RaidGroup raidEntity = null;
        if (v1Obj instanceof RaidGroup) {
            Iterator iterator;
            RaidGroup raid = (RaidGroup)v1Obj;
            String deviceId = raid.getDeviceID();
            String raidName = raid.getName();
            String uuid = raid.getUUID();
            int raidGroupId = raid.getRaidGroupId();
            TypeEnum.RaidType raidLevel = raid.getRaidLevel();
            long totalSize = raid.getTotalSize();
            long remainSize = raid.getRemainSize();
            Integer healthStatus = V1HealthStateMapper.V1_RAIDGROUP_HEALTH_STATE.get(raid.getHealthState());
            if (null == healthStatus) {
                this.logger.error((Object)("Unknown v1 health state : " + raid.getHealthState().getDescription()), 90160777658643L);
                healthStatus = 4;
            }
            raidEntity = new com.huawei.ism.array.sdk.model.RaidGroup();
            raidEntity.setNeSN(deviceId);
            raidEntity.setPoolId(String.valueOf(raidGroupId));
            raidEntity.setRaidLevel(Integer.valueOf(raidLevel.getValue()));
            raidEntity.setName(raidName);
            Collection disks = raid.getDisks();
            if (disks != null && !disks.isEmpty() && (iterator = disks.iterator()).hasNext()) {
                Drive disk = (Drive)iterator.next();
                raidEntity.setDiskType(V1HealthStateMapper.V1_DISK_TYPE_STATE.get(disk.getPhysicalType()));
            }
            raidEntity.setTotalCapacity(NumberUtil.convertToDouble((Object)totalSize));
            raidEntity.setUsedCapacity(NumberUtil.convertToDouble((Object)(totalSize - remainSize)));
            raidEntity.setTotalCapacityUnit(CapabilityUnitType.MB.name());
            raidEntity.setUsedCapacityUnit(CapabilityUnitType.MB.name());
            raidEntity.setUuid(uuid);
            if (raid.isThinPool()) {
                raidEntity.setRaidType("ThinPool");
                long thinPoolVisibleSize = raid.getThinPoolVisibleSize();
                raidEntity.setThinPoolVisibleCapacity(NumberUtil.convertToDouble((Object)thinPoolVisibleSize));
                raidEntity.setThinPoolVisibleCapacityUnit(CapabilityUnitType.MB.name());
            } else {
                raidEntity.setRaidType("RaidGroup");
            }
            HibernateSettings hss = raid.getHibernateSettings();
            if (hss != null) {
                raidEntity.setHibernate(Boolean.valueOf(hss.isHibernate()));
            }
            if (null != raidEntity.getHibernate() && raidEntity.getHibernate().booleanValue()) {
                healthStatus = V1HealthStateMapper.V1_RAIDGROUP_HEALTH_STATE.get(HealthState.HIBERNATE);
            }
            raidEntity.setStatus(healthStatus);
            raidEntity.setHealthStatus(String.valueOf(healthStatus));
            Integer runningStatus = V1RunningStateMapper.V1_RAID_RUNNING_STATE.get(raid.getRunningState());
            if (null == runningStatus) {
                runningStatus = 4;
            }
            raidEntity.setRunningStatus(String.valueOf(runningStatus));
        }
        return raidEntity;
    }

    @Override
    public String getSmisType() {
        return "ISM_StoragePool";
    }

    @Override
    public Class<?> getV1Type() {
        return RaidGroup.class;
    }

    @Override
    public Class<?> getV2Type() {
        return com.huawei.ism.array.sdk.model.RaidGroup.class;
    }
}

