/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public final class OperationLock {
    private Log logger = LogFactory.getInstance((Object)this);
    private AtomicBoolean locked = new AtomicBoolean(false);
    private OpLock opLock = new OpLock(true);
    private volatile long holdTime = -1L;

    public void lock() {
        this.opLock.lock();
        this.holdTime = System.currentTimeMillis();
    }

    public void unLock() {
        if (this.opLock.isHeldByCurrentThread()) {
            this.holdTime = -1L;
            this.opLock.unlock();
        }
    }

    public boolean tryLock() {
        boolean lockResult = false;
        if (!this.locked.compareAndSet(false, true)) {
            return false;
        }
        try {
            lockResult = this.opLock.tryLock() || this.opLock.tryLock(30L, TimeUnit.MINUTES);
            this.holdTime = System.currentTimeMillis();
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"Exception : ", (Throwable)e, 90160758784000L);
        }
        finally {
            if (!lockResult) {
                this.locked.compareAndSet(true, false);
            }
        }
        return lockResult;
    }

    public void unTryLock() {
        if (this.opLock.isHeldByCurrentThread()) {
            this.holdTime = -1L;
            this.opLock.unlock();
            this.locked.compareAndSet(true, false);
        }
    }

    public long getHoldTime() {
        return this.holdTime;
    }

    public String getOwnerName() {
        Thread owner = this.opLock.getOwner();
        if (owner == null) {
            return "";
        }
        return String.valueOf(owner);
    }

    public void interrupt() {
        Thread owner = this.opLock.getOwner();
        if (owner != null) {
            owner.interrupt();
        }
    }

    private static class OpLock
    extends ReentrantLock {
        private static final long serialVersionUID = 5071393845016931820L;

        OpLock(boolean fair) {
            super(fair);
        }

        @Override
        protected Thread getOwner() {
            return super.getOwner();
        }
    }
}

