/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons.process;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BaseAntiBlackmailProcessor {
    private static final Log LOGGER = LogFactory.getInstance(BaseAntiBlackmailProcessor.class);
    private static final String OCEAN_PROTECT_FORM_TYPE = "Ocean Protect";
    private static final Set<Long> PASS_ERROR_CODE_SET = ImmutableSet.of((Object)1677929488L, (Object)1677929489L, (Object)1677929490L, (Object)1677929493L);

    protected boolean checkParam(AbstractContext context) {
        String action;
        switch (action = context.getAttribute("icommand:action", String.class)) {
            case "icommand:action:discovery": {
                return this.checkDiscoverParam(context);
            }
            case "icommand:action:poll": 
            case "icommand:action:refresh": {
                return this.checkPollOrRefreshParams(context);
            }
        }
        return false;
    }

    private boolean checkDiscoverParam(AbstractContext context) {
        DiscoveryPolicy discoveryPolicy = context.getAttribute("DiscoveryPolicy", DiscoveryPolicy.class);
        if (VerifyUtil.isEmpty((Object)discoveryPolicy) || !discoveryPolicy.getIsAirGapResource().booleanValue()) {
            LOGGER.info((Object)"No need to discover anti blackmail app.Device name: %s", new Object[]{VerifyUtil.isEmpty((Object)discoveryPolicy) ? "discovery policy is null" : discoveryPolicy.getDeviceName()});
            return false;
        }
        LOGGER.info((Object)"Discover anti blackmail applications on storage(ip: %s)", new Object[]{discoveryPolicy.getStartIP()});
        return this.checkCommonParams(context);
    }

    private boolean checkPollOrRefreshParams(AbstractContext context) {
        if (!this.checkCommonParams(context)) {
            return false;
        }
        if (context.getAttributeKeys().contains("manualRefreshKey")) {
            return true;
        }
        NeMgrProtocolExtend protocolExtend = context.getAttribute("NeMgrProtocolExtend", NeMgrProtocolExtend.class);
        Map extendParams = protocolExtend.getExtendParams();
        if (extendParams.containsKey("protectManagerPasswordError")) {
            NetworkEntity storageArray = context.getAttribute(this.getStorageKey(context), NetworkEntity.class);
            LOGGER.error((Object)"No need to poll or refresh caused by the failed discovery, dev sn: %s.", new Object[]{storageArray.getSn()});
            return false;
        }
        return true;
    }

    private boolean checkCommonParams(AbstractContext context) {
        NetworkEntity storageArray = context.getAttribute(this.getStorageKey(context), NetworkEntity.class);
        if (VerifyUtil.isEmpty((Object)storageArray)) {
            LOGGER.error((Object)"StorageArray is not in the context.");
            return false;
        }
        NeMgrProtocolExtend protocolExtend = context.getAttribute("NeMgrProtocolExtend", NeMgrProtocolExtend.class);
        if (VerifyUtil.isEmpty((Object)protocolExtend)) {
            LOGGER.error((Object)"Management protocol info is not in the context.");
            return false;
        }
        Optional<String> platformTypeOptional = this.getPlatformType(context);
        if (!platformTypeOptional.isPresent()) {
            LOGGER.info((Object)"Anti blackmail auth info is not configured on storage(ip: %s)", new Object[]{storageArray.getLinkIp()});
            return false;
        }
        return true;
    }

    protected Optional<RestConnection> getOrBuildConnection(AbstractContext context) {
        NetworkEntity storageArray = context.getAttribute(this.getStorageKey(context), NetworkEntity.class);
        String connectionType = this.getConnectionType(context).orElse(null);
        String key = storageArray.getSn() + connectionType;
        RestConnectionManager connectionManager = RestConnectionManager.getInstance();
        RestConnection connection = null;
        if (connectionManager.containsConnection(key)) {
            connection = connectionManager.getConnection(key);
        }
        if (!VerifyUtil.isEmpty(connection) && connection.isValid()) {
            return Optional.of(connection);
        }
        this.determineManagementIp(context);
        NeMgrProtocolExtend protocolExtend = context.getAttribute("NeMgrProtocolExtend", NeMgrProtocolExtend.class);
        connection = RestConnectionManager.getInstance().buildConnection(protocolExtend, connectionType);
        connection.setDeviceId(storageArray.getSn());
        try {
            connection.authenticate();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Build connection(ip: %s) failed due to auth error. error msg: %s.", new Object[]{protocolExtend.getNetworkIpAddress(), e.getMessage()});
            if (PASS_ERROR_CODE_SET.contains(e.getErrorCode())) {
                context.setAttribute("protectManagerPasswordError", true);
            }
            return Optional.empty();
        }
        RestConnectionManager.getInstance().setConnection(key, connection);
        return Optional.of(connection);
    }

    protected void sendScanResourceMessage(AbstractContext context) {
        MessageUnit messageUnit = new MessageUnit();
        messageUnit.setSourceAppName(this.getClass().getName());
        messageUnit.setCmdcode(8001L);
        HashMap<String, String> messageBody = new HashMap<String, String>();
        NetworkEntity networkEntity = context.getAttribute("StorageArray", NetworkEntity.class);
        messageBody.put("devSn", networkEntity.getSn());
        messageBody.put("connectionType", this.getConnectionType(context).orElse(null));
        messageUnit.setObj(messageBody);
        messageUnit.setMt(MessageTopic.COMMAND);
        IMessageCenter messageCenter = (IMessageCenter)ServiceLocator.getInstance().getService(IMessageCenter.class);
        messageCenter.sendMessage(messageUnit);
        LOGGER.info((Object)("Send scan resource message, sn=" + networkEntity.getSn() + ", uuid=" + networkEntity.getUuid()));
    }

    protected Optional<String> getPlatformType(AbstractContext context) {
        return this.getConnectionOrPlatformType(context, false);
    }

    private Optional<String> getConnectionType(AbstractContext context) {
        return this.getConnectionOrPlatformType(context, true);
    }

    private Optional<String> getConnectionOrPlatformType(AbstractContext context, boolean isConnectionType) {
        NeMgrProtocolExtend protocolExtend = context.getAttribute("NeMgrProtocolExtend", NeMgrProtocolExtend.class);
        Map extendParams = protocolExtend.getExtendParams();
        if (!VerifyUtil.isEmpty((Map)extendParams) && extendParams.containsKey("OceanProtectUsername")) {
            return isConnectionType ? Optional.of("oceanProtectConnection") : Optional.of(OCEAN_PROTECT_FORM_TYPE);
        }
        return Optional.empty();
    }

    private void determineManagementIp(AbstractContext context) {
        boolean isRefreshOrPoll = Optional.ofNullable(context.getAttribute("refreshOrPoll", Boolean.class)).orElse(false);
        if (!isRefreshOrPoll) {
            return;
        }
        List availableIps = context.getAttribute("AvailableIps", List.class);
        if (VerifyUtil.isEmpty((Collection)availableIps)) {
            return;
        }
        NeMgrProtocolExtend protocolExtend = context.getAttribute("NeMgrProtocolExtend", NeMgrProtocolExtend.class);
        String availableIp = Optional.ofNullable(availableIps.get(0)).map(String::valueOf).orElse(null);
        if (!VerifyUtil.isEmpty((String)availableIp) && !availableIp.equals(protocolExtend.getNetworkIpAddress())) {
            LOGGER.info((Object)"The management ip of antiBlackmail platform has changed, old ip: %s, new ip: %s.", new Object[]{protocolExtend.getNetworkIpAddress(), availableIp});
            protocolExtend.setNetworkIpAddress(availableIp);
        }
    }

    protected void triggerAuthErrorAlarm(NetworkEntity networkEntity) {
        String ip = networkEntity.getLinkIp();
        String[] alarmParams = new String[]{ip, networkEntity.getSn()};
        AlarmUtil.sendNetworkEntityAlarm((String)"0x3230064", (String)ip, (String)String.valueOf(networkEntity.getMoId()), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])alarmParams);
    }

    private String getStorageKey(AbstractContext context) {
        String action = context.getAttribute("icommand:action", String.class);
        if ("icommand:action:discovery".equals(action) || "icommand:action:refresh".equals(action)) {
            return "StorageArray";
        }
        return "StorageDevice";
    }
}

