/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons.process;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CheckDeviceProcessor
implements IProcessor {
    private Log logger = LogFactory.getInstance((Object)this);

    @Override
    public void clean(AbstractContext context) {
    }

    @Override
    public String getName() {
        return CheckDeviceProcessor.class.getSimpleName();
    }

    @Override
    public boolean process(AbstractContext context) {
        this.logger.info((Object)"Enter CheckDeviceProcessor ", 90160777658372L);
        NetworkEntity array = (NetworkEntity)context.getAttribute("StorageDevice");
        if (array == null) {
            this.logger.error((Object)"Can not get available device  !", 90160777658373L);
            return false;
        }
        this.validateSnForDiscovery(context, array);
        this.validateSnForRefreshOrPoll(context, array);
        this.validateLinkIp(array);
        this.logger.info((Object)"Exit CheckDeviceProcessor ", 90160777658372L);
        return true;
    }

    private void validateSnForRefreshOrPoll(AbstractContext context, NetworkEntity array) {
        if (VerifyUtil.isEmpty((Object)context.getAttribute("refreshOrPoll"))) {
            return;
        }
        NetworkEntity arrayInDB = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "sn", (Object)array.getSn());
        if (null == arrayInDB) {
            throw new LegoCheckedException(2117645L);
        }
    }

    private void validateSnForDiscovery(AbstractContext context, NetworkEntity array) {
        if (!VerifyUtil.isEmpty((Object)context.getAttribute("refreshOrPoll"))) {
            return;
        }
        NetworkEntity arrayInDb = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "sn", (Object)array.getSn());
        if (null != arrayInDb && array.getSn().equals(arrayInDb.getSn())) {
            throw new LegoCheckedException(127406L);
        }
        List find = CommonDAOLocator.getBaseDao().find("from DrResource where deviceSn=?", new Object[]{array.getSn()});
        if (!find.isEmpty()) {
            throw new LegoCheckedException(127406L);
        }
    }

    private void validateLinkIp(NetworkEntity array) {
        ArrayList<QueryCondition> props = new ArrayList<QueryCondition>();
        props.add(new QueryCondition("managedIps", (Object)array.getLinkIp()));
        List dataInDbList = CommonDAOLocator.getMoDao().findMoBy(NetworkEntity.class, props);
        if (VerifyUtil.isEmpty((Collection)dataInDbList)) {
            return;
        }
        block0: for (NetworkEntity ne : dataInDbList) {
            Object[] managerIps = ne.getManagedIps().split("\\,");
            if (VerifyUtil.isEmpty((Object[])managerIps)) continue;
            for (Object ip : managerIps) {
                if (!((String)ip).equals(array.getLinkIp())) continue;
                if (ne.getSn().equals(array.getSn())) continue block0;
                this.logger.error((Object)("The sn in db: " + ne.getSn() + ", new sn: " + array.getSn()), 90160777658373L);
                throw new LegoCheckedException(132432L);
            }
        }
    }

    @Override
    public void postProcess(AbstractContext context) {
    }
}

