/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons.process;

import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.array.sdk.model.XveStoragePool;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.base.util.MOUtil;
import com.huawei.ism.cbb.base.util.MOUtilCallBack;
import com.huawei.ism.cbb.discover.commons.process.SaveStorageDeviceTransactionCallback;
import com.huawei.ism.cbb.discover.commons.process.StorageMOUtilCallBack;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.framework.ISaveNetworkEntityExtender;
import com.huawei.ism.cbb.mediation.service.impl.NeMgrProtocolExtendServiceImpl;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.support.TransactionCallback;

public class SaveNetworkEntityProcessor
implements IProcessor {
    private Log logger = LogFactory.getInstance((Object)this);
    private ISaveNetworkEntityExtender saveStorageExtender;

    @Override
    public void clean(AbstractContext context) {
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean process(AbstractContext context) {
        Map<Long, Long> result;
        this.logger.info((Object)"Enter SaveNetworkEntityProcessor", 90160777658372L);
        NetworkEntity array = (NetworkEntity)context.getAttribute("StorageArray");
        if (array == null) {
            this.logger.error((Object)"Can not get retrieved device data !", 90160777658373L);
            throw new LegoCheckedException(0x200909L);
        }
        this.setVis6000TSubType(array);
        Object isIgnoreProcess = context.getAttribute("isIgnoreProcess");
        if (null != isIgnoreProcess && "true".equals(isIgnoreProcess.toString())) {
            return true;
        }
        NetworkEntity arrayInDB = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "sn", (Object)array.getSn());
        if (null != arrayInDB) {
            String oldArrayName = arrayInDB.getName();
            this.setSyncAlarmFlag(context, array, arrayInDB);
            array.setName(oldArrayName);
        }
        if (null == (result = this.saveStorageDeviceToDB(array, context))) {
            throw new LegoCheckedException(132416L);
        }
        this.saveLunInfo(context, array);
        this.saveExtendParamInfo(context, array);
        Object sendMsgFlag = context.getAttribute("DISCOVER_SEND_MESSAGE_FLAG");
        if (null == sendMsgFlag || Boolean.TRUE.equals(sendMsgFlag)) {
            this.sendMoMessages((ManagedObject)array, result);
        }
        return true;
    }

    private void saveLunInfo(AbstractContext context, NetworkEntity array) {
        List xveLuns = (List)context.getAttribute("XveLun");
        if (VerifyUtil.isEmpty((Collection)xveLuns)) {
            return;
        }
        this.logger.info((Object)("save Lun info, Lun size=" + xveLuns.size()), 90160777658372L);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        List storagePoolList = moDao.getMoList(XveStoragePool.class, "topMoUuid", (Object)array.getUuid());
        HashMap<String, XveStoragePool> poolMap = new HashMap<String, XveStoragePool>();
        for (XveStoragePool pool : storagePoolList) {
            pool.setChildMos(new HashSet());
            poolMap.put(pool.getPoolId(), pool);
        }
        for (XveLun xveLun : xveLuns) {
            XveStoragePool pool = (XveStoragePool)poolMap.get(xveLun.getStoragePoolId());
            if (null == pool) continue;
            xveLun.setParentMo((ManagedObject)pool);
            xveLun.setTopMoUuid(array.getUuid());
            moDao.saveOrUpdateMo((ManagedObject)xveLun);
        }
    }

    private void setVis6000TSubType(NetworkEntity array) {
        if (!VerifyUtil.isEmpty((String)array.getSubType()) && array.getSubType().equals("VIS6000T")) {
            array.setProductModel(array.getSubType());
        }
    }

    private void saveExtendParamInfo(AbstractContext context, NetworkEntity array) {
        NeMgrProtocolExtend extendParam = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        if (null != extendParam && ("icommand:action:discovery".equals(context.getAttribute("icommand:action")) || !array.getMoId().equals(extendParam.getMoId()))) {
            extendParam.setMoId(array.getMoId());
            NeMgrProtocolExtendServiceImpl extendService = new NeMgrProtocolExtendServiceImpl();
            extendService.save(extendParam);
        }
    }

    private void sendMoMessages(ManagedObject device, Map<Long, Long> result) {
        if (VerifyUtil.isEmpty(result)) {
            this.logger.info((Object)"No array data result ???", 90160777658372L);
            return;
        }
        try {
            MOUtil.traverseMo((ManagedObject)device, (MOUtilCallBack)new StorageMOUtilCallBack(result));
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
        }
    }

    private Map<Long, Long> saveStorageDeviceToDB(NetworkEntity array, AbstractContext context) {
        MOUtil.printMO((ManagedObject)array);
        Map result = (Map)CommonDAOLocator.getMoDao().getTransactionTemplate().execute((TransactionCallback)new SaveStorageDeviceTransactionCallback(array, context, this.saveStorageExtender));
        return result;
    }

    @Override
    public void postProcess(AbstractContext context) {
    }

    private void setSyncAlarmFlag(AbstractContext context, NetworkEntity newNetworkEntity, NetworkEntity oldNetworkEntity) {
        if (null == newNetworkEntity || null == oldNetworkEntity) {
            return;
        }
        if (-1 == oldNetworkEntity.getStatus() || !oldNetworkEntity.getLinkIp().equals(newNetworkEntity.getLinkIp())) {
            this.logger.info((Object)(" Set StatusSwitch to true ... need to sync unistor alarm , old link ip : " + oldNetworkEntity.getLinkIp() + " new link ip : " + newNetworkEntity.getLinkIp()), 90160777658372L);
            context.setAttribute("StatusSwitch", true);
        }
    }

    public void onBind(ISaveNetworkEntityExtender extender, Map<String, String> properties) {
        if ("ism.deviceType.storage.mainType".equals(extender.getNetworkEntityType())) {
            this.saveStorageExtender = extender;
        }
    }

    public void unBind(ISaveNetworkEntityExtender extender, Map<String, String> properties) {
        this.saveStorageExtender = null;
    }
}

