/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.framework;

import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.FilterChain;
import com.huawei.ism.cbb.discover.framework.IFilter;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class CommonTemplate
implements IProcessor {
    private final Log logger = LogFactory.getInstance((Object)this);
    private String name;
    private Set<String> deviceTypes;
    private List<IFilter> filters = new ArrayList<IFilter>();
    private List<IProcessor> processors = new ArrayList<IProcessor>();

    public CommonTemplate(String name, List<Object> processors) {
        if (name == null || processors == null || processors.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        int size = processors.size();
        int j = 0;
        for (int i = 0; i < size; ++i) {
            Object proc = processors.get(i);
            if (proc instanceof IFilter) {
                if (i > j) {
                    throw new IllegalArgumentException("Filter should be in the front !!!");
                }
                ++j;
                this.filters.add((IFilter)proc);
                continue;
            }
            if (proc instanceof IProcessor) {
                this.processors.add((IProcessor)proc);
                continue;
            }
            throw new IllegalArgumentException("Unrecoganized processor -> " + proc);
        }
    }

    public List<IProcessor> getProcessors() {
        return this.processors;
    }

    @Override
    public boolean process(AbstractContext context) {
        this.logger.debug((Object)("CommonTemplate <" + this.name + "> begin ..."));
        FilterChain chain = new FilterChain(this.filters, this.processors);
        try {
            chain.doFilter(context);
        }
        catch (LegoCheckedException le) {
            this.logger.error((Object)"process failure.", (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Exception raised : ", (long)0x200909L, null, (Log)this.logger);
        }
        this.logger.debug((Object)("CommonTemplate <" + this.name + "> end ..."));
        return chain.isResult();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Set<String> getDeviceTypes() {
        return this.deviceTypes;
    }

    public void setDeviceTypes(Set<String> deviceTypes) {
        this.deviceTypes = deviceTypes;
    }

    @Override
    public void clean(AbstractContext context) {
    }

    @Override
    public void postProcess(AbstractContext context) {
    }
}

