/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.poll;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.poll.IPollInitializer;
import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.poll.PollController;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.poll.PingPoller;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;

public final class DevicePingInitializer
implements IPollInitializer,
SystemStatusChangedListener {
    private Log logger = LogFactory.getInstance((Object)this);
    private IMoDao moDao;
    private PollController pollController;

    public DevicePingInitializer(IMoDao moDao, PollController pc) {
        this.moDao = moDao;
        this.pollController = pc;
    }

    public void initPoller() {
        this.logger.info((Object)"Initialize device ping poller ...", 90160777658624L);
        List networkEntitys = this.moDao.getAllMo(NetworkEntity.class);
        for (NetworkEntity networkEntity : networkEntitys) {
            if (!networkEntity.getIsTopMo().booleanValue() || networkEntity.getProductModel() == null || null != networkEntity.getParentMo()) continue;
            CommonTemplate template = CommonTemplateManager.getInstance().getTemplate(networkEntity, 4);
            if (template == null) {
                this.logger.error((Object)"template is null", 90160758784256L);
                continue;
            }
            PingPoller task = new PingPoller(networkEntity.getUuid(), networkEntity.getProductModel(), template);
            this.logger.info((Object)("Add device(name:" + networkEntity.getName() + ") to ping poller ..."), 90160777658624L);
            this.pollController.addPoller((IPoller)task);
        }
        this.logger.info((Object)"Initialize device ping poller complete.", 90160777658624L);
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (!Status.STATUS_STARTED.equals((Object)event.getStatus())) {
            return;
        }
        this.initPoller();
    }
}

