/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.service.impl;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.manager.proxy.ManagedObjectManagerProxy;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.sdk.service.IDiscoverService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

@Service(Name="com.huawei.ism.cbb.discover.sdk.service.IDiscoverService", Desc="", Interface=IDiscoverService.class)
public class DiscoverServiceImpl
extends IsmBaseService
implements IDiscoverService {
    private static final Log logger = LogFactory.getInstance(DiscoverServiceImpl.class);

    public void refreshStorage(StorageNE array, String userName) {
        BackTask bt = this.getBackTask(array, userName);
        CommonTemplate template = this.getCommonTemplate(array);
        this.startRefreshBackTask((NetworkEntity)array, bt, template);
        logger.info((Object)"Finish refresh storage.", 90160777658372L);
    }

    private CommonTemplate getCommonTemplate(StorageNE array) {
        CommonTemplate template = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType(array.getManagementProtocol());
        if (null == template) {
            logger.error((Object)("Can not find template, templateKey=" + array.getManagementProtocol()), 90160777658372L);
            throw new LegoCheckedException(127402L);
        }
        return template;
    }

    private BackTask getBackTask(StorageNE array, String userName) {
        if (null == array || VerifyUtil.isEmpty((String)userName)) {
            logger.error((Object)"Invalid parameters", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        logger.info((Object)("Start refresh storage, moid=" + array.getMoId() + " ; array.getLinkIp()=" + array.getLinkIp() + "; array=" + array), 90160777658372L);
        return BackTaskUtil.buildBackTask((String)array.getName(), (String)"ism.srm.array.refresh.operationName", (String)userName, (String)"", null);
    }

    private void startRefreshBackTask(final NetworkEntity ne, BackTask bt, final CommonTemplate template) {
        int timeout = ManagedObjectManagerProxy.getInstance().getMgr((ManagedObject)ne).getTimeout();
        AbstractBackTask task = new AbstractBackTask(ne.getUuid(), bt, timeout, true){

            protected void doWork() {
                RefreshContext context = new RefreshContext((ManagedObject)ne);
                context.setAttribute("refreshTask", (Object)this);
                context.setAttribute("manualRefreshKey", true);
                template.process(context);
            }
        };
        BackTaskHandler.getInstance().submitTask(task);
    }

    public String refreshSpecityResourceStorage(StorageNE array, String userName, int resourceType, String resourceID) {
        BackTask bt = this.getBackTask(array, userName);
        CommonTemplate template = this.getCommonTemplateForRefreshResource(array);
        this.startRefreshBackTask((NetworkEntity)array, bt, template, resourceType, resourceID);
        logger.info((Object)"Finish refresh Specity Resource storage storage MoId=%d, resourceType=%s, resourceID=%s", new Object[]{array.getMoId(), resourceType, resourceID});
        return String.valueOf(bt.getTaskId());
    }

    private void startRefreshBackTask(final NetworkEntity ne, BackTask bt, final CommonTemplate template, final int resourceType, final String resourceID) {
        int timeout = ManagedObjectManagerProxy.getInstance().getMgr((ManagedObject)ne).getTimeout();
        String taskId = ne.getUuid() + "_" + resourceType + "_" + resourceID;
        AbstractBackTask task = new AbstractBackTask(taskId, bt, timeout, true){

            protected void doWork() {
                RefreshContext context = new RefreshContext((ManagedObject)ne);
                context.setAttribute("refreshTask", (Object)this);
                context.setAttribute("refreshResourceType", resourceType);
                context.setAttribute("refreshResourceID", resourceID);
                template.process(context);
            }
        };
        BackTaskHandler.getInstance().submitTask(task);
    }

    private CommonTemplate getCommonTemplateForRefreshResource(StorageNE array) {
        CommonTemplate template = CommonTemplateManager.getInstance().getRefreshResourceCommonTemplatesByDeviceType(array.getManagementProtocol());
        if (null == template) {
            logger.error((Object)("Can not find template, templateKey=" + array.getManagementProtocol()), 90160777658372L);
            throw new LegoCheckedException(127402L);
        }
        return template;
    }
}

