/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.synchronizer;

import com.huawei.ism.cbb.proxy.service.IDevProtocolCollect;
import com.huawei.ism.cbb.proxy.service.impl.DevProtocolCollectTask;
import com.huawei.ism.cbb.proxy.service.impl.DevProtocolListener;
import com.huawei.ism.cbb.proxy.util.DevProtocolThreadPool;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.service.INodeEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class DeviceNodeEditor
implements INodeEditor {
    private static final Log LOGGER = LogFactory.getInstance(DeviceNodeEditor.class);
    private static final int TIME_OUT = 320;
    private Map<String, IDevProtocolCollect> protocolCollectMap = new HashMap<String, IDevProtocolCollect>();

    public Node editNode(Node node, DiscoveryPolicy discoveryPolicy) {
        String mainType = discoveryPolicy.getDeviceType();
        String subType = discoveryPolicy.getDeviceSubType();
        if (!"ism.deviceType.storage.mainType".equals(mainType) || !"ism.storage.manufacture.0huawei".equals(subType)) {
            return node;
        }
        this.matchProtocol(discoveryPolicy);
        String sysoid = (String)discoveryPolicy.getParamMap().get("sysOid");
        if (VerifyUtil.isEmpty((String)sysoid)) {
            LOGGER.error((Object)("sysoid is null or empty, sysoid=" + sysoid), 90160758784000L);
            throw new LegoCheckedException(1073947697L);
        }
        LOGGER.info((Object)("sysoid=" + sysoid), 90160758784000L);
        node.setSysOid(sysoid);
        return node;
    }

    private void matchProtocol(DiscoveryPolicy discoveryPolicy) {
        ArrayList<Future<String>> futureList = new ArrayList<Future<String>>();
        String protocolResult = null;
        Map<String, String> param = null;
        boolean isTimeout = true;
        try {
            DevProtocolListener listener = new DevProtocolListener(this.protocolCollectMap.size());
            for (Map.Entry<String, IDevProtocolCollect> item : this.protocolCollectMap.entrySet()) {
                DevProtocolCollectTask task = new DevProtocolCollectTask(discoveryPolicy, item.getValue(), listener);
                Future<String> future = DevProtocolThreadPool.getInstance().getCompletionService().submit(task);
                futureList.add(future);
            }
            for (int count = 0; count < 320; ++count) {
                if (listener.isFinish()) {
                    protocolResult = listener.getResultProtocol();
                    param = listener.getParam();
                    isTimeout = false;
                    break;
                }
                TimeUnit.SECONDS.sleep(1L);
            }
            if ("SMI-S".equals(protocolResult) && param != null) {
                if ("1".equals(param.get("ssl"))) {
                    protocolResult = "SMI-S-SSL";
                } else if ("0".equals(param.get("ssl"))) {
                    protocolResult = "SMI-S-NO_SSL";
                }
            }
            LOGGER.info((Object)("ip:" + discoveryPolicy.getStartIP() + " find protocol=" + protocolResult), 90160758784000L);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("ip:" + discoveryPolicy.getStartIP() + " not find protocol."), (Throwable)e, 90160758784000L);
            throw new LegoCheckedException(1073947697L, (Throwable)e);
        }
        finally {
            for (Future future : futureList) {
                future.cancel(true);
            }
        }
        if (isTimeout) {
            LOGGER.error((Object)("auto protocol matching timeout, ip:" + discoveryPolicy.getStartIP()), 90160758784000L);
            throw new LegoCheckedException(1073947433L);
        }
        if (null == protocolResult) {
            LOGGER.error((Object)("ip:" + discoveryPolicy.getStartIP() + " not find protocol."), 90160758784000L);
            throw new LegoCheckedException(1073947697L);
        }
        this.updateParams(discoveryPolicy, param);
    }

    private void updateParams(DiscoveryPolicy discoveryPolicy, Map<String, String> param) {
        Map paramMap = discoveryPolicy.getParamMap();
        if (VerifyUtil.isEmpty(param)) {
            return;
        }
        paramMap.putAll(param);
    }

    public void onBind(IDevProtocolCollect collect, Map<String, String> map) {
        if (!this.protocolCollectMap.containsKey(collect.getProtocolName())) {
            this.protocolCollectMap.put(collect.getProtocolName(), collect);
        }
        LOGGER.info((Object)("onBind protocolCollectMap size is : " + this.protocolCollectMap.size()), 90160758784000L);
    }

    public void onUnbind(IDevProtocolCollect collect, Map<String, String> map) {
        this.protocolCollectMap.remove(collect.getProtocolName());
        LOGGER.info((Object)("onUnbind protocolCollectMap size is : " + this.protocolCollectMap.size()), 90160758784000L);
    }
}

