/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.util;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.manager.proxy.ManagedObjectManagerProxy;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.util.TimeUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.ism.common.entity.components.Controller;
import com.huawei.ism.common.entity.components.TargetFcPort;
import com.huawei.ism.connection.tlv.TLVRecvData;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class DiscoverUtil {
    private static Log logger = LogFactory.getInstance((Object)new DiscoverUtil());

    public static boolean isS5600V1R1Unit(StorageUnit unit) {
        return null != unit && "S5600(V100R001)".equals(unit.getSubType());
    }

    public static NeMgrProtocolExtend parseExtendParams(SynchronizeParameter param) {
        NeMgrProtocolExtend neMgrExtend = new NeMgrProtocolExtend();
        neMgrExtend.setNetworkIpAddress(param.getDeviceIp());
        neMgrExtend.setOtherParam(param.getLocation());
        DiscoveryPolicy policy = param.getDiscoveryPolicy();
        SnmpPara sp = null;
        int snmpVer = 0;
        if (null != param.getManagementProtocolMap()) {
            sp = (SnmpPara)param.getManagementProtocolMap().get("com.huawei.lego.com.south.sdk.model.SnmpPara");
        }
        if (null != sp) {
            snmpVer = sp.getVersion();
        }
        if (null == policy || VerifyUtil.isEmpty((Map)policy.getParamMap())) {
            return neMgrExtend;
        }
        Map paramMap = policy.getParamMap();
        neMgrExtend.setNetworkUserName((String)paramMap.get("name"));
        neMgrExtend.setNetworkPassword((String)paramMap.get("password"));
        Map<String, String> extendParams = DiscoverUtil.getExtendParams(paramMap, snmpVer);
        neMgrExtend.setExtendParams(extendParams);
        logger.info((Object)"out NeMgrProtocolExtend", 90160777658372L);
        return neMgrExtend;
    }

    private static Map<String, String> getExtendParams(Map<String, String> paramMap, int snmpVer) {
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put("sslFlag", paramMap.get("ssl"));
        extendParams.put("protocol", paramMap.get("protocol"));
        extendParams.put("snmpVer", String.valueOf(snmpVer));
        if (!VerifyUtil.isEmpty((String)paramMap.get("port"))) {
            extendParams.put("port", paramMap.get("port"));
        }
        if (!VerifyUtil.isEmpty((String)paramMap.get("namespace"))) {
            extendParams.put("namespace", paramMap.get("namespace"));
        }
        DiscoverUtil.extractOceanProtectAuthParams(paramMap, extendParams);
        extendParams.put("isFirstBuildTlv", "isFirstBuild");
        return extendParams;
    }

    private static void extractOceanProtectAuthParams(Map<String, String> paramMap, Map<String, String> extendParams) {
        if (paramMap.containsKey("OceanProtectPort")) {
            extendParams.put("OceanProtectPort", paramMap.get("OceanProtectPort"));
        }
        if (paramMap.containsKey("OceanProtectUsername")) {
            extendParams.put("OceanProtectUsername", paramMap.get("OceanProtectUsername"));
        }
        if (paramMap.containsKey("OceanProtectPassword")) {
            extendParams.put("OceanProtectPassword", paramMap.get("OceanProtectPassword"));
        }
    }

    public static NeMgrProtocolExtend parseHuaweiStorageParams(SynchronizeParameter param) {
        NeMgrProtocolExtend neMgrExtend = new NeMgrProtocolExtend();
        neMgrExtend.setNetworkIpAddress(param.getDeviceIp());
        neMgrExtend.setOtherParam(param.getLocation());
        DiscoveryPolicy policy = param.getDiscoveryPolicy();
        if (null == policy || VerifyUtil.isEmpty((Map)policy.getParamMap())) {
            return neMgrExtend;
        }
        Map extendParams = neMgrExtend.getExtendParams();
        Map paramMap = policy.getParamMap();
        String protocol = (String)paramMap.get("protocol");
        extendParams.put("protocol", protocol);
        if ("DEFAULT".equals(protocol) || "REST".equals(protocol) || "FSB-REST".equals(protocol)) {
            neMgrExtend = DiscoverUtil.parseExtendParams(param);
            neMgrExtend.getExtendParams().put("protocol", protocol);
        }
        return neMgrExtend;
    }

    public static void refreshEntityBySystem(NetworkEntity networkEntity) {
        if (null == networkEntity) {
            logger.info((Object)"The device is NOT found ! ", 90160777658624L);
            return;
        }
        try {
            CommonTemplate template = CommonTemplateManager.getInstance().getTemplate(networkEntity, 2);
            DiscoverUtil.submitBackTask(networkEntity, template);
            logger.info((Object)("System refresh device " + networkEntity.getName() + " by ism msg trap finished."), 90160777658642L);
        }
        catch (Exception e) {
            logger.error((Object)("System refresh device " + networkEntity.getName() + " by ism msg trap failed."), 90160777658642L);
        }
    }

    public static void setMosOffline(NetworkEntity networkEntity) {
        DiscoverUtil.updateNetworkEntityStatus(networkEntity, -1);
    }

    private static void submitBackTask(final NetworkEntity networkEntity, final CommonTemplate template) {
        if (null == template) {
            logger.error((Object)"template is null.", 90160758784000L);
            return;
        }
        BackTask bt = BackTaskUtil.buildBackTask((String)networkEntity.getName(), (String)"ism.discover.refresh.operationName", (String)"System", (String)"", null);
        int timeout = ManagedObjectManagerProxy.getInstance().getMgr((ManagedObject)networkEntity).getTimeout();
        AbstractBackTask task = new AbstractBackTask(networkEntity.getUuid(), bt, timeout, true){

            protected void doWork() {
                RefreshContext refreshContext = new RefreshContext((ManagedObject)networkEntity);
                refreshContext.setAttribute("refreshTask", (Object)this);
                template.process(refreshContext);
            }
        };
        BackTaskHandler.getInstance().submitTask(task);
    }

    public static void updateNetworkEntityStatus(NetworkEntity networkEntity, int status) {
        if (null == networkEntity) {
            logger.error((Object)"the NetworkEntity object is null.");
            throw new LegoCheckedException(1073947393L);
        }
        logger.debug((Object)("update ne status, mainType=" + networkEntity.getMainType() + ", sn=" + networkEntity.getSn() + ", ip=" + networkEntity.getIpAddress() + ", status=" + status));
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HibernateTemplate template = moDao.getHibernateTemplate();
        template.execute(session -> {
            String hql = "update ManagedObject set status=? where uuid=?";
            Query query = session.createQuery(hql);
            query.setInteger(0, status);
            query.setParameter(1, (Object)networkEntity.getUuid());
            query.executeUpdate();
            return null;
        });
    }

    public static void updateTimeZoneToMo(ManagedObject mo, String deviceId) {
        Launcher launcher = LauncherManager.getInstance().getLauncher(deviceId);
        TimeZone timeZone = TimeZone.getDefault();
        if (null != launcher && null != launcher.getDeviceTimeZone()) {
            timeZone = launcher.getDeviceTimeZone();
        }
        String timezoneFormat = TimeUtil.getTimeZoneOffset((TimeZone)timeZone);
        mo.setTimezoneFormat(timezoneFormat);
    }

    public static boolean updateAlarmSource(String oldName, String newName, TopoObject topoObjectInDB) {
        if (null == oldName || null == newName) {
            return false;
        }
        if (!oldName.trim().equals(newName.trim())) {
            logger.info((Object)("New name is " + newName + ", old name is " + oldName), 90160758784256L);
            try {
                topoObjectInDB.setName(newName);
                ServiceContext context = ServiceContext.getInstance();
                IAlarmService alarmService = (IAlarmService)context.lookup("fault/alarmService");
                alarmService.updateFault(topoObjectInDB);
                logger.info((Object)("Array name has been changed, old name is " + oldName + ", new name is " + newName), 90160758784256L);
                return true;
            }
            catch (Exception e) {
                logger.info((Object)("Failed to update alarm sources. Array name has been changed, old name is " + oldName + ", new name is " + newName), 90160758784257L);
            }
        }
        return false;
    }

    public static void grantUserNeAuthority(NetworkEntity entity, Long userId) {
        if (null == userId) {
            logger.info((Object)"This may be a refresh progress, userId is null.", 90160758784000L);
            return;
        }
        IUserMgr userMgr = (IUserMgr)ServiceLocator.getInstance().getService(IUserMgr.class);
        logger.info((Object)("Grant for user=" + userId + ", moId=" + entity.getMoId() + ", sn=" + entity.getSn()), 90160758784000L);
        if (userMgr.checkUserIsAdmin(userId.longValue()).booleanValue()) {
            return;
        }
        HashSet<Long> moIds = new HashSet<Long>();
        moIds.add(entity.getMoId());
        userMgr.grandObjectToUser(userId.longValue(), moIds);
    }

    public static void parseFcMode(Controller controller, TargetFcPort targetFcPort, List<TLVRecvData> recvDatas) {
        if (null == controller || null == targetFcPort || VerifyUtil.isEmpty(recvDatas)) {
            logger.info((Object)"the controller or targetFcPort or recvDatas is null ", 90160777658389L);
            return;
        }
        for (TLVRecvData recvData : recvDatas) {
            if (recvData.getUint32Property(0) != controller.getControllerId() || recvData.getUint32Property(1) != targetFcPort.getBoardID() || recvData.getUint32Property(2) != targetFcPort.getPortID()) continue;
            targetFcPort.setFcPortMode(TypeEnum.FCModeType.getFCModeType((int)((int)recvData.getUint32Property(3))));
            break;
        }
    }

    public static void updateOceanProtectStatus(NetworkEntity networkEntity, int status) {
        if (VerifyUtil.isEmpty((Object)networkEntity)) {
            logger.error((Object)"The NetworkEntity object is null.");
            throw new LegoCheckedException(1073947393L);
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HibernateTemplate template = moDao.getHibernateTemplate();
        template.execute(session -> {
            String hql = "update NetworkEntity set devStatus=? where uuid=?";
            Query query = session.createQuery(hql);
            query.setParameter(0, (Object)status);
            query.setParameter(1, (Object)networkEntity.getUuid());
            query.executeUpdate();
            return null;
        });
    }
}

