/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.util;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class IpUtil {
    private static final int DEFAULT_PING_TIMEOUT = 20000;
    private static Log logger = LogFactory.getInstance(IpUtil.class);

    public static List<String> getMgrIps(NetworkEntity networkEntity) {
        String linkIp = networkEntity.getLinkIp();
        String mgrIps = networkEntity.getManagedIps();
        List<String> temp = IpUtil.getMgrIps(linkIp, mgrIps);
        return temp;
    }

    public static List<String> getMgrIps(StorageUnit storageUnit) {
        String linkIp = storageUnit.getLinkIp();
        String mgrIps = storageUnit.getManageIps();
        List<String> temp = IpUtil.getMgrIps(linkIp, mgrIps);
        return temp;
    }

    private static List<String> getMgrIps(String linkIp, String mgrIps) {
        HashSet<String> temp = new HashSet<String>();
        temp.add(linkIp.trim());
        if (mgrIps != null) {
            String[] ips;
            for (String ip : ips = mgrIps.split("\\,")) {
                temp.add(ip.trim());
            }
        }
        return Arrays.asList(temp.toArray(new String[temp.size()]));
    }

    private static boolean isReachableIp(String ip) {
        if (VerifyUtil.isEmpty((String)ip)) {
            return false;
        }
        try {
            if (InetAddress.getByName(ip).isReachable(20000)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Ping fail, the IP is " + ip + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
        }
        return false;
    }

    public static List<String> pingDevice(NetworkEntity networkEntity) {
        return IpUtil.pingDeviceInternal(networkEntity);
    }

    private static List<String> pingDeviceInternal(NetworkEntity networkEntity) {
        ArrayList<String> reachableIps = new ArrayList<String>();
        List<String> ips = IpUtil.getMgrIps(networkEntity);
        for (String ip : ips) {
            if (!IpUtil.isReachableIp(ip)) continue;
            reachableIps.add(ip);
        }
        return reachableIps;
    }
}

