/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve;

import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.discover.service.impl.XveDeviceProxyImpl;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.ConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.IConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnectionImpl;
import com.huawei.ism.cbb.proxy.protocol.tlv.exception.TLVException;
import com.huawei.ism.cbb.proxy.service.IConnectionManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.connection.smis.Connection;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import java.util.Properties;

public class ConnectionManagerTlvImpl
implements IConnectionManager {
    private static final Log logger = LogFactory.getInstance(ConnectionManagerTlvImpl.class, (String)"UBase/Xve_Discover");

    public ConnectionManagerTlvImpl() {
        ConnectionManager.getInstance().registerConnectionClass(DeviceType.C3.name(), TLVConnectionImpl.class);
    }

    @Override
    public StorageNE connect(List<String> manageIps, NeMgrProtocolExtend neMgrProtocolExtend) {
        logger.debug((Object)("Thread [" + Thread.currentThread().getName() + "] Try to Get a new Connection."), 90160777658372L);
        Properties properties = ConnectionManagerTlvImpl.initProperties(neMgrProtocolExtend);
        TLVConnection connection = null;
        String avaliableIp = null;
        for (String manageIp : manageIps) {
            properties.put("IP_OR_NAME", manageIp);
            try {
                connection = (TLVConnection)ConnectionManager.getInstance().buildConnection(DeviceType.C3.name(), properties);
                connection.authenticate();
                avaliableIp = manageIp;
                break;
            }
            catch (TLVException ex) {
                if (null != connection) {
                    connection.close();
                }
                TLVException tlvException = ex;
                logger.error((Object)("TLVException ErrorCode:" + tlvException.getErrorId() + " Exception:" + ex.toString()), 90160777658373L);
                if (this.isConnectException(tlvException)) continue;
                if (1077949057L == tlvException.getErrorId() || 1077949061L == tlvException.getErrorId()) {
                    throw new LegoCheckedException(0x500050DL, (Throwable)ex);
                }
                throw new LegoCheckedException(tlvException.getErrorId(), (Throwable)ex);
            }
            catch (Exception ex) {
                if (null != connection) {
                    connection.close();
                }
                logger.error((Object)("ConnectionManagerTlvImpl Exception:" + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
            }
        }
        if (avaliableIp == null) {
            return null;
        }
        XveDeviceProxyImpl xveDeviceProxy = new XveDeviceProxyImpl();
        XveUnit xveUnit = xveDeviceProxy.getComputerSystem(connection);
        String deviceId = xveUnit.getDevSn();
        ConnectionManager.getInstance().setConnection(deviceId, connection);
        StorageNE storage = new StorageNE();
        storage.setSn(xveUnit.getDevSn());
        storage.setProductModel(xveUnit.getProductModel());
        storage.setVersion(xveUnit.getProductVersion());
        storage.setLinkIp(avaliableIp);
        storage.setIpAddress(avaliableIp);
        storage.setSubType(xveUnit.getSubType());
        storage.setUuid("XveStorage" + xveUnit.getUuid());
        logger.info((Object)("Connect success, devSn=" + xveUnit.getDevSn() + ", ip=" + xveUnit.getLinkIp()), 90160777658372L);
        return storage;
    }

    private static Properties initProperties(NeMgrProtocolExtend neMgrProtocolExtend) {
        Properties properties = new Properties();
        properties.put("USER_NAME", neMgrProtocolExtend.getNetworkUserName());
        properties.put("PASSWORD", neMgrProtocolExtend.getNetworkPassword());
        properties.put("USERSCOPE", "0");
        properties.put("PORT", "8080");
        properties.put("CONN_PROTOCOL", (Object)1);
        return properties;
    }

    @Override
    public Connection getConnection(String devSn) {
        return null;
    }

    @Override
    public boolean isConnected(String devSn) {
        IConnection connection = ConnectionManager.getInstance().getConnection(devSn);
        return null != connection && connection.getConnectionState() == IConnection.ConnectionState.Connected;
    }

    @Override
    public void removeConnection(String devSn) {
    }

    private boolean isConnectException(TLVException exception) {
        return 0x100000001L == exception.getErrorId() || 0x1005001L == exception.getErrorId() || 16797698L == exception.getErrorId() || 83887501L == exception.getErrorId();
    }

    public void managerConn(String deviceId, TLVConnection connection, NeMgrProtocolExtend neMgrProtocolExtend) {
        if (VerifyUtil.isEmpty((String)deviceId) || null == connection || null == neMgrProtocolExtend) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String isFirstBuild = (String)neMgrProtocolExtend.getExtendParams().get("isFirstBuildTlv");
        logger.debug((Object)("Get isFirstBuild=[" + isFirstBuild + "]"), 90160777658372L);
        if (!VerifyUtil.isEmpty((String)isFirstBuild)) {
            neMgrProtocolExtend.getExtendParams().remove("isFirstBuildTlv");
            logger.info((Object)("After Remove isFirstBuild=[" + (String)neMgrProtocolExtend.getExtendParams().get("isFirstBuildTlv") + "]"), 90160777658372L);
            try {
                IConnection.ConnectionState conState = connection.getConnectionState();
                String conURL = connection.getUrl();
                connection.close();
                logger.debug((Object)("ConnectionState is [" + (Object)((Object)conState) + " @" + conURL + "]"), 90160777658372L);
            }
            catch (Exception ex) {
                logger.error((Object)("Close connection Error." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
            }
        } else {
            TLVConnection oldConnection = (TLVConnection)ConnectionManager.getInstance().getConnection(deviceId);
            if (oldConnection != null) {
                this.removeConnection(deviceId);
            }
            ConnectionManager.getInstance().setConnection(deviceId, connection);
        }
    }

    public static void validate(NeMgrProtocolExtend neMgrProtocolExtend) {
        if (null == neMgrProtocolExtend) {
            logger.error((Object)"error parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        Properties properties = ConnectionManagerTlvImpl.initProperties(neMgrProtocolExtend);
        properties.put("IP_OR_NAME", neMgrProtocolExtend.getNetworkIpAddress());
        TLVConnection connection = null;
        try {
            connection = (TLVConnection)ConnectionManager.getInstance().buildConnection(DeviceType.C3.name(), properties);
            connection.authenticate();
        }
        catch (TLVException ex) {
            logger.error((Object)("tlv authenticate failed, ip=" + neMgrProtocolExtend.getNetworkIpAddress()), (Throwable)ex);
            throw new LegoCheckedException(ex.getErrorId(), (Throwable)ex);
        }
        finally {
            if (null != connection) {
                connection.close();
            }
        }
    }
}

