/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.exception;

import com.huawei.ism.exception.IsmException;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class ErrorCodeException
extends LegoCheckedException {
    private static final long serialVersionUID = 6628189138551328846L;
    private static Map<Locale, ResourceBundle> errorPool = new HashMap<Locale, ResourceBundle>();
    private long errorCode = 0L;

    public ErrorCodeException(long errorCode) {
        super(errorCode);
        this.errorCode = errorCode;
    }

    public ErrorCodeException(long errorCode, String[] parameter) {
        super(errorCode, parameter);
        this.errorCode = errorCode;
    }

    public ErrorCodeException(IsmException ismException) {
        super(ismException.getErrorId(), ismException.getErrorMessage());
        this.setAccessoryResult(ismException.getOperationObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getErrorMessage(Locale locale) {
        String code = String.valueOf(this.errorCode);
        String errorMessage = "";
        Class<ErrorCodeException> clazz = ErrorCodeException.class;
        synchronized (ErrorCodeException.class) {
            ResourceBundle bundle = errorPool.get(locale);
            if (null == bundle) {
                bundle = ResourceBundle.getBundle("config.platform.resource.languages.errorInfo", locale);
            }
            if (null != bundle) {
                errorPool.put(locale, bundle);
                try {
                    errorMessage = bundle.getString(code);
                }
                catch (Exception e) {
                    errorMessage = "errorCode:" + code;
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return errorMessage;
        }
    }

    public String getErrorDescription(Locale locale) {
        return this.getErrorMessage(locale);
    }
}

