/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.rest;

import com.huawei.ism.cbb.proxy.protocol.rest.RestRequestData;
import com.huawei.ism.cbb.proxy.protocol.rest.RestResponseData;
import com.huawei.ism.cbb.util.BufferedReaderDecorator;
import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.ism.util.CommonUtil;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.ssl.SSLInitializationException;

public final class RestClient {
    public static final String OCEAN_PROTECT_PLATFORM = "Ocean Protect";
    private static final Log LOGGER = LogFactory.getInstance(RestClient.class);
    private static final int DEFAULT_VALUE_10 = 10;
    private static final int DEFAULT_VALUE_30 = 30;
    private static final int DEFAULT_VALUE_1000 = 1000;
    private static final int DEFAULT_VALUE_60 = 60;
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READDATA_TIMEOUT = 1800000;
    private static final int MAX_RETRY_TIME = 3;
    private static final long NEED_RETRY_TIME = 600000L;
    private static final int MAX_TOTAL = 2000;
    private static final int DEFAULT_MAX_PER_ROUTE = 200;
    private static final String TLS_V1_2 = "TLSv1.2";

    public static CloseableHttpClient buildHttpClient(String ip, String port) {
        SSLContext context = RestClient.getSslContext(ip, port);
        String[] supportedProtocols = new String[]{TLS_V1_2};
        SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(context, supportedProtocols, null, (HostnameVerifier)new NoopHostnameVerifier());
        Registry registry = RegistryBuilder.create().register("https", (Object)sslFactory).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(registry);
        connMgr.setMaxTotal(2000);
        connMgr.setDefaultMaxPerRoute(200);
        RequestConfig requestConfig = RestClient.getRequestConfig();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connMgr).disableContentCompression().build();
    }

    private static RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(30000L, TimeUnit.MILLISECONDS).setConnectionRequestTimeout(1800000L, TimeUnit.MILLISECONDS).setResponseTimeout(1800000L, TimeUnit.MILLISECONDS).build();
    }

    public static CloseableHttpAsyncClient buildHttpAsyncClient(String ip, String port) {
        CloseableHttpAsyncClient httpclientAsync;
        try {
            SSLContext sslcontext = RestClient.getSslContext(ip, port);
            String[] supportedProtocols = new String[]{TLS_V1_2};
            TlsStrategy strategy = ClientTlsStrategyBuilder.create().setSslContext(sslcontext).setTlsVersions(supportedProtocols).build();
            PoolingAsyncClientConnectionManager connMgrAsync = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(strategy).setMaxConnTotal(2000).setMaxConnPerRoute(200).build();
            RequestConfig requestConfig = RestClient.getRequestConfig();
            httpclientAsync = HttpAsyncClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager((AsyncClientConnectionManager)connMgrAsync).build();
        }
        catch (SSLInitializationException e) {
            LOGGER.error((Object)"BuildHttpAsyncClient no algorithm error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073947393L, "build httpclientAsync failed", (Throwable)e);
        }
        return httpclientAsync;
    }

    /*
     * Exception decompiling
     */
    public static RestResponseData processRequest(CloseableHttpClient httpclient, RestRequestData request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void releaseConnection(HttpUriRequestBase httpRequest) {
        if (httpRequest == null) {
            LOGGER.error((Object)"httpRequest is null.");
            return;
        }
        try {
            httpRequest.cancel();
        }
        catch (Exception ex) {
            LOGGER.error((Object)("release connection error." + ExceptionUtil.getErrorMessage((Throwable)ex)));
        }
    }

    private static HttpUriRequestBase buildHttpRequest(String method, String url, RestRequestData request) {
        HttpGet httpRequest;
        if ("GET".equals(method)) {
            httpRequest = new HttpGet(url);
        } else if ("POST".equals(method)) {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(request.getBody(), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            httpRequest = httpPost;
        } else if ("PUT".equals(method)) {
            HttpPut httpPut = new HttpPut(url);
            StringEntity stringEntity = new StringEntity(request.getBody(), ContentType.APPLICATION_JSON);
            httpPut.setEntity((HttpEntity)stringEntity);
            httpRequest = httpPut;
        } else if ("DELETE".equals(method)) {
            HttpDelete httpDelete = new HttpDelete(url);
            if (!VerifyUtil.isEmpty((String)request.getBody())) {
                StringEntity stringEntity = new StringEntity(request.getBody(), ContentType.APPLICATION_JSON);
                httpDelete.setEntity((HttpEntity)stringEntity);
            }
            httpRequest = httpDelete;
        } else {
            LOGGER.error((Object)"Illegal method: %s", new Object[]{method});
            throw new LegoCheckedException(1073947393L);
        }
        return httpRequest;
    }

    private static void receiveResponse(RestResponseData response, CloseableHttpResponse httpResponse, String platformType) throws IOException {
        if (OCEAN_PROTECT_PLATFORM.equals(platformType)) {
            RestClient.receiveOceanProtectResponse(response, httpResponse);
        } else {
            RestClient.receiveResponse(response, httpResponse);
        }
    }

    private static void receiveOceanProtectResponse(RestResponseData response, CloseableHttpResponse httpResponse) throws IOException {
        int statusCode = httpResponse.getCode();
        response.setHttpStatusCode(statusCode);
        if ((long)statusCode == 404L) {
            LOGGER.error((Object)String.format("Http status code is: %s", statusCode));
            throw new LegoCheckedException(404L);
        }
        RestClient.parseResponseContent(response, httpResponse);
    }

    private static void receiveResponse(RestResponseData response, CloseableHttpResponse httpResponse) throws IOException {
        int statusCode = httpResponse.getCode();
        response.setHttpStatusCode(statusCode);
        if (statusCode >= 200 && statusCode < 300) {
            RestClient.parseResponseContent(response, httpResponse);
            response.setSuccess(true);
        }
        if ((long)statusCode == 404L) {
            LOGGER.error((Object)String.format("Http status code is: %s", statusCode));
            throw new LegoCheckedException(404L);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseResponseContent(RestResponseData response, CloseableHttpResponse httpResponse) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            HttpEntity entity = httpResponse.getEntity();
            reader = new BufferedReader(new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8));
            BufferedReaderDecorator decorator = new BufferedReaderDecorator(reader);
            StringBuilder sb = new StringBuilder();
            while ((line = decorator.readLine()) != null) {
                sb.append(line).append("\n");
            }
            response.setBody(sb.toString());
            Header[] httpHeaders = httpResponse.getHeaders();
            RestClient.setResponse(response, httpHeaders);
            if (reader == null) return;
        }
        catch (UnsupportedEncodingException e) {
            try {
                LOGGER.error((Object)"Get exception, errorMsg: %s", new Object[]{e.getMessage()});
                response.setSuccess(false);
                throw e;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                CommonUtil.closeReader(reader);
                throw throwable;
            }
        }
        CommonUtil.closeReader((Reader)reader);
        return;
    }

    private static void setResponse(RestResponseData response, Header[] httpHeaders) {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        if (null != httpHeaders && httpHeaders.length > 0) {
            for (Header header : httpHeaders) {
                String name = header.getName();
                String value = header.getValue();
                ArrayList<String> values = (ArrayList<String>)headerMap.get(name);
                if (CollectionUtils.isEmpty((Collection)values)) {
                    values = new ArrayList<String>();
                    headerMap.put(name, values);
                }
                values.add(value);
            }
        }
        response.setHeaders(headerMap);
    }

    private static void setHttpHeaders(RestRequestData request, HttpUriRequestBase httpRequest) {
        Map<String, String> headers = request.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpRequest.addHeader(entry.getKey(), (Object)entry.getValue());
            }
        }
        String requestDate = RestClient.getHttpRequestDate();
        httpRequest.addHeader("Date", (Object)requestDate);
        httpRequest.addHeader("Host", (Object)request.getHostName());
    }

    private static SSLContext getSslContext(String ip, String port) {
        SSLContext context;
        try {
            context = SSLContext.getInstance("TLS");
            SecureRandom random = SecureRandomFactory.getInstanceStrongWithDRBG();
            context.init(null, new TrustManager[]{new BcmX509TrustManager(ip, port)}, random);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new LegoCheckedException(-1L, "Create SSL context fail,ipAddress:" + ip + ExceptionUtil.getErrorMessage((Throwable)e));
        }
        return context;
    }

    private static String getHttpRequestDate() {
        Locale aLocale = Locale.US;
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z", new DateFormatSymbols(aLocale));
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        return fmt.format(new Date());
    }
}

